/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.southbound.device.factory.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.eclipse.sensinact.core.push.DataUpdate;
import org.eclipse.sensinact.core.push.dto.BulkGenericDto;
import org.eclipse.sensinact.core.push.dto.GenericDto;
import org.eclipse.sensinact.gateway.geojson.Point;
import org.eclipse.sensinact.gateway.southbound.device.factory.IDeviceMappingParser;
import org.eclipse.sensinact.gateway.southbound.device.factory.dto.DeviceMappingConfigurationDTO;
import org.eclipse.sensinact.gateway.southbound.device.factory.impl.DeviceMappingParserReference;
import org.eclipse.sensinact.gateway.southbound.device.factory.impl.FactoryParserHandler;
import org.eclipse.sensinact.gateway.southbound.device.factory.parser.csv.CsvParser;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentServiceObjects;
import org.osgi.util.promise.Promises;

public class CSVParserTest {
    private FactoryParserHandler deviceMapper;
    private ComponentServiceObjects<IDeviceMappingParser> cso;
    private List<BulkGenericDto> bulks = new ArrayList<BulkGenericDto>();

    @BeforeEach
    void start() throws InterruptedException {
        this.deviceMapper = new FactoryParserHandler();
        this.deviceMapper.dataUpdate = (DataUpdate)Mockito.mock(DataUpdate.class);
        Mockito.when((Object)this.deviceMapper.dataUpdate.pushUpdate(Mockito.any())).thenAnswer(i -> {
            BulkGenericDto dto = (BulkGenericDto)i.getArgument(0, BulkGenericDto.class);
            this.bulks.add(dto);
            return Promises.resolved((Object)dto);
        });
        final CsvParser parser = new CsvParser();
        final DeviceMappingParserReference svcRef = new DeviceMappingParserReference();
        this.cso = new ComponentServiceObjects<IDeviceMappingParser>(){

            public IDeviceMappingParser getService() {
                return parser;
            }

            public ServiceReference<IDeviceMappingParser> getServiceReference() {
                return svcRef;
            }

            public void ungetService(IDeviceMappingParser service) {
            }
        };
        this.deviceMapper.addParser(this.cso, Map.of("sensinact.southbound.mapping.parser", "csv"));
    }

    @AfterEach
    void stop() {
        this.deviceMapper.removeParser(this.cso, Map.of("sensinact.southbound.mapping.parser", "csv"));
        this.deviceMapper = null;
        this.cso = null;
        this.bulks.clear();
    }

    byte[] readFile(String filename) throws IOException {
        try (InputStream inStream = this.getClass().getClassLoader().getResourceAsStream(filename);){
            byte[] byArray = inStream.readAllBytes();
            return byArray;
        }
    }

    DeviceMappingConfigurationDTO readConfiguration(String filename) throws IOException {
        return (DeviceMappingConfigurationDTO)new ObjectMapper().readValue(this.readFile(filename), DeviceMappingConfigurationDTO.class);
    }

    GenericDto getResourceValue(String provider, String service, String resource) {
        for (BulkGenericDto bulk : this.bulks) {
            for (GenericDto dto : bulk.dtos) {
                if (!dto.provider.equals(provider) || !dto.service.equals(service) || !dto.resource.equals(resource)) continue;
                return dto;
            }
        }
        return null;
    }

    <T> T getResourceValue(String provider, String service, String resource, Class<T> rcType) {
        GenericDto dto = this.getResourceValue(provider, service, resource);
        if (dto != null && dto.value != null) {
            return rcType.cast(dto.value);
        }
        return null;
    }

    @Test
    void testNoHeader() throws Exception {
        String provider1 = "no-header-provider1";
        String provider2 = "no-header-provider2";
        DeviceMappingConfigurationDTO config = this.readConfiguration("csv/csv-no-header-mapping.json");
        byte[] fileContent = this.readFile("csv/csv-no-header.csv");
        this.deviceMapper.handle(config, Map.of(), fileContent);
        Assertions.assertEquals((Object)"42", (Object)this.getResourceValue("no-header-provider1", "data", "value", String.class));
        Assertions.assertEquals((Object)"84", (Object)this.getResourceValue("no-header-provider2", "data", "value", String.class));
        Instant timestamp1 = Instant.from(LocalDateTime.of(2021, 10, 20, 18, 14, 0).atOffset(ZoneOffset.UTC));
        Assertions.assertEquals((Object)timestamp1, (Object)this.getResourceValue((String)"no-header-provider1", (String)"data", (String)"value").timestamp);
        Instant timestamp2 = Instant.from(LocalDateTime.of(2021, 10, 20, 18, 17, 0).atOffset(ZoneOffset.UTC));
        Assertions.assertEquals((Object)timestamp2, (Object)this.getResourceValue((String)"no-header-provider2", (String)"data", (String)"value").timestamp);
        GenericDto location1 = this.getResourceValue("no-header-provider1", "admin", "location");
        Assertions.assertEquals((Object)timestamp1, (Object)location1.timestamp);
        Assertions.assertNotNull((Object)location1.value);
        Point geoPoint = (Point)location1.value;
        Assertions.assertEquals((double)1.2, (double)geoPoint.coordinates.latitude, (double)0.001);
        Assertions.assertEquals((double)3.4, (double)geoPoint.coordinates.longitude, (double)0.001);
        Assertions.assertTrue((boolean)Double.isNaN(geoPoint.coordinates.elevation));
        GenericDto location2 = this.getResourceValue("no-header-provider2", "admin", "location");
        Assertions.assertNotNull((Object)location2.value);
        Assertions.assertEquals((Object)timestamp2, (Object)location2.timestamp);
        geoPoint = (Point)location2.value;
        Assertions.assertEquals((double)5.6, (double)geoPoint.coordinates.latitude, (double)0.001);
        Assertions.assertEquals((double)7.8, (double)geoPoint.coordinates.longitude, (double)0.001);
        Assertions.assertTrue((boolean)Double.isNaN(geoPoint.coordinates.elevation));
    }

    @Test
    void testWithHeader() throws Exception {
        String provider1 = "header-provider1";
        String provider2 = "header-provider2";
        DeviceMappingConfigurationDTO config = this.readConfiguration("csv/csv-header-mapping.json");
        byte[] fileContent = this.readFile("csv/csv-header.csv");
        this.deviceMapper.handle(config, Map.of(), fileContent);
        Assertions.assertEquals((Object)"42", (Object)this.getResourceValue("header-provider1", "data", "value", String.class));
        Assertions.assertEquals((Object)"84", (Object)this.getResourceValue("header-provider2", "data", "value", String.class));
        Instant timestamp1 = Instant.from(LocalDateTime.of(2021, 10, 20, 18, 14, 0).atOffset(ZoneOffset.UTC));
        Assertions.assertEquals((Object)timestamp1, (Object)this.getResourceValue((String)"header-provider1", (String)"data", (String)"value").timestamp);
        Instant timestamp2 = Instant.from(LocalDateTime.of(2021, 10, 20, 18, 17, 0).atOffset(ZoneOffset.UTC));
        Assertions.assertEquals((Object)timestamp2, (Object)this.getResourceValue((String)"header-provider2", (String)"data", (String)"value").timestamp);
        GenericDto location1 = this.getResourceValue("header-provider1", "admin", "location");
        Assertions.assertEquals((Object)timestamp1, (Object)location1.timestamp);
        Assertions.assertNotNull((Object)location1.value);
        Point geoPoint = (Point)location1.value;
        Assertions.assertEquals((double)1.2, (double)geoPoint.coordinates.latitude, (double)0.001);
        Assertions.assertEquals((double)3.4, (double)geoPoint.coordinates.longitude, (double)0.001);
        Assertions.assertTrue((boolean)Double.isNaN(geoPoint.coordinates.elevation));
        GenericDto location2 = this.getResourceValue("header-provider2", "admin", "location");
        Assertions.assertNotNull((Object)location2.value);
        Assertions.assertEquals((Object)timestamp2, (Object)location2.timestamp);
        geoPoint = (Point)location2.value;
        Assertions.assertEquals((double)5.6, (double)geoPoint.coordinates.latitude, (double)0.001);
        Assertions.assertEquals((double)7.8, (double)geoPoint.coordinates.longitude, (double)0.001);
        Assertions.assertTrue((boolean)Double.isNaN(geoPoint.coordinates.elevation));
    }

    @Test
    void testTyped() throws Exception {
        String provider1 = "typed-provider1";
        String provider2 = "typed-provider2";
        DeviceMappingConfigurationDTO config = this.readConfiguration("csv/csv-header-typed-mapping.json");
        byte[] fileContent = this.readFile("csv/csv-header-typed.csv");
        this.deviceMapper.handle(config, Map.of(), fileContent);
        Assertions.assertEquals((int)42, (Integer)this.getResourceValue("typed-provider1", "data", "value", Integer.class));
        Assertions.assertEquals((int)84, (Integer)this.getResourceValue("typed-provider2", "data", "value", Integer.class));
        Instant timestamp1 = Instant.from(LocalDateTime.of(2021, 10, 20, 18, 14, 0).atOffset(ZoneOffset.UTC));
        Assertions.assertEquals((Object)timestamp1, (Object)this.getResourceValue((String)"typed-provider1", (String)"data", (String)"value").timestamp);
        Instant timestamp2 = Instant.from(LocalDateTime.of(2021, 10, 20, 18, 17, 0).atOffset(ZoneOffset.UTC));
        Assertions.assertEquals((Object)timestamp2, (Object)this.getResourceValue((String)"typed-provider2", (String)"data", (String)"value").timestamp);
        GenericDto location1 = this.getResourceValue("typed-provider1", "admin", "location");
        Assertions.assertEquals((Object)timestamp1, (Object)location1.timestamp);
        Assertions.assertNotNull((Object)location1.value);
        Point geoPoint = (Point)location1.value;
        Assertions.assertEquals((double)1.2, (double)geoPoint.coordinates.latitude, (double)0.001);
        Assertions.assertEquals((double)3.4, (double)geoPoint.coordinates.longitude, (double)0.001);
        Assertions.assertTrue((boolean)Double.isNaN(geoPoint.coordinates.elevation));
        GenericDto location2 = this.getResourceValue("typed-provider2", "admin", "location");
        Assertions.assertNotNull((Object)location2.value);
        Assertions.assertEquals((Object)timestamp2, (Object)location2.timestamp);
        geoPoint = (Point)location2.value;
        Assertions.assertEquals((double)5.6, (double)geoPoint.coordinates.latitude, (double)0.001);
        Assertions.assertEquals((double)7.8, (double)geoPoint.coordinates.longitude, (double)0.001);
        Assertions.assertTrue((boolean)Double.isNaN(geoPoint.coordinates.elevation));
    }

    @Test
    void testLiteral() throws Exception {
        String provider1 = "literal-provider1";
        String provider2 = "literal-provider2";
        String literalProvider = "literal-provider";
        DeviceMappingConfigurationDTO config = this.readConfiguration("csv/csv-literal-typed-mapping.json");
        for (String fileName : List.of("csv-header-typed", "csv-literal")) {
            byte[] rawfileContent = this.readFile("csv/" + fileName + ".csv");
            String fileContent = new String(rawfileContent, StandardCharsets.UTF_8);
            this.deviceMapper.handle(config, Map.of(), fileContent.replace("typed-", "literal-").getBytes(StandardCharsets.UTF_8));
        }
        Assertions.assertEquals((int)42, (Integer)this.getResourceValue("literal-provider1", "data", "value", Integer.class));
        Assertions.assertEquals((int)84, (Integer)this.getResourceValue("literal-provider2", "data", "value", Integer.class));
        Assertions.assertEquals((int)21, (Integer)this.getResourceValue("literal-provider", "data", "value", Integer.class));
        String constantValue = "Grenoble";
        Assertions.assertEquals((Object)"Grenoble", (Object)this.getResourceValue("literal-provider1", "sensor", "city", String.class));
        Assertions.assertEquals((Object)"Grenoble", (Object)this.getResourceValue("literal-provider2", "sensor", "city", String.class));
        Assertions.assertEquals((Object)"Grenoble", (Object)this.getResourceValue("literal-provider", "sensor", "city", String.class));
        String defaultValue = "n/a";
        Assertions.assertEquals((Object)"n/a", (Object)this.getResourceValue("literal-provider1", "sensor", "street", String.class));
        Assertions.assertEquals((Object)"n/a", (Object)this.getResourceValue("literal-provider2", "sensor", "street", String.class));
        Assertions.assertEquals((Object)"Cours B\u00e9riat", (Object)this.getResourceValue("literal-provider", "sensor", "street", String.class));
    }

    @Test
    void testIsolatedValue() throws Exception {
        String provider = "isolated-value-" + String.valueOf(new Random().nextInt());
        DeviceMappingConfigurationDTO config = this.readConfiguration("csv/isolated-value-mapping.json");
        byte[] fileContent = this.readFile("csv/isolated-value.csv");
        this.deviceMapper.handle(config, Map.of("provider", provider), fileContent);
        Assertions.assertEquals((Object)"37.5", (Object)this.getResourceValue(provider, "data", "value", String.class));
    }

    @Test
    void testIsolatedValueTyped() throws Exception {
        String provider = "isolated-value-" + String.valueOf(new Random().nextInt());
        DeviceMappingConfigurationDTO config = this.readConfiguration("csv/isolated-value-mapping-typed.json");
        byte[] fileContent = this.readFile("csv/isolated-value.csv");
        this.deviceMapper.handle(config, Map.of("provider", provider), fileContent);
        Assertions.assertEquals((float)37.5f, (Float)this.getResourceValue(provider, "data", "value", Float.class));
    }

    @Test
    void testVariables() throws Exception {
        String provider = "provider-vars-" + String.valueOf(new Random().nextInt());
        String service = "svc-vars-" + String.valueOf(new Random().nextInt());
        String resource = "rc-vars-" + String.valueOf(new Random().nextInt());
        DeviceMappingConfigurationDTO config = this.readConfiguration("csv/csv-no-header-vars-mapping.json");
        byte[] fileContent = this.readFile("csv/csv-no-header-vars.csv");
        this.deviceMapper.handle(config, Map.of("provider", provider, "svc", service, "rc", resource), fileContent);
        Assertions.assertEquals((Object)"3.4", (Object)this.getResourceValue(provider, service, "a", String.class));
        Assertions.assertEquals((Object)"42", (Object)this.getResourceValue(provider, service, "b", String.class));
    }
}

