/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.southbound.device.factory.parser.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import org.eclipse.sensinact.gateway.southbound.device.factory.IDeviceMappingRecord;
import org.eclipse.sensinact.gateway.southbound.device.factory.RecordPath;
import org.eclipse.sensinact.gateway.southbound.device.factory.dto.DeviceMappingOptionsDTO;

public class JsonRecord
implements IDeviceMappingRecord {
    private final JsonNode root;
    private final ObjectMapper mapper;

    public JsonRecord(ObjectMapper mapper, JsonNode root) {
        if (!root.isObject() && !root.isArray()) {
            throw new IllegalArgumentException("Root node is neither a JSON object nor array");
        }
        this.mapper = mapper;
        this.root = root;
    }

    private JsonNode getPath(JsonNode node, RecordPath pathPart) {
        if (node.isArray()) {
            return node.get(pathPart.asInt().intValue());
        }
        return node.get(pathPart.asString());
    }

    private JsonNode walkPath(RecordPath path) {
        JsonNode current = this.root;
        for (RecordPath part : path.parts()) {
            if ((current = this.getPath(current, part)) != null) continue;
            return null;
        }
        return current;
    }

    private Object getRawField(RecordPath field) {
        JsonNode node = this.walkPath(field);
        if (node == null || node.isNull()) {
            if (field.hasDefaultValue()) {
                return field.getDefaultValue();
            }
            return null;
        }
        if (node.isObject()) {
            return this.mapper.convertValue((Object)node, Map.class);
        }
        if (node.isArray()) {
            return this.mapper.convertValue((Object)node, List.class);
        }
        switch (node.getNodeType()) {
            case NUMBER: {
                if (node.isDouble()) {
                    return node.asDouble();
                }
                if (node.isInt()) {
                    return node.asInt();
                }
                return node.asLong();
            }
            case STRING: {
                return node.asText();
            }
            case BOOLEAN: {
                return node.asBoolean();
            }
        }
        return null;
    }

    public Object getField(RecordPath field, DeviceMappingOptionsDTO options) {
        Object rawValue = this.getRawField(field);
        if (rawValue == null) {
            return null;
        }
        return field.convertValue(rawValue, options);
    }

    public String getFieldString(RecordPath field, DeviceMappingOptionsDTO options) {
        JsonNode node = this.walkPath(field);
        if (node != null && node.isValueNode()) {
            return node.asText();
        }
        if (field.hasDefaultValue()) {
            Object defaultValue = field.getDefaultValue();
            return defaultValue != null ? String.valueOf(defaultValue) : null;
        }
        return null;
    }
}

