/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.southbound.http.callback;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.sensinact.gateway.southbound.http.callback.api.HttpCallback;
import org.osgi.annotation.bundle.Capability;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.servlet.runtime.HttpServiceRuntime;
import org.osgi.service.servlet.whiteboard.propertytypes.HttpWhiteboardServletPattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HttpWhiteboardServletPattern(value={"/southbound/callback/*"})
@Capability(namespace="osgi.implementation", name="sensinact.http.callback.whiteboard", version="0.0.1")
@Component(configurationPid={"sensinact.http.callback.whiteboard"}, configurationPolicy=ConfigurationPolicy.REQUIRE)
public class HttpCallbackWhiteboard
extends HttpServlet
implements Servlet {
    private static final Logger logger = LoggerFactory.getLogger(HttpCallbackWhiteboard.class);
    private static final String NOT_SET = "<NOT SET>";
    private final String baseURI;
    private final Map<String, HttpCallback> callbacks = new HashMap<String, HttpCallback>();
    private final Map<String, String> pathToURI = new HashMap<String, String>();
    private final Map<Long, String> serviceToPath = new HashMap<Long, String>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    @Activate
    public HttpCallbackWhiteboard(Config config, @Reference Map.Entry<Map<String, Object>, HttpServiceRuntime> props) {
        String prefix;
        if (NOT_SET.equals(config.base_uri())) {
            Map<String, Object> runtimeProps = props.getKey();
            Object o = runtimeProps.get("osgi.http.endpoint");
            if (o == null) {
                logger.error("No base.uri is set, and the HttpServiceRuntime does not declare an endpoint URI");
                throw new IllegalArgumentException("No base.uri is set and no runtime uri is available");
            }
            if (o instanceof String[]) {
                String[] s = (String[])o;
                if (s.length == 0) {
                    logger.error("No base.uri is set, and the HttpServiceRuntime does declares an empty endpoint URI array");
                    throw new IllegalArgumentException("No base.uri is set and no runtime uri is available");
                }
                o = s[0];
            } else if (o instanceof Collection) {
                Collection c = (Collection)o;
                if (c.isEmpty()) {
                    logger.error("No base.uri is set, and the HttpServiceRuntime does declares an empty endpoint URI list");
                    throw new IllegalArgumentException("No base.uri is set and no runtime uri is available");
                }
                o = c.iterator().next();
            }
            prefix = o.toString();
            if (logger.isInfoEnabled()) {
                logger.info("Using URI prefix {} from the HttpServiceRuntime", (Object)prefix);
            }
        } else {
            prefix = config.base_uri();
            if (logger.isInfoEnabled()) {
                logger.info("Using URI prefix {} from the base.uri configuration property", (Object)prefix);
            }
        }
        this.baseURI = prefix.endsWith("/") ? prefix + "southbound/callback/" : prefix + "/southbound/callback/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    void addCallback(HttpCallback callback, Map<String, Object> props) throws InterruptedException {
        String path = UUID.randomUUID().toString();
        String uri = this.baseURI + path;
        Long serviceId = this.getServiceId(props);
        if (logger.isDebugEnabled()) {
            logger.debug("Adding callback for service {} with path {}", (Object)serviceId, (Object)path);
        }
        Lock wl = this.lock.writeLock();
        wl.lockInterruptibly();
        try {
            this.serviceToPath.put(serviceId, path);
            this.callbacks.put(path, callback);
            this.pathToURI.put(path, uri);
        }
        finally {
            wl.unlock();
        }
        try {
            callback.activate(uri);
        }
        catch (Exception e) {
            logger.warn("An error occurred activating callback service {}", (Object)serviceId, (Object)e);
            this.removeCallback(props);
        }
    }

    private Long getServiceId(Map<String, Object> props) {
        return (Long)props.get("service.id");
    }

    void modifiedCallback(HttpCallback callback, Map<String, Object> props) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCallback(Map<String, Object> props) throws InterruptedException {
        Long serviceId = this.getServiceId(props);
        if (logger.isDebugEnabled()) {
            logger.debug("Removing callback for service {}", (Object)serviceId);
        }
        HttpCallback httpCallback = null;
        String uri = null;
        Lock wl = this.lock.writeLock();
        wl.lockInterruptibly();
        try {
            String path = this.serviceToPath.remove(serviceId);
            if (path != null) {
                httpCallback = this.callbacks.remove(path);
                uri = this.pathToURI.remove(path);
            }
        }
        finally {
            wl.unlock();
        }
        if (httpCallback != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Deactivating service {} for uri {}", (Object)serviceId, (Object)uri);
            }
            httpCallback.deactivate(uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String uri;
        HttpCallback httpCallback;
        String path;
        block17: {
            path = req.getRequestURI().substring(req.getContextPath().length() + req.getServletPath().length() + 1);
            if (logger.isDebugEnabled()) {
                logger.debug("POST request received for URI {} - calculated path is {}", (Object)req.getRequestURI(), (Object)path);
            }
            Lock readLock = this.lock.readLock();
            try {
                if (readLock.tryLock(2L, TimeUnit.SECONDS)) {
                    try {
                        httpCallback = this.callbacks.get(path);
                        uri = this.pathToURI.get(path);
                        break block17;
                    }
                    finally {
                        readLock.unlock();
                    }
                }
                if (logger.isWarnEnabled()) {
                    logger.debug("Not able to acquire a read lock in 2 seconds");
                }
                resp.sendError(503);
                return;
            }
            catch (Exception e) {
                if (logger.isWarnEnabled()) {
                    logger.debug("Not able to check the callbacks", (Throwable)e);
                }
                resp.sendError(500);
                return;
            }
        }
        if (httpCallback != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Processing callback for path {}", (Object)path);
            }
            HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
            Enumeration headerNames = req.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String header = (String)headerNames.nextElement();
                headers.put(header, Collections.list(req.getHeaders(header)));
            }
            try {
                httpCallback.call(uri, headers, req.getReader());
            }
            catch (Exception e) {
                if (logger.isWarnEnabled()) {
                    logger.debug("An error occurred for a callback on path {}", (Object)path, (Object)e);
                }
                resp.sendError(500);
                return;
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("No callback present for path {}", (Object)path);
            }
            resp.sendError(404);
            return;
        }
        resp.setStatus(204);
    }

    static @interface Config {
        public String base_uri() default "<NOT SET>";
    }
}

