/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.southbound.mqtt.test;

import io.moquette.broker.Server;
import io.moquette.broker.config.IConfig;
import io.moquette.broker.config.MemoryConfig;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocketFactory;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.bc.BcRSAContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.sensinact.gateway.southbound.mqtt.api.IMqttMessage;
import org.eclipse.sensinact.gateway.southbound.mqtt.api.IMqttMessageListener;
import org.eclipse.sensinact.gateway.southbound.mqtt.impl.MqttClientConfiguration;
import org.eclipse.sensinact.gateway.southbound.mqtt.impl.MqttClientHandler;
import org.eclipse.sensinact.gateway.southbound.mqtt.impl.SSLUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttSslAuthTest {
    private static final String SERVER_CERT_P12 = "src/test/resources/server.p12";
    private static final String SERVER_CERT_PASS = "secret";
    private static final String CLIENT_CERT_P12 = "src/test/resources/client.p12";
    private static final String CLIENT_CERT_PEM = "src/test/resources/client.pem";
    private static final String CLIENT_CERT_KEY_PEM = "src/test/resources/client.key";
    private static final String CLIENT_CERT_UNSIGNED_P12 = "src/test/resources/client_unsigned.p12";
    private static final String CLIENT_CERT_UNSIGNED_WITH_CA_P12 = "src/test/resources/client_unsigned_with_ca.p12";
    private static final String CLIENT_CERT_PASS = "titi21";
    private static final String TRUST_CERT_P12 = "src/test/resources/ca.p12";
    private static final String TRUST_CERT_PEM = "src/test/resources/ca.pem";
    private static final String TRUST_CERT_PASS = "secret";
    private MqttClient client;
    private final List<MqttClientHandler> handlers = new ArrayList<MqttClientHandler>();
    private Server server;
    final Logger logger = LoggerFactory.getLogger(this.getClass());

    @BeforeAll
    static void generateCertificates() throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        String caAlias = "ca";
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA", "BC");
        keyPairGen.initialize(2048);
        KeyPair caKeyPair = keyPairGen.generateKeyPair();
        X509Certificate caCert = MqttSslAuthTest.generateSelfSignedCertificate(MqttSslAuthTest.makeName("Certificate Authority", "ca"), caKeyPair, true);
        KeyStore caTrustStore = KeyStore.getInstance("PKCS12");
        caTrustStore.load(null);
        caTrustStore.setCertificateEntry("ca", caCert);
        try (FileOutputStream fos = new FileOutputStream(TRUST_CERT_P12);){
            caTrustStore.store(fos, "secret".toCharArray());
        }
        MqttSslAuthTest.writePemCertificate(caCert, TRUST_CERT_PEM);
        MqttSslAuthTest.makeSignedKeystore("localhost", "server", SERVER_CERT_P12, "secret", caKeyPair, caCert);
        CertificateKeyPair clientCert = MqttSslAuthTest.makeSignedKeystore("Signed Client", "client", CLIENT_CERT_P12, CLIENT_CERT_PASS, caKeyPair, caCert);
        MqttSslAuthTest.writePemCertificate(clientCert.certificate, CLIENT_CERT_PEM);
        MqttSslAuthTest.writePemPrivateKey(clientCert.keypair.getPrivate(), CLIENT_CERT_KEY_PEM);
        MqttSslAuthTest.makeUnsignedKeyStore("Self-Signed Client", "client", CLIENT_CERT_UNSIGNED_P12, CLIENT_CERT_PASS);
        KeyStore clientUnsignedWithCAKeyStore = KeyStore.getInstance("PKCS12");
        try (FileInputStream fis = new FileInputStream(CLIENT_CERT_UNSIGNED_P12);){
            clientUnsignedWithCAKeyStore.load(fis, CLIENT_CERT_PASS.toCharArray());
        }
        clientUnsignedWithCAKeyStore.setCertificateEntry("ca", caCert);
        try (FileOutputStream fos = new FileOutputStream(CLIENT_CERT_UNSIGNED_WITH_CA_P12);){
            clientUnsignedWithCAKeyStore.store(fos, CLIENT_CERT_PASS.toCharArray());
        }
    }

    @AfterAll
    static void cleanupCertificates() {
        for (String file : Arrays.asList(SERVER_CERT_P12, CLIENT_CERT_P12, CLIENT_CERT_KEY_PEM, CLIENT_CERT_PEM, CLIENT_CERT_UNSIGNED_P12, CLIENT_CERT_UNSIGNED_WITH_CA_P12, TRUST_CERT_P12, TRUST_CERT_PEM)) {
            try {
                Files.deleteIfExists(Paths.get(file, new String[0]));
            }
            catch (IOException iOException) {}
        }
    }

    static X500Name makeName(String commonName, String alias) {
        return new X500Name(String.format("C=FR, O=Test, OU=%s, CN=%s", alias, commonName));
    }

    static CertificateKeyPair makeSignedKeystore(String commonName, String alias, String path, String password, KeyPair caKeyPair, X509Certificate caCert) throws Exception {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA", "BC");
        keyPairGen.initialize(2048);
        KeyPair keyPair = keyPairGen.generateKeyPair();
        JcaPKCS10CertificationRequestBuilder p10Builder = new JcaPKCS10CertificationRequestBuilder(MqttSslAuthTest.makeName(commonName, alias), keyPair.getPublic());
        JcaContentSignerBuilder csBuilder = new JcaContentSignerBuilder("SHA256withRSA");
        ContentSigner signer = csBuilder.build(keyPair.getPrivate());
        PKCS10CertificationRequest csr = p10Builder.build(signer);
        X509Certificate newCert = MqttSslAuthTest.signCSR(csr, caKeyPair, caCert);
        KeyStore serverKeyStore = KeyStore.getInstance("PKCS12");
        serverKeyStore.load(null, password.toCharArray());
        serverKeyStore.setCertificateEntry("ca", caCert);
        serverKeyStore.setKeyEntry(alias, keyPair.getPrivate(), password.toCharArray(), new X509Certificate[]{newCert, caCert});
        try (FileOutputStream fos = new FileOutputStream(path);){
            serverKeyStore.store(fos, password.toCharArray());
        }
        CertificateKeyPair ckp = new CertificateKeyPair();
        ckp.certificate = newCert;
        ckp.keypair = keyPair;
        return ckp;
    }

    static void makeUnsignedKeyStore(String commonName, String alias, String path, String password) throws Exception {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA", "BC");
        keyPairGen.initialize(2048);
        KeyPair unsignedKeyPair = keyPairGen.generateKeyPair();
        KeyStore unsignedKeyStore = KeyStore.getInstance("PKCS12");
        X509Certificate selfSignedCert = MqttSslAuthTest.generateSelfSignedCertificate(MqttSslAuthTest.makeName(commonName, alias), unsignedKeyPair, false);
        unsignedKeyStore.load(null);
        unsignedKeyStore.setKeyEntry("client_unsigned", unsignedKeyPair.getPrivate(), CLIENT_CERT_PASS.toCharArray(), new X509Certificate[]{selfSignedCert});
        try (FileOutputStream fos = new FileOutputStream(path);){
            unsignedKeyStore.store(fos, password.toCharArray());
        }
    }

    static X509Certificate generateSelfSignedCertificate(X500Name subject, KeyPair certPair, boolean isAuthority) throws Exception {
        long serial = System.currentTimeMillis();
        Date notBefore = new Date(System.currentTimeMillis() - 86400000L);
        Date notAfter = new Date(System.currentTimeMillis() + 86400000L);
        SubjectPublicKeyInfo publicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)certPair.getPublic().getEncoded());
        JcaX509v3CertificateBuilder certBuilder = new JcaX509v3CertificateBuilder(subject, BigInteger.valueOf(serial), notBefore, notAfter, subject, publicKeyInfo);
        certBuilder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(isAuthority));
        ContentSigner signer = new JcaContentSignerBuilder("SHA256WithRSAEncryption").build(certPair.getPrivate());
        X509CertificateHolder certHolder = certBuilder.build(signer);
        X509Certificate cert = new JcaX509CertificateConverter().getCertificate(certHolder);
        return cert;
    }

    static X509Certificate signCSR(PKCS10CertificationRequest csr, KeyPair caKeyPair, X509Certificate caCert) throws Exception {
        AlgorithmIdentifier sigAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find("SHA256withRSA");
        AlgorithmIdentifier digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find(sigAlgId);
        AsymmetricKeyParameter caPrivateKeyParameters = PrivateKeyFactory.createKey((byte[])caKeyPair.getPrivate().getEncoded());
        SubjectPublicKeyInfo csrPublicKeyInfo = csr.getSubjectPublicKeyInfo();
        X509v3CertificateBuilder certificateBuilder = new X509v3CertificateBuilder(new X509CertificateHolder(caCert.getEncoded()).getSubject(), BigInteger.valueOf(System.currentTimeMillis()), new Date(System.currentTimeMillis() - 86400000L), new Date(System.currentTimeMillis() + 86400000L), csr.getSubject(), csrPublicKeyInfo);
        ContentSigner contentSigner = new BcRSAContentSignerBuilder(sigAlgId, digAlgId).build(caPrivateKeyParameters);
        X509CertificateHolder certificateHolder = certificateBuilder.build(contentSigner);
        X509Certificate signedCertificate = new JcaX509CertificateConverter().getCertificate(certificateHolder);
        return signedCertificate;
    }

    private static void writePemCertificate(Certificate certificate, String filename) throws FileNotFoundException, IOException, CertificateEncodingException {
        try (PemWriter pemWriter = new PemWriter((Writer)new OutputStreamWriter(new FileOutputStream(filename)));){
            pemWriter.writeObject((PemObjectGenerator)new PemObject("CERTIFICATE", certificate.getEncoded()));
        }
    }

    private static void writePemPrivateKey(PrivateKey key, String filename) throws FileNotFoundException, IOException {
        String algorithm = key.getAlgorithm();
        if (algorithm == null) {
            algorithm = "";
        }
        try (PemWriter pemWriter = new PemWriter((Writer)new OutputStreamWriter(new FileOutputStream(filename)));){
            pemWriter.writeObject((PemObjectGenerator)new PemObject(algorithm + " PRIVATE KEY", key.getEncoded()));
        }
    }

    @BeforeEach
    void start() throws Exception {
        this.server = new Server();
        MemoryConfig config = new MemoryConfig(new Properties());
        config.setProperty("host", "localhost");
        config.setProperty("port", "disabled");
        config.setProperty("ssl_port", "2183");
        config.setProperty("key_store_type", "PKCS12");
        config.setProperty("jks_path", SERVER_CERT_P12);
        config.setProperty("key_store_password", "secret");
        config.setProperty("key_manager_password", "secret");
        config.setProperty("need_client_auth", "true");
        this.server.startServer((IConfig)config);
        this.client = new MqttClient("ssl://localhost:2183", MqttClient.generateClientId());
        MqttConnectOptions options = new MqttConnectOptions();
        options.setCleanSession(true);
        SSLSocketFactory sslSocketFactory = SSLUtils.setupSSLSocketFactory((MqttClientConfiguration)this.makeSslKeystoreConfig(CLIENT_CERT_P12, CLIENT_CERT_PASS, TRUST_CERT_P12, "secret"));
        options.setSocketFactory((SocketFactory)sslSocketFactory);
        this.client.connect(options);
    }

    @AfterEach
    void stop() throws Exception {
        try {
            if (this.client.isConnected()) {
                this.client.disconnect();
            }
            this.client.close();
            for (MqttClientHandler handler : this.handlers) {
                handler.deactivate();
            }
        }
        finally {
            this.server.stopServer();
        }
    }

    MqttClientConfiguration makeSslKeystoreConfig(String keystorePath, String keystorePassword, String trustStorePath, String trustStorePassword) {
        MqttClientConfiguration mock = (MqttClientConfiguration)Mockito.mock(MqttClientConfiguration.class);
        Mockito.when((Object)mock.auth_keystore_type()).thenReturn((Object)"PKCS12");
        Mockito.when((Object)mock.auth_keystore_path()).thenReturn((Object)keystorePath);
        Mockito.when((Object)mock._auth_keystore_password()).thenReturn((Object)keystorePassword);
        Mockito.when((Object)mock.auth_truststore_path()).thenReturn((Object)trustStorePath);
        Mockito.when((Object)mock._auth_truststore_password()).thenReturn((Object)trustStorePassword);
        return mock;
    }

    MqttClientConfiguration makeSslPemConfig(String certPath, String certKey, String certKeyPassword, String caPath) {
        MqttClientConfiguration mock = (MqttClientConfiguration)Mockito.mock(MqttClientConfiguration.class);
        Mockito.when((Object)mock.auth_clientcert_path()).thenReturn((Object)certPath);
        Mockito.when((Object)mock.auth_clientcert_key()).thenReturn((Object)certKey);
        Mockito.when((Object)mock._auth_clientcert_key_password()).thenReturn((Object)certKeyPassword);
        Mockito.when((Object)mock.auth_clientcert_ca_path()).thenReturn((Object)caPath);
        return mock;
    }

    MqttClientHandler setupHandler(MqttClientConfiguration baseSslConfig, String handlerId, String ... topics) throws Exception {
        MqttClientHandler handler = new MqttClientHandler();
        Mockito.when((Object)baseSslConfig.id()).thenReturn((Object)handlerId);
        Mockito.when((Object)baseSslConfig.host()).thenReturn((Object)"localhost");
        Mockito.when((Object)baseSslConfig.port()).thenReturn((Object)2183);
        Mockito.when((Object)baseSslConfig.topics()).thenReturn((Object)topics);
        handler.activate(baseSslConfig);
        return handler;
    }

    @Test
    void testMqttConnect() throws Exception {
        ArrayBlockingQueue messages = new ArrayBlockingQueue(32);
        IMqttMessageListener listener = (handler, topic, msg) -> {
            Assertions.assertEquals((Object)handler, (Object)msg.getHandlerId());
            messages.add(msg);
        };
        String topic2 = "sensinact/mqtt/test";
        MqttClientConfiguration config = this.makeSslKeystoreConfig(CLIENT_CERT_P12, CLIENT_CERT_PASS, TRUST_CERT_P12, "secret");
        this.handlers.add(this.setupHandler(config, "id-auth-ssl", "sensinact/mqtt/test"));
        for (MqttClientHandler handler2 : this.handlers) {
            handler2.addListener(listener, Map.of("sensinact.mqtt.topics.filters", new String[]{"sensinact/mqtt/test"}));
        }
        String content = "HandlerID";
        this.client.publish("sensinact/mqtt/test", content.getBytes(StandardCharsets.UTF_8), 1, false);
        IMqttMessage msg2 = (IMqttMessage)messages.poll(1L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)msg2);
        Assertions.assertEquals((int)0, (int)messages.size());
        Assertions.assertEquals((Object)"id-auth-ssl", (Object)msg2.getHandlerId());
        Assertions.assertEquals((Object)"sensinact/mqtt/test", (Object)msg2.getTopic());
        Assertions.assertEquals((Object)content, (Object)new String(msg2.getPayload(), StandardCharsets.UTF_8));
    }

    @Test
    void testMqttRejectUnsigned() throws Exception {
        for (String certFile : List.of(CLIENT_CERT_UNSIGNED_P12, CLIENT_CERT_UNSIGNED_WITH_CA_P12)) {
            MqttClientConfiguration config = this.makeSslKeystoreConfig(certFile, CLIENT_CERT_PASS, TRUST_CERT_P12, "secret");
            MqttException ex = (MqttException)Assertions.assertThrows(MqttException.class, () -> this.setupHandler(config, "id-auth-ssl", "sensinact/mqtt/test"));
            Assertions.assertInstanceOf(SSLHandshakeException.class, (Object)ex.getCause());
        }
    }

    @Test
    void testMqttConnectPem() throws Exception {
        ArrayBlockingQueue messages = new ArrayBlockingQueue(32);
        IMqttMessageListener listener = (handler, topic, msg) -> {
            Assertions.assertEquals((Object)handler, (Object)msg.getHandlerId());
            messages.add(msg);
        };
        String topic2 = "sensinact/mqtt/test";
        MqttClientConfiguration config = this.makeSslPemConfig(CLIENT_CERT_PEM, CLIENT_CERT_KEY_PEM, CLIENT_CERT_PASS, TRUST_CERT_PEM);
        this.handlers.add(this.setupHandler(config, "id-auth-ssl", "sensinact/mqtt/test"));
        for (MqttClientHandler handler2 : this.handlers) {
            handler2.addListener(listener, Map.of("sensinact.mqtt.topics.filters", new String[]{"sensinact/mqtt/test"}));
        }
        String content = "HandlerID";
        this.client.publish("sensinact/mqtt/test", content.getBytes(StandardCharsets.UTF_8), 1, false);
        IMqttMessage msg2 = (IMqttMessage)messages.poll(1L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)msg2);
        Assertions.assertEquals((int)0, (int)messages.size());
        Assertions.assertEquals((Object)"id-auth-ssl", (Object)msg2.getHandlerId());
        Assertions.assertEquals((Object)"sensinact/mqtt/test", (Object)msg2.getTopic());
        Assertions.assertEquals((Object)content, (Object)new String(msg2.getPayload(), StandardCharsets.UTF_8));
    }

    private static class CertificateKeyPair {
        private KeyPair keypair;
        private Certificate certificate;

        private CertificateKeyPair() {
        }
    }
}

