/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.southbound.mqtt.impl;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class ChainedTrustManagers
implements X509TrustManager {
    private List<X509TrustManager> trustManagers = new ArrayList<X509TrustManager>();
    private final boolean allowExpired;

    public ChainedTrustManagers(TrustManager ... trustManagers) {
        this(false, trustManagers);
    }

    public ChainedTrustManagers(boolean allowExpired, TrustManager ... trustManagers) {
        this.allowExpired = allowExpired;
        for (TrustManager subManager : trustManagers) {
            if (!(subManager instanceof X509TrustManager)) continue;
            this.trustManagers.add((X509TrustManager)subManager);
        }
    }

    public ChainedTrustManagers(TrustManager[] ... trustManagers) {
        this(false, trustManagers);
    }

    public ChainedTrustManagers(boolean allowExpired, TrustManager[] ... trustManagers) {
        this.allowExpired = allowExpired;
        TrustManager[][] trustManagerArray = trustManagers;
        int n = trustManagerArray.length;
        for (int i = 0; i < n; ++i) {
            TrustManager[] subManagers;
            for (TrustManager subManager : subManagers = trustManagerArray[i]) {
                if (!(subManager instanceof X509TrustManager)) continue;
                this.trustManagers.add((X509TrustManager)subManager);
            }
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (this.allowExpired) {
            chain = this.disableExpirationCheck(chain);
        }
        CertificateException lastEx = null;
        for (X509TrustManager trustManager : this.trustManagers) {
            try {
                trustManager.checkClientTrusted(chain, authType);
                return;
            }
            catch (CertificateException e) {
                lastEx = e;
            }
        }
        if (lastEx != null) {
            throw lastEx;
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (this.allowExpired) {
            chain = this.disableExpirationCheck(chain);
        }
        CertificateException lastEx = null;
        for (X509TrustManager trustManager : this.trustManagers) {
            try {
                trustManager.checkServerTrusted(chain, authType);
                return;
            }
            catch (CertificateException e) {
                lastEx = e;
            }
        }
        if (lastEx != null) {
            throw lastEx;
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        ArrayList<X509Certificate> issuers = new ArrayList<X509Certificate>();
        for (X509TrustManager trustManager : this.trustManagers) {
            issuers.addAll(Arrays.asList(trustManager.getAcceptedIssuers()));
        }
        return issuers.toArray(new X509Certificate[0]);
    }

    public X509Certificate[] disableExpirationCheck(X509Certificate[] chain) {
        X509Certificate[] newChain = new X509Certificate[chain.length];
        for (int i = 0; i < chain.length; ++i) {
            newChain[i] = this.disableExpirationCheck(chain[i]);
        }
        return newChain;
    }

    private X509Certificate disableExpirationCheck(final X509Certificate certificate) {
        return new X509Certificate(){

            @Override
            public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
            }

            @Override
            public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
            }

            @Override
            public boolean hasUnsupportedCriticalExtension() {
                return certificate.hasUnsupportedCriticalExtension();
            }

            @Override
            public Set<String> getNonCriticalExtensionOIDs() {
                return certificate.getNonCriticalExtensionOIDs();
            }

            @Override
            public byte[] getExtensionValue(String oid) {
                return certificate.getExtensionValue(oid);
            }

            @Override
            public Set<String> getCriticalExtensionOIDs() {
                return certificate.getCriticalExtensionOIDs();
            }

            @Override
            public void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
                certificate.verify(key, sigProvider);
            }

            @Override
            public void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
                certificate.verify(key);
            }

            @Override
            public String toString() {
                return certificate.toString();
            }

            @Override
            public PublicKey getPublicKey() {
                return certificate.getPublicKey();
            }

            @Override
            public byte[] getEncoded() throws CertificateEncodingException {
                return certificate.getEncoded();
            }

            @Override
            public int getVersion() {
                return certificate.getVersion();
            }

            @Override
            public byte[] getTBSCertificate() throws CertificateEncodingException {
                return certificate.getTBSCertificate();
            }

            @Override
            public boolean[] getSubjectUniqueID() {
                return certificate.getSubjectUniqueID();
            }

            @Override
            public Principal getSubjectDN() {
                return certificate.getSubjectDN();
            }

            @Override
            public byte[] getSignature() {
                return certificate.getSignature();
            }

            @Override
            public byte[] getSigAlgParams() {
                return certificate.getSigAlgParams();
            }

            @Override
            public String getSigAlgOID() {
                return certificate.getSigAlgOID();
            }

            @Override
            public String getSigAlgName() {
                return certificate.getSigAlgName();
            }

            @Override
            public BigInteger getSerialNumber() {
                return certificate.getSerialNumber();
            }

            @Override
            public Date getNotBefore() {
                return certificate.getNotBefore();
            }

            @Override
            public Date getNotAfter() {
                return certificate.getNotAfter();
            }

            @Override
            public boolean[] getKeyUsage() {
                return certificate.getKeyUsage();
            }

            @Override
            public boolean[] getIssuerUniqueID() {
                return certificate.getIssuerUniqueID();
            }

            @Override
            public Principal getIssuerDN() {
                return certificate.getIssuerDN();
            }

            @Override
            public int getBasicConstraints() {
                return certificate.getBasicConstraints();
            }
        };
    }
}

