/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.southbound.mqtt.test;

import io.moquette.broker.Server;
import io.moquette.broker.config.IConfig;
import io.moquette.broker.config.MemoryConfig;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.sensinact.gateway.southbound.mqtt.api.IMqttMessage;
import org.eclipse.sensinact.gateway.southbound.mqtt.api.IMqttMessageListener;
import org.eclipse.sensinact.gateway.southbound.mqtt.impl.MqttClientConfiguration;
import org.eclipse.sensinact.gateway.southbound.mqtt.impl.MqttClientHandler;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class MqttWebSocketTest {
    private MqttClient client;
    private final List<MqttClientHandler> handlers = new ArrayList<MqttClientHandler>();
    private Server server;

    @BeforeEach
    void start() throws Exception {
        this.server = new Server();
        MemoryConfig config = new MemoryConfig(new Properties());
        config.setProperty("host", "127.0.0.1");
        config.setProperty("port", "2183");
        config.setProperty("websocket_port", "2184");
        config.setProperty("websocket_path", "/ws");
        this.server.startServer((IConfig)config);
        this.client = new MqttClient("tcp://127.0.0.1:2183", MqttClient.generateClientId());
        MqttConnectOptions options = new MqttConnectOptions();
        options.setCleanSession(true);
        this.client.connect(options);
        this.handlers.add(this.setupHandler("id1", "sensinact/mqtt/test1/+"));
        this.handlers.add(this.setupHandler(null, "sensinact/mqtt/test2/+"));
    }

    @AfterEach
    void stop() throws Exception {
        try {
            this.client.disconnect();
            this.client.close();
            for (MqttClientHandler handler : this.handlers) {
                handler.deactivate();
            }
        }
        finally {
            this.server.stopServer();
        }
    }

    MqttClientHandler setupHandler(String handlerId, String ... topics) throws Exception {
        MqttClientHandler handler = new MqttClientHandler();
        MqttClientConfiguration mock = (MqttClientConfiguration)Mockito.mock(MqttClientConfiguration.class);
        Mockito.when((Object)mock.id()).thenReturn((Object)handlerId);
        Mockito.when((Object)mock.protocol()).thenReturn((Object)"ws");
        Mockito.when((Object)mock.host()).thenReturn((Object)"127.0.0.1");
        Mockito.when((Object)mock.port()).thenReturn((Object)2184);
        Mockito.when((Object)mock.path()).thenReturn((Object)"/ws");
        Mockito.when((Object)mock.topics()).thenReturn((Object)topics);
        handler.activate(mock);
        return handler;
    }

    @Test
    void testMqttHandlerId() throws Exception {
        ArrayBlockingQueue messages = new ArrayBlockingQueue(32);
        IMqttMessageListener listener = (handler, topic, msg) -> {
            Assertions.assertEquals((Object)handler, (Object)msg.getHandlerId());
            messages.add(msg);
        };
        for (MqttClientHandler handler2 : this.handlers) {
            handler2.addListener(listener, Map.of("sensinact.mqtt.topics.filters", new String[]{"sensinact/mqtt/test1/foo", "sensinact/mqtt/test2/bar"}));
        }
        String content = "HandlerID";
        String topic2 = "sensinact/mqtt/test1/foo";
        this.client.publish(topic2, content.getBytes(StandardCharsets.UTF_8), 1, false);
        IMqttMessage msg1 = (IMqttMessage)messages.poll(1L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)msg1);
        Assertions.assertEquals((Object)"id1", (Object)msg1.getHandlerId());
        Assertions.assertEquals((Object)topic2, (Object)msg1.getTopic());
        Assertions.assertEquals((Object)content, (Object)new String(msg1.getPayload(), StandardCharsets.UTF_8));
        topic2 = "sensinact/mqtt/test2/bar";
        this.client.publish(topic2, content.getBytes(StandardCharsets.UTF_8), 1, false);
        IMqttMessage msg2 = (IMqttMessage)messages.poll(1L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)msg2);
        UUID id2 = UUID.fromString(msg2.getHandlerId());
        Assertions.assertNotEquals((Object)msg1.getHandlerId(), (Object)id2.toString());
        Assertions.assertEquals((Object)topic2, (Object)msg2.getTopic());
        Assertions.assertEquals((Object)content, (Object)new String(msg2.getPayload(), StandardCharsets.UTF_8));
    }
}

