/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.device.openhab.sensinact;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.core.SensiNactResourceModelConfiguration;
import org.eclipse.sensinact.gateway.device.openhab.common.Broker;
import org.eclipse.sensinact.gateway.device.openhab.common.ServerLocation;
import org.eclipse.sensinact.gateway.device.openhab.sensinact.OpenHabActTaskConfigurator;
import org.eclipse.sensinact.gateway.device.openhab.sensinact.OpenHabMediator;
import org.eclipse.sensinact.gateway.device.openhab.sensinact.OpenHabServerFinder;
import org.eclipse.sensinact.gateway.device.openhab.sensinact.OpenHabSetTaskConfigurator;
import org.eclipse.sensinact.gateway.generic.ExtModelConfiguration;
import org.eclipse.sensinact.gateway.generic.ExtModelConfigurationBuilder;
import org.eclipse.sensinact.gateway.generic.InvalidProtocolStackException;
import org.eclipse.sensinact.gateway.generic.Task;
import org.eclipse.sensinact.gateway.sthbnd.http.HttpPacket;
import org.eclipse.sensinact.gateway.sthbnd.http.annotation.HttpTaskConfiguration;
import org.eclipse.sensinact.gateway.sthbnd.http.annotation.HttpTasks;
import org.eclipse.sensinact.gateway.sthbnd.http.annotation.RecurrentHttpTask;
import org.eclipse.sensinact.gateway.sthbnd.http.annotation.SimpleHttpTask;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.HttpActivator;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.HttpMediator;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.SimpleHttpProtocolStackEndpoint;
import org.osgi.annotation.bundle.Header;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HttpTasks(recurrences={@RecurrentHttpTask(delay=5000L, period=2000L, recurrence=@HttpTaskConfiguration(scheme="@context[openhab.scheme]", host="@context[openhab.host]", port="@context[openhab.port]", path="/rest/items/", contentType="application/json", acceptType="application/json")), @RecurrentHttpTask(delay=5000L, period=10000L, recurrence=@HttpTaskConfiguration(scheme="@context[openhab.scheme]", host="@context[openhab.host]", port="@context[openhab.port]", path="/rest/things/", contentType="application/json", acceptType="application/json"))}, tasks={@SimpleHttpTask(commands={Task.CommandType.ACT}, configuration=@HttpTaskConfiguration(scheme="@context[openhab.scheme]", host="@context[openhab.host]", port="@context[openhab.port]", path="/rest/items/@context[task.serviceProvider]_@context[task.service]_binary", httpMethod="POST", contentType="text/plain", acceptType="application/json", direct=true, content=OpenHabActTaskConfigurator.class)), @SimpleHttpTask(commands={Task.CommandType.SET}, configuration=@HttpTaskConfiguration(scheme="@context[openhab.scheme]", host="@context[openhab.host]", port="@context[openhab.port]", path="/rest/items/@context[task.serviceProvider]_@context[task.service]_@context[task.resource]", httpMethod="POST", contentType="text/plain", acceptType="application/json", direct=true, content=OpenHabSetTaskConfigurator.class))})
@Header(name="Bundle-Activator", value="${@class}")
public class Activator
extends HttpActivator
implements ServiceListener {
    private static final Logger LOG = LoggerFactory.getLogger(Activator.class);
    private ExtModelConfiguration<? extends HttpPacket> configuration;
    private Map<String, SimpleHttpProtocolStackEndpoint> endpoints;

    public void doStart() throws Exception {
        ((HttpMediator)this.mediator).setTaskProcessingContextHandler(this.getProcessingContextHandler());
        ((HttpMediator)this.mediator).setTaskProcessingContextFactory(this.getTaskProcessingContextFactory());
        ((HttpMediator)this.mediator).setChainedTaskProcessingContextFactory(this.getChainedTaskProcessingContextFactory());
        this.configuration = ExtModelConfigurationBuilder.instance((Mediator)this.mediator, (Class)this.getPacketType()).withStartAtInitializationTime(this.isStartingAtInitializationTime()).withServiceBuildPolicy(this.getServiceBuildPolicy()).withResourceBuildPolicy(this.getResourceBuildPolicy()).build(new Object[]{this.getResourceDescriptionFile(), this.getDefaults()});
        this.endpoints = new HashMap<String, SimpleHttpProtocolStackEndpoint>();
        List<ServerLocation> servers = OpenHabServerFinder.getServerLocation((OpenHabMediator)this.mediator, this);
        for (ServerLocation server : servers) {
            try {
                String endpointId = Activator.buildEndpointId(server);
                SimpleHttpProtocolStackEndpoint endpoint = this.configureProtocolStackEndpoint();
                endpoint.setEndpointIdentifier(endpointId);
                endpoint.connect(this.configuration);
                this.endpoints.put(endpointId, endpoint);
                ((OpenHabMediator)this.mediator).addBroker(endpointId, new Broker(server));
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void doStop() throws Exception {
        Iterator<SimpleHttpProtocolStackEndpoint> iterator = this.endpoints.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().stop();
        }
        this.endpoints.clear();
    }

    protected byte getResourceBuildPolicy() {
        return (byte)(SensiNactResourceModelConfiguration.BuildPolicy.BUILD_COMPLETE_ON_DESCRIPTION.getPolicy() | SensiNactResourceModelConfiguration.BuildPolicy.BUILD_NON_DESCRIBED.getPolicy());
    }

    protected byte getServiceBuildPolicy() {
        return (byte)(SensiNactResourceModelConfiguration.BuildPolicy.BUILD_COMPLETE_ON_DESCRIPTION.getPolicy() | SensiNactResourceModelConfiguration.BuildPolicy.BUILD_NON_DESCRIBED.getPolicy());
    }

    public HttpMediator doInstantiate(BundleContext context) {
        return new OpenHabMediator(context);
    }

    protected void connect(ExtModelConfiguration configuration) throws InvalidProtocolStackException {
    }

    public void serviceAdded(ServiceEvent event) {
        try {
            ServiceInfo info = event.getInfo();
            LOG.debug("event " + event);
            LOG.debug("event info" + event.getInfo());
            int port = info.getPort();
            String[] ips = info.getHostAddresses();
            if (ips != null && ips.length > 0) {
                String ip = ips[0];
                ServerLocation server = new ServerLocation(ip, port);
                String endpointId = Activator.buildEndpointId(server);
                try {
                    SimpleHttpProtocolStackEndpoint endpoint = this.configureProtocolStackEndpoint();
                    endpoint.setEndpointIdentifier(endpointId);
                    endpoint.connect(this.configuration);
                    this.endpoints.put(endpointId, endpoint);
                    ((OpenHabMediator)this.mediator).addBroker(endpointId, new Broker(server));
                    LOG.info("Openhab2 device instance added. name %s type %s", (Object)event.getName(), (Object)event.getType());
                }
                catch (Exception e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            } else {
                LOG.debug("not a new openhab2 device: " + event);
            }
        }
        catch (Throwable t) {
            LOG.debug("unexpected error", t);
        }
    }

    public void serviceRemoved(ServiceEvent event) {
        ServiceInfo info = event.getInfo();
        Integer port = info.getPort();
        String ip = info.getHostAddresses()[0];
        String endpointId = Activator.buildEndpointId(new ServerLocation(ip, port));
        ((OpenHabMediator)this.mediator).removeBroker(endpointId);
        try {
            this.endpoints.remove(endpointId).stop();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public void serviceResolved(ServiceEvent event) {
        LOG.debug("Openhab instance resolved. name %s type %s", (Object)event.getName(), (Object)event.getType());
    }

    private static String buildEndpointId(ServerLocation server) {
        return "openHab" + server.hashCode();
    }
}

