/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.http.free.internal;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.sensinact.gateway.common.bundle.ManagedConfigurationListener;
import org.eclipse.sensinact.gateway.generic.packet.InvalidPacketException;
import org.eclipse.sensinact.gateway.generic.packet.Packet;
import org.eclipse.sensinact.gateway.sthbnd.http.free.internal.FreeSmsPacket;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.HttpMediator;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.SimpleHttpProtocolStackEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class FreeSmsProtocolStackEndpoint
extends SimpleHttpProtocolStackEndpoint
implements ManagedConfigurationListener {
    private static final Logger LOG = LoggerFactory.getLogger(FreeSmsProtocolStackEndpoint.class);
    protected static final String USER_KEY = "user";
    protected static final String PASS_KEY = "pass";
    private Map<String, FreeSmsResourceConfig> configuredResources = new HashMap<String, FreeSmsResourceConfig>();

    public FreeSmsProtocolStackEndpoint(HttpMediator mediator) throws ParserConfigurationException, SAXException, IOException {
        super(mediator);
        mediator.addListener((ManagedConfigurationListener)this);
    }

    public void updated(Dictionary<String, ?> properties) {
        FreeSmsResourceConfig fsrc;
        HashMap<String, FreeSmsResourceConfig> propertiesResources = new HashMap<String, FreeSmsResourceConfig>();
        Hashtable props = properties == null ? new Hashtable() : properties;
        Enumeration enumeration = ((Dictionary)props).keys();
        Stack<String> toBeAdded = new Stack<String>();
        while (enumeration.hasMoreElements()) {
            String propertyKey = (String)enumeration.nextElement();
            String[] propertyKeyParts = propertyKey.split("#");
            if (propertyKeyParts.length == 2) {
                fsrc = (FreeSmsResourceConfig)propertiesResources.get(propertyKeyParts[0]);
                if (fsrc == null) {
                    fsrc = new FreeSmsResourceConfig();
                    propertiesResources.put(propertyKeyParts[0], fsrc);
                    if (!this.configuredResources.containsKey(propertyKeyParts[0])) {
                        toBeAdded.push(propertyKeyParts[0]);
                    }
                }
                if (USER_KEY.equals(propertyKeyParts[1])) {
                    fsrc.setUser((String)((Dictionary)props).get(propertyKey));
                    continue;
                }
                if (PASS_KEY.equals(propertyKeyParts[1])) {
                    fsrc.setPass((String)((Dictionary)props).get(propertyKey));
                    continue;
                }
            }
            LOG.warn(String.format("unrecognized property '%s' \n '<name>#(user|pass)' key format expected ", propertyKey));
        }
        Iterator<Map.Entry<String, FreeSmsResourceConfig>> iterator = this.configuredResources.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, FreeSmsResourceConfig> entry = iterator.next();
            if (propertiesResources.containsKey(entry.getKey())) continue;
            try {
                super.process((Packet)new FreeSmsPacket(entry.getKey(), null, null, false));
                iterator.remove();
            }
            catch (InvalidPacketException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        while (!toBeAdded.isEmpty()) {
            String key = (String)toBeAdded.pop();
            fsrc = (FreeSmsResourceConfig)propertiesResources.get(key);
            String user = null;
            String pass = null;
            if (fsrc == null || (user = fsrc.getUser()) == null || (pass = fsrc.getPass()) == null) {
                LOG.warn(String.format("%s : user and pass properties are needed", key));
                continue;
            }
            try {
                this.configuredResources.put(key, fsrc);
                super.process((Packet)new FreeSmsPacket(key, user, pass, true));
            }
            catch (InvalidPacketException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public FreeSmsResourceConfig getFreeSmsResourceConfig(String serviceProvider) {
        return this.configuredResources.get(serviceProvider);
    }

    public class FreeSmsResourceConfig {
        private String user;
        private String pass;

        public void setUser(String user) {
            this.user = user;
        }

        public void setPass(String pass) {
            this.pass = pass;
        }

        public String getUser() {
            return this.user;
        }

        public String getPass() {
            return this.pass;
        }
    }
}

