/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.http.android;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.util.IOUtils;
import org.osgi.framework.Bundle;

@WebFilter(urlPatterns={"/android/*"}, asyncSupported=false)
public class ResourceFilter
implements Filter {
    private static final Map<String, String> MIME = new HashMap<String, String>(){
        {
            this.put(".aac", "audio/aac");
            this.put(".abw", "application/x-abiword");
            this.put(".arc", "application/octet-stream");
            this.put(".avi", "video/x-msvideo");
            this.put(".azw", "application/vnd.amazon.ebook");
            this.put(".bin", "application/octet-stream");
            this.put(".bz", "application/x-bzip");
            this.put(".bz2", "application/x-bzip2");
            this.put(".csh", "application/x-csh");
            this.put(".css", "text/css");
            this.put(".csv", "text/csv");
            this.put(".doc", "application/msword");
            this.put(".docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
            this.put(".eot", "application/vnd.ms-fontobject");
            this.put(".epub", "application/epub+zip");
            this.put(".gif", "image/gif");
            this.put(".htm", "text/html");
            this.put(".html", "text/html");
            this.put(".ico", "image/x-icon");
            this.put(".ics", "text/calendar");
            this.put(".jar", "application/java-archive");
            this.put(".jpeg", "image/jpeg");
            this.put(".jpg", "image/jpeg");
            this.put(".js", "application/javascript");
            this.put(".json", "application/json");
            this.put(".mid", "audio/midi");
            this.put(".midi", "audio/midi");
            this.put(".mpeg", "video/mpeg");
            this.put(".mpkg", "application/vnd.apple.installer+xml");
            this.put(".odp", "application/vnd.oasis.opendocument.presentation");
            this.put(".ods", "application/vnd.oasis.opendocument.spreadsheet");
            this.put(".odt", "application/vnd.oasis.opendocument.text");
            this.put(".oga", "audio/ogg");
            this.put(".ogv", "video/ogg");
            this.put(".ogx", "application/ogg");
            this.put(".otf", "font/otf");
            this.put(".png", "image/png");
            this.put(".pdf", "application/pdf");
            this.put(".ppt", "application/vnd.ms-powerpoint");
            this.put(".pptx", "application/vnd.openxmlformats-officedocument.presentationml.presentation");
            this.put(".rar", "application/x-rar-compressed");
            this.put(".rtf", "application/rtf");
            this.put(".sh", "application/x-sh");
            this.put(".svg", "image/svg+xml");
            this.put(".swf", "application/x-shockwave-flash");
            this.put(".tar", "application/x-tar");
            this.put(".tif", "image/tiff");
            this.put(".tiff", "image/tiff");
            this.put(".ts", "application/typescript");
            this.put(".ttf", "font/ttf");
            this.put(".vsd", "application/vnd.visio");
            this.put(".wav", "audio/x-wav");
            this.put(".weba", "audio/webm");
            this.put(".webm", "video/webm");
            this.put(".webp", "image/webp");
            this.put(".woff", "font/woff");
            this.put(".woff2", "font/woff2");
            this.put(".xhtml", "application/xhtml+xml");
            this.put(".xls", "application/vnd.ms-excel");
            this.put(".xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            this.put(".xml", "application/xml");
            this.put(".xul", "application/vnd.mozilla.xul+xml");
            this.put(".zip", "application/zip");
            this.put(".7z", "application/x-7z-compressed");
        }
    };
    private Bundle bundle;

    ResourceFilter(Mediator mediator) {
        this.bundle = mediator.getContext().getBundle();
    }

    public void init(FilterConfig config) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        URL url;
        int index;
        String resName;
        if (res.isCommitted()) {
            return;
        }
        String target = ((HttpServletRequest)req).getRequestURI();
        if (target == null) {
            target = "";
        }
        if (!target.startsWith("/")) {
            target = "/" + target;
        }
        String contentType = MIME.get(resName.substring((index = (resName = target).lastIndexOf(46)) < 0 ? 0 : index));
        Bundle bundle = this.bundle;
        synchronized (bundle) {
            url = this.bundle.getEntry(resName);
        }
        try {
            if (url != null) {
                if (contentType != null) {
                    ((HttpServletResponse)res).setHeader("Content-Type", contentType);
                }
                ServletOutputStream output = res.getOutputStream();
                byte[] resourceBytes = IOUtils.read((InputStream)url.openStream());
                output.write(resourceBytes);
                ((HttpServletResponse)res).setStatus(200);
            } else {
                ((HttpServletResponse)res).setStatus(404);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void destroy() {
    }
}

