/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.http.smpl;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.execution.Executable;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.HttpTaskConfigurator;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.HttpTaskProcessingContext;
import org.eclipse.sensinact.gateway.sthbnd.http.task.HttpTask;
import org.eclipse.sensinact.gateway.util.CastUtils;
import org.eclipse.sensinact.gateway.util.UriUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpTaskProcessingContext
implements HttpTaskProcessingContext {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultHttpTaskProcessingContext.class);
    protected Mediator mediator;
    protected Map<String, Executable<Void, String>> properties;
    private HttpTaskConfigurator httpTaskConfigurator;

    public DefaultHttpTaskProcessingContext(Mediator mediator, HttpTaskConfigurator httpTaskConfigurator, final String endpointId, final HttpTask<?, ?> task) {
        this.mediator = mediator;
        this.httpTaskConfigurator = httpTaskConfigurator;
        this.properties = new HashMap<String, Executable<Void, String>>();
        this.properties.put("endpoint.id", new Executable<Void, String>(){

            public String execute(Void parameter) throws Exception {
                return endpointId;
            }
        });
        this.properties.put("task.result", new Executable<Void, String>(){

            public String execute(Void parameter) throws Exception {
                return (String)CastUtils.cast(String.class, (Object)task.getResult());
            }
        });
        this.properties.put("task.path", new Executable<Void, String>(){

            public String execute(Void parameter) throws Exception {
                return task.getPath();
            }
        });
        this.properties.put("task.profile", new Executable<Void, String>(){

            public String execute(Void parameter) throws Exception {
                return task.getProfile();
            }
        });
        this.properties.put("task.serviceProvider", new Executable<Void, String>(){

            public String execute(Void parameter) throws Exception {
                String[] uriElements = UriUtils.getUriElements((String)task.getPath());
                if (uriElements.length > 0) {
                    return uriElements[0];
                }
                return null;
            }
        });
        this.properties.put("task.service", new Executable<Void, String>(){

            public String execute(Void parameter) throws Exception {
                String[] uriElements = UriUtils.getUriElements((String)task.getPath());
                if (uriElements.length > 1) {
                    return uriElements[1];
                }
                return null;
            }
        });
        this.properties.put("task.resource", new Executable<Void, String>(){

            public String execute(Void parameter) throws Exception {
                String[] uriElements = UriUtils.getUriElements((String)task.getPath());
                if (uriElements.length > 2) {
                    return uriElements[2];
                }
                return null;
            }
        });
    }

    @Override
    public String resolve(String property) {
        Executable<Void, String> executable = this.properties.get(property);
        if (executable != null) {
            try {
                return (String)executable.execute(null);
            }
            catch (Exception e) {
                LOG.error(e.getMessage());
            }
        }
        return null;
    }

    @Override
    public HttpTaskConfigurator getHttpTaskConfigurator() {
        return this.httpTaskConfigurator;
    }
}

