/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.http;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.Map;
import org.eclipse.sensinact.gateway.protocol.http.client.Request;
import org.eclipse.sensinact.gateway.sthbnd.http.HttpConnectionConfiguration;
import org.eclipse.sensinact.gateway.sthbnd.http.HttpPacket;
import org.eclipse.sensinact.gateway.sthbnd.http.HttpResponse;
import org.eclipse.sensinact.gateway.sthbnd.http.HttpResponsePacket;

public class SimpleHttpResponse
extends HttpResponse {
    private Class<? extends HttpPacket> packetType;

    public SimpleHttpResponse(HttpURLConnection connection, HttpConnectionConfiguration<? extends HttpResponse, ? extends Request<? extends HttpResponse>> configuration) throws IOException {
        super(connection, configuration);
        this.packetType = configuration.getPacketType();
    }

    @Override
    public HttpPacket createPacket() {
        if (this.packetType == null) {
            return new HttpResponsePacket(this);
        }
        try {
            if (HttpResponsePacket.class.isAssignableFrom(this.packetType)) {
                return this.packetType.getConstructor(HttpResponse.class).newInstance(new Object[]{this});
            }
            return this.packetType.getConstructor(Map.class, byte[].class).newInstance(super.getHeaders(), super.getContent());
        }
        catch (Exception e) {
            return new HttpPacket(this.getHeaders(), super.getContent());
        }
    }
}

