/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.http.task;

import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.sensinact.gateway.core.ResourceConfig;
import org.eclipse.sensinact.gateway.core.method.AccessMethod;
import org.eclipse.sensinact.gateway.generic.Task;
import org.eclipse.sensinact.gateway.generic.TaskTranslator;
import org.eclipse.sensinact.gateway.protocol.http.client.Request;
import org.eclipse.sensinact.gateway.sthbnd.http.HttpPacket;
import org.eclipse.sensinact.gateway.sthbnd.http.HttpProtocolStackEndpoint;
import org.eclipse.sensinact.gateway.sthbnd.http.SimpleHttpResponse;
import org.eclipse.sensinact.gateway.sthbnd.http.task.HttpChainedTask;
import org.eclipse.sensinact.gateway.sthbnd.http.task.HttpTaskImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpChainedTasks<REQUEST extends Request<SimpleHttpResponse>, HTTP_CHAINED_TASK extends HttpChainedTask<REQUEST>>
extends HttpTaskImpl<SimpleHttpResponse, REQUEST> {
    private static final Logger LOG = LoggerFactory.getLogger(HttpChainedTasks.class);
    protected Deque<HTTP_CHAINED_TASK> chain = new LinkedList<HTTP_CHAINED_TASK>();
    protected Object intermediateResult;

    public abstract HTTP_CHAINED_TASK createChainedTask(String var1, Task.CommandType var2, String var3, String var4, ResourceConfig var5, Object[] var6);

    protected abstract byte[] getResultBytes();

    public HttpChainedTasks(Task.CommandType command, TaskTranslator transmitter, Class<REQUEST> requestType, String path, String profileId, ResourceConfig resourceConfig, Object[] parameters) {
        super(command, transmitter, requestType, path, profileId, resourceConfig, parameters);
    }

    public void execute() {
        Iterator<HTTP_CHAINED_TASK> iterator = this.chain.iterator();
        HttpChainedTask task = null;
        while (iterator.hasNext()) {
            task = (HttpChainedTask)iterator.next();
            long wait = task.getTimeout();
            try {
                task.execute(this.getIntermediateResult());
            }
            catch (Exception e) {
                e.printStackTrace();
                LOG.error(e.getMessage(), (Throwable)e);
            }
            task.execute();
            while (!task.isResultAvailable() && wait > 0L) {
                try {
                    Thread.sleep(150L);
                    wait -= 150L;
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                    LOG.error(e.getMessage(), (Throwable)e);
                    break;
                }
            }
            if (!task.isResultAvailable()) {
                task.abort(AccessMethod.EMPTY);
            }
            this.intermediateResult = task.getResult();
        }
        if (task == null) {
            super.abort(AccessMethod.EMPTY);
            return;
        }
        this.intermediateResult = task.getResult();
        byte[] bytes = this.getResultBytes();
        HttpPacket packet = null;
        Class packetType = this.packetType != null ? this.packetType : HttpPacket.class;
        try {
            packet = (HttpPacket)((Object)packetType.getConstructor(Map.class, byte[].class).newInstance(this.getHeaders(), bytes));
            ((HttpProtocolStackEndpoint)this.transmitter).process(packet);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public HTTP_CHAINED_TASK addChainedTask(String identifier) {
        return this.addChainedTask(this.createChainedTask(identifier, this.getCommand(), super.getPath(), super.getProfile(), super.getResourceConfig(), super.getParameters()));
    }

    public HTTP_CHAINED_TASK addChainedTask(HTTP_CHAINED_TASK task) {
        ((HttpTaskImpl)task).addHeaders(this.getHeaders());
        if (this.chain.add(task)) {
            return task;
        }
        return null;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    public Object getIntermediateResult() {
        return this.intermediateResult;
    }
}

