/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.http.smpl;

import java.io.IOException;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.sensinact.gateway.core.ResourceConfig;
import org.eclipse.sensinact.gateway.generic.ExtModelConfiguration;
import org.eclipse.sensinact.gateway.generic.InvalidProtocolStackException;
import org.eclipse.sensinact.gateway.generic.Task;
import org.eclipse.sensinact.gateway.sthbnd.http.HttpPacket;
import org.eclipse.sensinact.gateway.sthbnd.http.HttpProtocolStackEndpoint;
import org.eclipse.sensinact.gateway.sthbnd.http.SimpleHttpRequest;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.ChainedHttpTaskConfigurator;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.HttpChainedTaskProcessingContextFactory;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.HttpMediator;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.HttpTaskBuilder;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.HttpTaskConfigurator;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.HttpTaskProcessingContext;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.HttpTaskProcessingContextFactory;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.HttpTaskUrlConfigurator;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.RecurrentChainedTaskConfigurator;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.RecurrentHttpTaskConfigurator;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.RecurrentTaskConfigurator;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.SimpleTaskConfigurator;
import org.eclipse.sensinact.gateway.sthbnd.http.task.HttpChainedTask;
import org.eclipse.sensinact.gateway.sthbnd.http.task.HttpChainedTasks;
import org.eclipse.sensinact.gateway.sthbnd.http.task.HttpTask;
import org.eclipse.sensinact.gateway.sthbnd.http.task.HttpTaskImpl;
import org.eclipse.sensinact.gateway.sthbnd.http.task.config.ChainedHttpTaskDescription;
import org.eclipse.sensinact.gateway.sthbnd.http.task.config.ChainedHttpTasksDescription;
import org.eclipse.sensinact.gateway.sthbnd.http.task.config.HttpProtocolStackEndpointTasksDescription;
import org.eclipse.sensinact.gateway.sthbnd.http.task.config.HttpTasksDescription;
import org.eclipse.sensinact.gateway.sthbnd.http.task.config.RecurrentChainedHttpTaskDescription;
import org.eclipse.sensinact.gateway.sthbnd.http.task.config.RecurrentHttpTaskDescription;
import org.eclipse.sensinact.gateway.sthbnd.http.task.config.SimpleHttpTaskDescription;
import org.eclipse.sensinact.gateway.util.ReflectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class SimpleHttpProtocolStackEndpoint
extends HttpProtocolStackEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleHttpProtocolStackEndpoint.class);
    public static final Class<? extends HttpTask> GET_TASK = HttpTaskImpl.class;
    public static final Class<? extends HttpTask> SET_TASK = HttpTaskImpl.class;
    public static final Class<? extends HttpTask> ACT_TASK = HttpTaskImpl.class;
    public static final Class<? extends HttpTask> SUBSCRIBE_TASK = HttpTaskImpl.class;
    public static final Class<? extends HttpTask> UNSUBSCRIBE_TASK = HttpTaskImpl.class;
    public static final Class<? extends HttpTask> SERVICES_ENUMERATION_TASK = HttpTaskImpl.class;
    private String endpointId;
    private Class<? extends HttpTask> getTaskClass = null;
    private Class<? extends HttpTask> setTaskClass = null;
    private Class<? extends HttpTask> actTaskClass = null;
    private Class<? extends HttpTask> subscribeTaskClass = null;
    private Class<? extends HttpTask> unsubscribeTaskClass = null;
    private Class<? extends HttpTask> servicesEnumerationTaskClass = null;
    protected Deque<RecurrentHttpTaskConfigurator> recurrences;
    protected Map<Task.CommandType, HttpTaskBuilder> adapters;
    protected Map<Task.CommandType, HttpTaskUrlConfigurator> builders;
    protected Set<String> recurrenceTasks;
    protected ScheduledExecutorService worker;
    private HttpMediator mediator;

    public SimpleHttpProtocolStackEndpoint(HttpMediator mediator) throws ParserConfigurationException, SAXException, IOException {
        this.mediator = mediator;
        this.recurrences = new LinkedList<RecurrentHttpTaskConfigurator>();
        this.adapters = new HashMap<Task.CommandType, HttpTaskBuilder>();
        this.builders = new HashMap<Task.CommandType, HttpTaskUrlConfigurator>();
        this.recurrenceTasks = new HashSet<String>();
        this.worker = Executors.newScheduledThreadPool(3);
        ServiceLoader<HttpTaskUrlConfigurator> loader = ServiceLoader.load(HttpTaskUrlConfigurator.class, mediator.getClassLoader());
        for (HttpTaskUrlConfigurator builder : loader) {
            int length;
            Task.CommandType[] types = builder.handled();
            int n = length = types == null ? 0 : types.length;
            for (int index = 0; index < length; ++index) {
                this.builders.put(types[index], builder);
            }
        }
    }

    public void registerAdapters(HttpProtocolStackEndpointTasksDescription config) {
        int index;
        int length;
        HttpTasksDescription taskArray = config.getStandalone();
        List<SimpleHttpTaskDescription> tasks = taskArray == null ? null : taskArray.getTasks();
        int n = length = tasks == null ? 0 : tasks.size();
        for (index = 0; index < length; ++index) {
            this.registerAdapter(tasks.get(index));
        }
        List<RecurrentHttpTaskDescription> recurrences = taskArray == null ? null : taskArray.getRecurrences();
        int n2 = length = recurrences == null ? 0 : recurrences.size();
        for (index = 0; index < length; ++index) {
            this.registerAdapter(recurrences.get(index));
        }
        ChainedHttpTasksDescription chainedTaskArray = config.getChained();
        List<ChainedHttpTaskDescription> chainedTasks = chainedTaskArray == null ? null : chainedTaskArray.getTasks();
        int n3 = length = chainedTasks == null ? 0 : chainedTasks.size();
        for (index = 0; index < length; ++index) {
            this.registerAdapter(chainedTasks.get(index));
        }
        List<RecurrentChainedHttpTaskDescription> recurrentChainedTasks = chainedTaskArray == null ? null : chainedTaskArray.getRecurrences();
        int n4 = length = recurrentChainedTasks == null ? 0 : recurrentChainedTasks.size();
        for (index = 0; index < length; ++index) {
            this.registerAdapter(recurrentChainedTasks.get(index));
        }
    }

    public void registerAdapter(ChainedHttpTaskDescription chainedHttpTask) {
        List<Task.CommandType> commands = chainedHttpTask.getCommands();
        int length = commands == null ? 0 : commands.size();
        for (int index = 0; index < length; ++index) {
            ChainedHttpTaskConfigurator executor = new ChainedHttpTaskConfigurator(this, chainedHttpTask.getProfile(), commands.get(index), this.builders.get(commands.get(index)), chainedHttpTask.getConfiguration(), chainedHttpTask.getChain());
            switch (commands.get(index)) {
                case ACT: {
                    this.setActTaskType(chainedHttpTask.getChaining());
                    break;
                }
                case GET: {
                    this.setGetTaskType(chainedHttpTask.getChaining());
                    break;
                }
                case SERVICES_ENUMERATION: {
                    this.setServicesEnumerationTaskType(chainedHttpTask.getChaining());
                    break;
                }
                case SET: {
                    this.setSetTaskType(chainedHttpTask.getChaining());
                    break;
                }
                case SUBSCRIBE: {
                    this.setSubscribeTaskType(chainedHttpTask.getChaining());
                    break;
                }
                case UNSUBSCRIBE: {
                    this.setUnsubscribeTaskType(chainedHttpTask.getChaining());
                    break;
                }
            }
            this.adapters.put(commands.get(index), executor);
        }
    }

    public void registerAdapter(RecurrentChainedHttpTaskDescription chainedHttpTask) {
        RecurrentChainedTaskConfigurator executor = new RecurrentChainedTaskConfigurator(this, chainedHttpTask.getCommand(), this.builders.get(chainedHttpTask.getCommand()), chainedHttpTask.getChaining(), chainedHttpTask.getPeriod(), chainedHttpTask.getDelay(), chainedHttpTask.getTimeout(), chainedHttpTask.getConfiguration(), chainedHttpTask.getChain());
        this.recurrences.add(executor);
    }

    public void registerAdapter(SimpleHttpTaskDescription httpTaskAnnotation) {
        List<Task.CommandType> commands = httpTaskAnnotation.getCommands();
        int length = commands == null ? 0 : commands.size();
        for (int index = 0; index < length; ++index) {
            SimpleTaskConfigurator executor = new SimpleTaskConfigurator(this, httpTaskAnnotation.getProfile(), commands.get(index), this.builders.get(commands.get(index)), httpTaskAnnotation.getConfiguration());
            this.adapters.put(commands.get(index), executor);
        }
    }

    public void registerAdapter(RecurrentHttpTaskDescription reccurent) {
        RecurrentTaskConfigurator executor = new RecurrentTaskConfigurator(this, reccurent.getCommand(), this.builders.get(reccurent.getCommand()), this.getTaskType(reccurent.getCommand()), reccurent.getPeriod(), reccurent.getDelay(), reccurent.getTimeout(), reccurent.getConfiguration());
        this.recurrences.add(executor);
    }

    public void connect(ExtModelConfiguration manager) throws InvalidProtocolStackException {
        super.connect((ExtModelConfiguration<HttpPacket>)manager);
        for (final RecurrentHttpTaskConfigurator executable : this.recurrences) {
            final AtomicReference ref = new AtomicReference();
            ScheduledFuture<?> future = this.worker.scheduleWithFixedDelay(new Runnable(){
                private long timeout = 0L;
                private String taskId;

                @Override
                public void run() {
                    if (this.taskId == null) {
                        this.taskId = String.format("task_%s", this.hashCode());
                    }
                    if (SimpleHttpProtocolStackEndpoint.this.recurrenceTasks.contains(this.taskId)) {
                        return;
                    }
                    SimpleHttpProtocolStackEndpoint.this.recurrenceTasks.add(this.taskId);
                    if (this.timeout == 0L) {
                        long l = this.timeout = executable.getTimeout() == -1L ? -1L : System.currentTimeMillis() + executable.getTimeout();
                    }
                    if (this.timeout > -1L && System.currentTimeMillis() > this.timeout) {
                        SimpleHttpProtocolStackEndpoint.this.recurrenceTasks.remove(this.taskId);
                        ScheduledFuture future = (ScheduledFuture)ref.get();
                        if (future != null) {
                            future.cancel(true);
                        }
                        return;
                    }
                    HttpTask task = (HttpTask)ReflectUtils.getInstance(executable.getTaskType(), (Object[])new Object[]{executable.handled(), SimpleHttpProtocolStackEndpoint.this, SimpleHttpRequest.class, "/", null, null, null});
                    try {
                        if (ChainedHttpTaskConfigurator.class.isAssignableFrom(executable.getClass())) {
                            executable.configure(task);
                        } else {
                            HttpTaskProcessingContext context = SimpleHttpProtocolStackEndpoint.this.createContext(executable, task);
                            if (context != null) {
                                SimpleHttpProtocolStackEndpoint.this.mediator.registerProcessingContext(task, context);
                            }
                        }
                        task.execute();
                    }
                    catch (Exception e) {
                        LOG.error(e.getMessage(), (Throwable)e);
                    }
                    finally {
                        SimpleHttpProtocolStackEndpoint.this.recurrenceTasks.remove(this.taskId);
                    }
                }
            }, executable.getDelay(), executable.getPeriod(), TimeUnit.MILLISECONDS);
            ref.set(future);
        }
    }

    public HttpMediator getMediator() {
        return this.mediator;
    }

    public void setEndpointIdentifier(String endpointId) {
        this.endpointId = endpointId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(Task task) {
        HttpTask _task = (HttpTask)task;
        try {
            this.mediator.configure(_task);
            super.send((Task)_task);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.mediator.unregisterProcessingContext(_task);
        }
    }

    public Task createTask(Task.CommandType command, String path, String profileId, ResourceConfig resourceConfig, Object[] parameters) {
        HttpTaskConfigurator configuration = this.adapters.get(command);
        if (configuration == null) {
            return null;
        }
        HttpTask task = (HttpTask)super.wrap(HttpTask.class, (Task)((HttpTask)ReflectUtils.getInstance(this.getTaskType(command), (Object[])new Object[]{command, this, SimpleHttpRequest.class, path, profileId, resourceConfig, parameters})));
        try {
            if (task.getPacketType() == null) {
                task.setPacketType(this.packetType);
            }
            if (ChainedHttpTaskConfigurator.class.isAssignableFrom(configuration.getClass())) {
                configuration.configure(task);
            } else {
                HttpTaskProcessingContext context = this.createContext(configuration, task);
                if (context != null) {
                    this.mediator.registerProcessingContext(task, context);
                }
            }
            return task;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            this.mediator.unregisterProcessingContext(task);
            return null;
        }
    }

    protected HttpTaskProcessingContext createContext(HttpTaskConfigurator httpTaskConfigurator, HttpTask<?, ?> task) {
        HttpTaskProcessingContextFactory factory = null;
        factory = this.mediator.getTaskProcessingContextFactory();
        if (factory != null) {
            return factory.newInstance(httpTaskConfigurator, this.endpointId, task);
        }
        return null;
    }

    protected <CHAINED extends HttpChainedTask<?>> HttpTaskProcessingContext createChainedContext(HttpTaskConfigurator httpTaskConfigurator, HttpChainedTasks<?, CHAINED> tasks, CHAINED task) {
        HttpChainedTaskProcessingContextFactory factory = null;
        factory = this.mediator.getChainedTaskProcessingContextFactory();
        if (factory != null) {
            return factory.newInstance(httpTaskConfigurator, this.endpointId, tasks, task);
        }
        return null;
    }

    public void setGetTaskType(Class<? extends HttpTask> getTaskClass) {
        this.getTaskClass = getTaskClass;
    }

    public Class<? extends HttpTask> getGetTaskType() {
        if (this.getTaskClass == null) {
            return GET_TASK;
        }
        return this.getTaskClass;
    }

    public void setSetTaskType(Class<? extends HttpTask> setTaskClass) {
        this.setTaskClass = setTaskClass;
    }

    public Class<? extends HttpTask> getSetTaskType() {
        if (this.setTaskClass == null) {
            return SET_TASK;
        }
        return this.setTaskClass;
    }

    public void setActTaskType(Class<? extends HttpTask> actTaskClass) {
        this.actTaskClass = actTaskClass;
    }

    public Class<? extends HttpTask> getActTaskType() {
        if (this.actTaskClass == null) {
            return ACT_TASK;
        }
        return this.actTaskClass;
    }

    public void setSubscribeTaskType(Class<? extends HttpTask> subscribeTaskClass) {
        this.subscribeTaskClass = subscribeTaskClass;
    }

    public Class<? extends HttpTask> getSubscribeTaskType() {
        if (this.subscribeTaskClass == null) {
            return SUBSCRIBE_TASK;
        }
        return this.subscribeTaskClass;
    }

    public void setUnsubscribeTaskType(Class<? extends HttpTask> unsubscribeTaskClass) {
        this.unsubscribeTaskClass = unsubscribeTaskClass;
    }

    public Class<? extends HttpTask> getUnsubscribeTaskType() {
        if (this.unsubscribeTaskClass == null) {
            return UNSUBSCRIBE_TASK;
        }
        return this.unsubscribeTaskClass;
    }

    public void setServicesEnumerationTaskType(Class<? extends HttpTask> servicesEnumerationTaskClass) {
        this.servicesEnumerationTaskClass = servicesEnumerationTaskClass;
    }

    public Class<? extends HttpTask> getServicesEnumerationTaskType() {
        if (this.servicesEnumerationTaskClass == null) {
            return SERVICES_ENUMERATION_TASK;
        }
        return this.servicesEnumerationTaskClass;
    }

    protected Class<? extends HttpTask> getTaskType(Task.CommandType command) {
        switch (command) {
            case ACT: {
                return this.getActTaskType();
            }
            case GET: {
                return this.getGetTaskType();
            }
            case SERVICES_ENUMERATION: {
                return this.getServicesEnumerationTaskType();
            }
            case SET: {
                return this.getSetTaskType();
            }
            case SUBSCRIBE: {
                return this.getSubscribeTaskType();
            }
            case UNSUBSCRIBE: {
                return this.getUnsubscribeTaskType();
            }
        }
        return HttpTask.class;
    }

    @Override
    public void stop() {
        this.worker.shutdown();
        try {
            this.worker.awaitTermination(1000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.worker.shutdownNow();
        super.stop();
    }
}

