/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.liveobjects.task;

import org.eclipse.sensinact.gateway.common.execution.Executable;
import org.eclipse.sensinact.gateway.sthbnd.http.HttpProtocolStackEndpoint;
import org.eclipse.sensinact.gateway.sthbnd.http.SimpleHttpRequest;
import org.eclipse.sensinact.gateway.sthbnd.http.SimpleHttpResponse;
import org.eclipse.sensinact.gateway.sthbnd.http.task.HttpAuthenticationTask;
import org.json.JSONObject;

public class LiveObjectsUserAuthentication
extends HttpAuthenticationTask<SimpleHttpResponse, SimpleHttpRequest> {
    private final String email;
    private final String login;
    private final String password;

    public LiveObjectsUserAuthentication(HttpProtocolStackEndpoint transmitter, String email, String login, String password) {
        super(transmitter, SimpleHttpRequest.class);
        this.email = email;
        this.login = login;
        this.password = password;
        super.setAuthenticationHeaderKey("X-API-Key");
        Executable<Object, String> tokenExtractor = new Executable<Object, String>(){

            public String execute(Object parameter) throws Exception {
                JSONObject content = new JSONObject(new String((byte[])parameter));
                String token = content.getJSONObject("apiKey").getString("value");
                return token;
            }
        };
        super.registerTokenExtractor((Executable)tokenExtractor);
    }

    public String getUri() {
        return "https://liveobjects.orange-business.com/api/v0/auth?cookie=false";
    }

    public Object getContent() {
        JSONObject json = new JSONObject();
        json.put("email", (Object)this.email);
        json.put("login", (Object)this.login);
        json.put("password", (Object)this.password);
        return json.toString();
    }

    public String getHttpMethod() {
        return "POST";
    }

    public String getAccept() {
        return "application/json";
    }

    public String getContentType() {
        return "application/json";
    }
}

