/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.http.onem2m.task;

import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.core.ResourceConfig;
import org.eclipse.sensinact.gateway.core.method.AccessMethod;
import org.eclipse.sensinact.gateway.generic.Task;
import org.eclipse.sensinact.gateway.generic.TaskTranslator;
import org.eclipse.sensinact.gateway.sthbnd.http.SimpleHttpRequest;
import org.eclipse.sensinact.gateway.sthbnd.http.SimpleHttpResponse;
import org.eclipse.sensinact.gateway.sthbnd.http.task.HttpTaskImpl;
import org.json.JSONObject;

public class OneM2MGetTask
extends HttpTaskImpl<SimpleHttpResponse, SimpleHttpRequest> {
    private Mediator mediator;

    public OneM2MGetTask(Mediator mediator, Task.CommandType command, TaskTranslator transmitter, Class<SimpleHttpRequest> requestType, String path, String profileId, ResourceConfig resourceConfig, Object[] parameters) {
        super(command, transmitter, requestType, path, profileId, resourceConfig, parameters);
        this.mediator = mediator;
    }

    public String getUri() {
        String host = (String)this.mediator.getProperty("http.onem2m.host");
        String port = (String)this.mediator.getProperty("http.onem2m.port");
        String cseBase = (String)this.mediator.getProperty("http.onem2m.cse.base");
        String[] path = super.getPath().split("/");
        String uri = "container".equalsIgnoreCase(path[2]) ? "http://" + host + ":" + port + "/" + cseBase + "/" + path[1] + "/" + path[3] + "/latest" : "http://" + host + ":" + port + "/" + cseBase + "/" + path[1] + "/" + path[2] + "/" + path[3] + "/latest";
        return uri;
    }

    public void setResult(Object result) {
        JSONObject content = new JSONObject(new String((byte[])result));
        if (content.has("m2m:cin")) {
            super.setResult((Object)content.getJSONObject("m2m:cin").getString("con"));
        } else {
            super.setResult(AccessMethod.EMPTY);
        }
    }
}

