/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.http.openweather.osgi;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.execution.Executable;
import org.eclipse.sensinact.gateway.generic.ExtModelConfiguration;
import org.eclipse.sensinact.gateway.generic.ExtModelConfigurationBuilder;
import org.eclipse.sensinact.gateway.generic.InvalidProtocolStackException;
import org.eclipse.sensinact.gateway.sthbnd.http.HttpPacket;
import org.eclipse.sensinact.gateway.sthbnd.http.annotation.ChainedHttpTasks;
import org.eclipse.sensinact.gateway.sthbnd.http.annotation.HttpChildTaskConfiguration;
import org.eclipse.sensinact.gateway.sthbnd.http.annotation.HttpTaskConfiguration;
import org.eclipse.sensinact.gateway.sthbnd.http.annotation.KeyValuePair;
import org.eclipse.sensinact.gateway.sthbnd.http.annotation.RecurrentChainedHttpTask;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.DefaultHttpChainedTaskProcessingContext;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.DefaultHttpChainedTaskProcessingContextFactory;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.HttpActivator;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.HttpChainedTaskProcessingContextFactory;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.HttpMediator;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.HttpTaskConfigurator;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.HttpTaskProcessingContext;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.SimpleHttpProtocolStackEndpoint;
import org.eclipse.sensinact.gateway.sthbnd.http.task.HttpChainedTask;
import org.eclipse.sensinact.gateway.sthbnd.http.task.HttpChainedTasks;
import org.json.JSONArray;
import org.osgi.annotation.bundle.Header;

@ChainedHttpTasks(recurrences={@RecurrentChainedHttpTask(delay=1000L, period=300000L, configuration=@HttpTaskConfiguration(host="#EMPTY#"), chain={@HttpChildTaskConfiguration(host="api.openweathermap.org", path="/data/2.5/weather", identifier="weather", query={@KeyValuePair(key="units", value="metric"), @KeyValuePair(key="lat", value="$(org.eclipse.sensinact.gateway.weather.latitude.@context[endpoint.id])"), @KeyValuePair(key="lon", value="$(org.eclipse.sensinact.gateway.weather.longitude.@context[endpoint.id])"), @KeyValuePair(key="APPID", value="$(openweather-token)")}), @HttpChildTaskConfiguration(host="openweathermap.org", path="/img/w/@context[weather.icon].png", identifier="icon", query={@KeyValuePair(key="APPID", value="$(openweather-token)")})})})
@Header(name="Bundle-Activator", value="${@class}")
public class Activator
extends HttpActivator {
    List<SimpleHttpProtocolStackEndpoint> endpoints;

    public void doStart() throws Exception {
        int length;
        ((HttpMediator)this.mediator).setTaskProcessingContextHandler(this.getProcessingContextHandler());
        ((HttpMediator)this.mediator).setTaskProcessingContextFactory(this.getTaskProcessingContextFactory());
        ((HttpMediator)this.mediator).setChainedTaskProcessingContextFactory(this.getChainedTaskProcessingContextFactory());
        ExtModelConfiguration configuration = ExtModelConfigurationBuilder.instance((Mediator)this.mediator, this.getPacketType()).withStartAtInitializationTime(this.isStartingAtInitializationTime()).withServiceBuildPolicy(this.getServiceBuildPolicy()).withResourceBuildPolicy(this.getResourceBuildPolicy()).build(new Object[]{this.getResourceDescriptionFile(), this.getDefaults()});
        this.endpoints = new ArrayList<SimpleHttpProtocolStackEndpoint>();
        String stationsList = (String)((HttpMediator)this.mediator).getProperty("org.eclipse.sensinact.gateway.weather.stations");
        String[] stations = stationsList.split(",");
        int n = length = stations == null ? 0 : stations.length;
        for (int index = 0; index < length; ++index) {
            String station = stations[index];
            SimpleHttpProtocolStackEndpoint endpoint = this.configureProtocolStackEndpoint();
            endpoint.setEndpointIdentifier(station);
            endpoint.connect(configuration);
        }
    }

    public void doStop() throws Exception {
        while (!this.endpoints.isEmpty()) {
            this.endpoints.remove(0).stop();
        }
    }

    public Class<? extends HttpPacket> getPacketType() {
        return HttpPacket.class;
    }

    public HttpChainedTaskProcessingContextFactory getChainedTaskProcessingContextFactory() {
        return new DefaultHttpChainedTaskProcessingContextFactory(this.mediator){

            public <CHAINED extends HttpChainedTask<?>> HttpTaskProcessingContext newInstance(HttpTaskConfigurator httpTaskConfigurator, String endpointId, HttpChainedTasks<?, CHAINED> tasks, CHAINED task) {
                return new OpenWeatherTaskProcessingContext(Activator.this.mediator, httpTaskConfigurator, endpointId, tasks, task);
            }
        };
    }

    protected void connect(ExtModelConfiguration configuration) throws InvalidProtocolStackException {
    }

    private class OpenWeatherTaskProcessingContext
    extends DefaultHttpChainedTaskProcessingContext {
        public <CHAINED extends HttpChainedTask<?>> OpenWeatherTaskProcessingContext(Mediator mediator, HttpTaskConfigurator httpTaskConfigurator, String endpointId, final HttpChainedTasks<?, CHAINED> tasks, CHAINED task) {
            super(mediator, httpTaskConfigurator, endpointId, tasks, task);
            this.properties.put("weather.icon", new Executable<Void, String>(){

                public String execute(Void parameter) throws Exception {
                    Object intermediate = tasks.getIntermediateResult();
                    if (intermediate == null) {
                        return null;
                    }
                    String result = intermediate.toString();
                    String icon = new JSONArray(result).optJSONObject(0).optJSONObject("weather").optJSONArray("weather").optJSONObject(0).getString("icon");
                    return icon;
                }
            });
        }
    }
}

