/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.http.openweather.internal;

import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.eclipse.sensinact.gateway.generic.packet.InvalidPacketException;
import org.eclipse.sensinact.gateway.generic.packet.SimplePacketReader;
import org.eclipse.sensinact.gateway.sthbnd.http.HttpPacket;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenWeatherPacketReader
extends SimplePacketReader<HttpPacket> {
    private static final Logger LOG = LoggerFactory.getLogger(OpenWeatherPacketReader.class);
    private List<WeatherSubPacket> subPackets;
    private HttpPacket packet = null;

    public void load(HttpPacket packet) throws InvalidPacketException {
        this.packet = packet;
        this.subPackets = new ArrayList<WeatherSubPacket>();
    }

    public void parse() throws InvalidPacketException {
        if (this.packet == null) {
            super.configureEOF();
            return;
        }
        if (this.subPackets.isEmpty()) {
            String content = new String(this.packet.getBytes());
            JSONArray jsonArray = new JSONArray(content);
            String serviceProvider = null;
            try {
                String iconObject;
                JSONObject jsonObject = jsonArray.optJSONObject(0);
                JSONObject weatherObject = jsonObject.optJSONObject("weather");
                if (!JSONObject.NULL.equals(weatherObject) && weatherObject.length() != 0) {
                    serviceProvider = weatherObject.getString("name");
                    this.parseWeather(serviceProvider, weatherObject);
                }
                if ((iconObject = (jsonObject = jsonArray.optJSONObject(1)).optString("icon")) != null && iconObject.length() != 0) {
                    WeatherSubPacket sp = new WeatherSubPacket();
                    sp.serviceProvider = serviceProvider;
                    sp.service = "weather";
                    sp.resource = "image";
                    sp.data = Base64.getEncoder().encode(iconObject.getBytes());
                    this.subPackets.add(sp);
                }
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
                super.configureEOF();
                throw new InvalidPacketException((Throwable)e);
            }
            if (!this.subPackets.isEmpty()) {
                this.parse();
            }
        } else {
            WeatherSubPacket sub = this.subPackets.remove(0);
            super.setServiceProviderId(sub.serviceProvider);
            super.setServiceId(sub.service);
            super.setResourceId(sub.resource);
            super.setTimestamp(sub.timestamp == 0L ? System.currentTimeMillis() : sub.timestamp);
            super.setData(sub.data);
            if (this.subPackets.isEmpty()) {
                this.packet = null;
            }
            super.configure();
            return;
        }
        super.configureEOF();
    }

    private void parseWeather(String station, JSONObject object) {
        JSONObject main;
        JSONObject wind;
        long timestamp = object.optLong("dt") * 1000L;
        JSONObject coord = object.optJSONObject("coord");
        if (coord != null) {
            WeatherSubPacket sp = new WeatherSubPacket();
            sp.serviceProvider = station;
            sp.service = "admin";
            sp.resource = "location";
            sp.data = "" + coord.optDouble("lat") + ':' + coord.optDouble("lon");
            this.subPackets.add(sp);
        }
        JSONArray weather = object.optJSONArray("weather");
        JSONObject content = null;
        if (weather != null && (content = weather.optJSONObject(0)) != null) {
            WeatherSubPacket sp = new WeatherSubPacket();
            sp.serviceProvider = station;
            sp.service = "weather";
            sp.resource = "state";
            sp.data = content.opt("main");
            sp.timestamp = timestamp;
            this.subPackets.add(sp);
            sp = new WeatherSubPacket();
            sp.serviceProvider = station;
            sp.service = "weather";
            sp.resource = "description";
            sp.data = content.opt("description");
            sp.timestamp = timestamp;
            this.subPackets.add(sp);
        }
        if ((wind = object.optJSONObject("wind")) != null) {
            WeatherSubPacket sp = new WeatherSubPacket();
            sp.serviceProvider = station;
            sp.service = "weather";
            sp.resource = "wind";
            sp.data = wind.opt("speed");
            sp.timestamp = timestamp;
            this.subPackets.add(sp);
            sp = new WeatherSubPacket();
            sp.serviceProvider = station;
            sp.service = "weather";
            sp.resource = "orientation";
            sp.data = wind.opt("deg");
            sp.timestamp = timestamp;
            this.subPackets.add(sp);
        }
        if ((main = object.optJSONObject("main")) != null) {
            WeatherSubPacket sp = new WeatherSubPacket();
            sp.serviceProvider = station;
            sp.service = "weather";
            sp.resource = "temperature";
            sp.data = main.opt("temp");
            sp.timestamp = timestamp;
            this.subPackets.add(sp);
            sp = new WeatherSubPacket();
            sp.serviceProvider = station;
            sp.service = "weather";
            sp.resource = "humidity";
            sp.data = main.opt("humidity");
            sp.timestamp = timestamp;
            this.subPackets.add(sp);
            sp = new WeatherSubPacket();
            sp.serviceProvider = station;
            sp.service = "weather";
            sp.resource = "pressure";
            sp.data = main.opt("pressure");
            sp.timestamp = timestamp;
            this.subPackets.add(sp);
        }
    }

    class WeatherSubPacket {
        String serviceProvider;
        String service;
        String resource;
        Object data;
        long timestamp;

        WeatherSubPacket() {
        }
    }
}

