/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.mqtt.util.api;

import java.util.Properties;

public class MqttAuthentication {
    private String username;
    private String password;
    private String certificate;
    private Properties sslProperties;

    public MqttAuthentication(Builder builder) {
        this.username = builder.username;
        this.password = builder.password;
        this.certificate = builder.certificate;
        this.sslProperties = builder.sslProperties;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getCertificate() {
        return this.certificate;
    }

    public Properties getSslProperties() {
        return this.sslProperties;
    }

    public static class Builder {
        private String username = null;
        private String password = null;
        private String certificate = null;
        private Properties sslProperties = new Properties();

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder cleanSession(String certificate) {
            this.certificate = certificate;
            return this;
        }

        public Builder sslProperties(Properties sslProperties) {
            this.sslProperties = sslProperties;
            return this;
        }

        public MqttAuthentication build() {
            return new MqttAuthentication(this);
        }
    }
}

