/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.mqtt.smarttopic;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import org.eclipse.sensinact.gateway.core.ModelConfiguration;
import org.eclipse.sensinact.gateway.core.SensiNactResourceModelConfiguration;
import org.eclipse.sensinact.gateway.generic.ProtocolStackEndpoint;
import org.eclipse.sensinact.gateway.generic.ProtocolStackEndpointConfiguratorAdapter;
import org.eclipse.sensinact.gateway.generic.packet.InvalidPacketException;
import org.eclipse.sensinact.gateway.generic.packet.Packet;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.device.MqttPacket;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.device.MqttProtocolStackEndpoint;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.smarttopic.exception.MessageInvalidSmartTopicException;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.smarttopic.model.SmartTopicInterpolator;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.smarttopic.processor.ProcessorExecutor;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.smarttopic.processor.ProcessorUtil;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.smarttopic.processor.formats.ProcessorFormatArray;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.smarttopic.processor.formats.ProcessorFormatBase64;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.smarttopic.processor.formats.ProcessorFormatDivide;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.smarttopic.processor.formats.ProcessorFormatJSON;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.smarttopic.processor.formats.ProcessorFormatMinus;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.smarttopic.processor.formats.ProcessorFormatMultiply;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.smarttopic.processor.formats.ProcessorFormatPlus;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.smarttopic.processor.formats.ProcessorFormatToFloat;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.smarttopic.processor.formats.ProcessorFormatToInteger;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.smarttopic.processor.formats.ProcessorFormatToString;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.smarttopic.processor.formats.ProcessorFormatURLEncode;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.smarttopic.processor.formats.iface.ProcessorFormatIface;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.util.api.MqttAuthentication;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.util.api.MqttBroker;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.util.api.MqttTopic;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.util.listener.MqttTopicMessage;

class SmartTopicConfigurator
extends ProtocolStackEndpointConfiguratorAdapter {
    private static final ProcessorExecutor PROCESSOR_EXECUTOR = new ProcessorExecutor((List<ProcessorFormatIface>)new ArrayList<ProcessorFormatIface>(){
        {
            this.add(new ProcessorFormatArray());
            this.add(new ProcessorFormatBase64());
            this.add(new ProcessorFormatJSON());
            this.add(new ProcessorFormatToString());
            this.add(new ProcessorFormatURLEncode());
            this.add(new ProcessorFormatPlus());
            this.add(new ProcessorFormatMinus());
            this.add(new ProcessorFormatMultiply());
            this.add(new ProcessorFormatDivide());
            this.add(new ProcessorFormatToFloat());
            this.add(new ProcessorFormatToInteger());
        }
    });
    private boolean preconfigured = false;
    private MqttTopicMessage listener;
    private String provider;
    private String service;
    private String resource;
    private SmartTopicInterpolator smartTopicInterpolator;
    private MqttBroker broker;
    private String topic;
    private Object latitude;
    private Object longitude;
    private boolean startAtInitializationTime;

    SmartTopicConfigurator() {
    }

    public void preConnectConfiguration(final ProtocolStackEndpoint<?> endpoint, ModelConfiguration configuration, Dictionary<?, ?> props) {
        Object port;
        Object host;
        String id = (String)props.get("id");
        String username = (String)props.get("username");
        String password = (String)props.get("password");
        MqttAuthentication authentication = this.createAuthentication(username, password);
        Object protocol = props.get("protocol");
        if (protocol == null) {
            protocol = "TCP";
        }
        if ((host = props.get("host")) == null) {
            host = "127.0.0.1";
        }
        port = (port = props.get("port")) == null ? Integer.valueOf(1883) : Integer.valueOf(String.valueOf(port));
        this.broker = this.createBroker(String.valueOf(protocol), String.valueOf(host), (Integer)port, authentication);
        if (this.broker == null) {
            return;
        }
        this.topic = (String)props.get("topic");
        if (this.topic == null) {
            return;
        }
        Object topicTypeProperties = props.get("topic.type");
        if (topicTypeProperties == null) {
            topicTypeProperties = "mqtt";
        }
        final String topicType = String.valueOf(topicTypeProperties);
        final String processor = (String)props.get("processor");
        Object interpolatedLatitude = props.get("location.latitude");
        if (interpolatedLatitude != null) {
            interpolatedLatitude = Float.valueOf(String.valueOf(interpolatedLatitude));
        }
        this.latitude = interpolatedLatitude;
        Object interpolatedLongitude = props.get("location.longitude");
        if (interpolatedLongitude != null) {
            interpolatedLongitude = Float.valueOf(String.valueOf(interpolatedLongitude));
        }
        this.longitude = interpolatedLongitude;
        this.startAtInitializationTime = configuration.getStartAtInitializationTime();
        String interpolatedProvider = null;
        String interpolatedService = null;
        String interpolatedResource = null;
        switch (topicType) {
            case "smarttopic": {
                this.smartTopicInterpolator = new SmartTopicInterpolator(this.topic);
                try {
                    interpolatedProvider = this.smartTopicInterpolator.getGroup(this.topic, "provider");
                    try {
                        interpolatedService = this.smartTopicInterpolator.getGroup(this.topic, "service");
                    }
                    catch (MessageInvalidSmartTopicException e1) {
                        interpolatedService = "info";
                    }
                    try {
                        interpolatedResource = this.smartTopicInterpolator.getGroup(this.topic, "resource");
                    }
                    catch (MessageInvalidSmartTopicException e1) {
                        interpolatedResource = "value";
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    interpolatedProvider = null;
                }
                break;
            }
            case "mqtt": {
                interpolatedProvider = id;
                interpolatedService = "info";
                interpolatedResource = "value";
                this.smartTopicInterpolator = null;
                break;
            }
            default: {
                return;
            }
        }
        this.provider = interpolatedProvider;
        this.service = interpolatedService;
        this.resource = interpolatedResource;
        if (this.provider == null) {
            return;
        }
        this.listener = new MqttTopicMessage(){
            private volatile boolean started = false;

            public void messageReceived(String topic, String message) {
                try {
                    if (!this.started && !SmartTopicConfigurator.this.startAtInitializationTime) {
                        MqttPacket packet = new MqttPacket(SmartTopicConfigurator.this.provider, SmartTopicConfigurator.this.service, SmartTopicConfigurator.this.resource, null);
                        packet.setHelloMessage(true);
                        ((MqttProtocolStackEndpoint)endpoint).process((Packet)packet);
                        if (SmartTopicConfigurator.this.latitude != null && SmartTopicConfigurator.this.longitude != null) {
                            packet = new MqttPacket(SmartTopicConfigurator.this.provider, "admin", "location", "" + SmartTopicConfigurator.this.latitude + ':' + SmartTopicConfigurator.this.longitude);
                            ((MqttProtocolStackEndpoint)endpoint).process((Packet)packet);
                        }
                    }
                    this.started = true;
                    String value = null;
                    switch (topicType) {
                        case "mqtt": {
                            value = PROCESSOR_EXECUTOR.execute(message, ProcessorUtil.transformProcessorListInSelector(processor == null ? "" : processor));
                            break;
                        }
                        case "smarttopic": {
                            try {
                                value = SmartTopicConfigurator.this.smartTopicInterpolator.getGroup(message, "value");
                            }
                            catch (MessageInvalidSmartTopicException e1) {
                                value = message;
                            }
                            value = PROCESSOR_EXECUTOR.execute(value, ProcessorUtil.transformProcessorListInSelector(processor == null ? "" : processor));
                            break;
                        }
                    }
                    ((MqttProtocolStackEndpoint)endpoint).process((Packet)new MqttPacket(SmartTopicConfigurator.this.provider, SmartTopicConfigurator.this.service, SmartTopicConfigurator.this.resource, value));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.preconfigured = true;
        MqttTopic mqttTopic = new MqttTopic(this.topic, this.listener);
        this.broker.getTopics().add(mqttTopic);
        ((MqttProtocolStackEndpoint)endpoint).addBroker(this.broker);
    }

    public void postConnectConfiguration(ProtocolStackEndpoint<?> endpoint, ModelConfiguration configuration, Dictionary<?, ?> props) {
        if (!this.preconfigured) {
            return;
        }
        if (this.startAtInitializationTime) {
            MqttPacket packet = new MqttPacket(this.provider, this.service, this.resource, null);
            packet.setHelloMessage(true);
            try {
                ((MqttProtocolStackEndpoint)endpoint).process((Packet)packet);
            }
            catch (InvalidPacketException e) {
                e.printStackTrace();
            }
            if (this.latitude != null && this.longitude != null) {
                packet = new MqttPacket(this.provider, "admin", "location", "" + this.latitude + ':' + this.longitude);
                try {
                    ((MqttProtocolStackEndpoint)endpoint).process((Packet)packet);
                }
                catch (InvalidPacketException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public Class<? extends ProtocolStackEndpoint> getDefaultEndpointType() {
        return MqttProtocolStackEndpoint.class;
    }

    public Class<? extends Packet> getDefaultPacketType() {
        return MqttPacket.class;
    }

    public SensiNactResourceModelConfiguration.BuildPolicy[] getDefaultServiceBuildPolicy() {
        return new SensiNactResourceModelConfiguration.BuildPolicy[]{SensiNactResourceModelConfiguration.BuildPolicy.BUILD_NON_DESCRIBED};
    }

    public SensiNactResourceModelConfiguration.BuildPolicy[] getDefaultResourceBuildPolicy() {
        return new SensiNactResourceModelConfiguration.BuildPolicy[]{SensiNactResourceModelConfiguration.BuildPolicy.BUILD_NON_DESCRIBED};
    }

    private MqttAuthentication createAuthentication(String username, String password) {
        MqttAuthentication authentication = null;
        if (username != null && !username.trim().equals("") && password != null && !password.trim().equals("")) {
            authentication = new MqttAuthentication.Builder().username(username).password(password).build();
        }
        return authentication;
    }

    private MqttBroker createBroker(String protocol, String host, int port, MqttAuthentication authentication) {
        MqttBroker broker = new MqttBroker.Builder().host(host).port(port).protocol(MqttBroker.Protocol.valueOf((String)protocol)).authentication(authentication).build();
        return broker;
    }
}

