/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.mqtt.smarttopic.processor.formats;

import java.text.DecimalFormat;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.smarttopic.processor.formats.ProcessorFormatToFloat;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.smarttopic.processor.formats.exception.ProcessorFormatException;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.smarttopic.processor.formats.iface.ProcessorFormatIface;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.smarttopic.processor.selector.SelectorIface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessorFormatToInteger
implements ProcessorFormatIface {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessorFormatToFloat.class);

    @Override
    public String getName() {
        return "toInteger";
    }

    @Override
    public String process(String inData, SelectorIface selector) throws ProcessorFormatException {
        try {
            Float value = Float.valueOf(Float.parseFloat(inData));
            String pattern = selector.getExpression().equals("") ? "0" : selector.getExpression();
            return new DecimalFormat(pattern).format(value).toString();
        }
        catch (Exception e) {
            LOG.error("Failed to apply {} filter. Bypassing filter", (Object)this.getName(), (Object)e);
            return inData;
        }
    }
}

