/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.parser.netty;

import io.moquette.parser.netty.DemuxEncoder;
import io.moquette.parser.netty.Utils;
import io.moquette.parser.proto.messages.AbstractMessage;
import io.moquette.parser.proto.messages.PublishMessage;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.ReferenceCounted;

class PublishEncoder
extends DemuxEncoder<PublishMessage> {
    PublishEncoder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encode(ChannelHandlerContext ctx, PublishMessage message, ByteBuf out) {
        if (message.getQos() == AbstractMessage.QOSType.RESERVED) {
            throw new IllegalArgumentException("Found a message with RESERVED Qos");
        }
        if (message.getTopicName() == null || message.getTopicName().isEmpty()) {
            throw new IllegalArgumentException("Found a message with empty or null topic name");
        }
        ByteBuf variableHeaderBuff = ctx.alloc().buffer(2);
        ReferenceCounted buff = null;
        try {
            variableHeaderBuff.writeBytes(Utils.encodeString(message.getTopicName()));
            if (message.getQos() == AbstractMessage.QOSType.LEAST_ONE || message.getQos() == AbstractMessage.QOSType.EXACTLY_ONCE) {
                if (message.getMessageID() == null) {
                    throw new IllegalArgumentException("Found a message with QOS 1 or 2 and not MessageID setted");
                }
                variableHeaderBuff.writeShort(message.getMessageID());
            }
            variableHeaderBuff.writeBytes(message.getPayload());
            int variableHeaderSize = variableHeaderBuff.readableBytes();
            byte flags = Utils.encodeFlags(message);
            buff = ctx.alloc().buffer(2 + variableHeaderSize);
            ((ByteBuf)buff).writeByte(0x30 | flags);
            ((ByteBuf)buff).writeBytes(Utils.encodeRemainingLength(variableHeaderSize));
            ((ByteBuf)buff).writeBytes(variableHeaderBuff);
            out.writeBytes((ByteBuf)buff);
        }
        finally {
            variableHeaderBuff.release();
            if (buff != null) {
                buff.release();
            }
        }
    }
}

