/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.parser.netty;

import io.moquette.parser.netty.DemuxEncoder;
import io.moquette.parser.netty.Utils;
import io.moquette.parser.proto.messages.ConnectMessage;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;

public class ConnectEncoder
extends DemuxEncoder<ConnectMessage> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encode(ChannelHandlerContext chc, ConnectMessage message, ByteBuf out) {
        ByteBuf staticHeaderBuff = chc.alloc().buffer(12);
        ByteBuf buff = chc.alloc().buffer();
        ByteBuf variableHeaderBuff = chc.alloc().buffer(12);
        try {
            staticHeaderBuff.writeBytes(Utils.encodeString("MQIsdp"));
            staticHeaderBuff.writeByte(3);
            int connectionFlags = 0;
            if (message.isCleanSession()) {
                connectionFlags = (byte)(connectionFlags | 2);
            }
            if (message.isWillFlag()) {
                connectionFlags = (byte)(connectionFlags | 4);
            }
            connectionFlags = (byte)(connectionFlags | (message.getWillQos() & 3) << 3);
            if (message.isWillRetain()) {
                connectionFlags = (byte)(connectionFlags | 0x20);
            }
            if (message.isPasswordFlag()) {
                connectionFlags = (byte)(connectionFlags | 0x40);
            }
            if (message.isUserFlag()) {
                connectionFlags = (byte)(connectionFlags | 0x80);
            }
            staticHeaderBuff.writeByte(connectionFlags);
            staticHeaderBuff.writeShort(message.getKeepAlive());
            if (message.getClientID() != null) {
                variableHeaderBuff.writeBytes(Utils.encodeString(message.getClientID()));
                if (message.isWillFlag()) {
                    variableHeaderBuff.writeBytes(Utils.encodeString(message.getWillTopic()));
                    variableHeaderBuff.writeBytes(Utils.encodeFixedLengthContent(message.getWillMessage()));
                }
                if (message.isUserFlag() && message.getUsername() != null) {
                    variableHeaderBuff.writeBytes(Utils.encodeString(message.getUsername()));
                    if (message.isPasswordFlag() && message.getPassword() != null) {
                        variableHeaderBuff.writeBytes(Utils.encodeFixedLengthContent(message.getPassword()));
                    }
                }
            }
            int variableHeaderSize = variableHeaderBuff.readableBytes();
            buff.writeByte(16);
            buff.writeBytes(Utils.encodeRemainingLength(12 + variableHeaderSize));
            buff.writeBytes(staticHeaderBuff).writeBytes(variableHeaderBuff);
            out.writeBytes(buff);
        }
        finally {
            staticHeaderBuff.release();
            buff.release();
            variableHeaderBuff.release();
        }
    }
}

