/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.parser.netty;

import io.moquette.parser.netty.DemuxDecoder;
import io.moquette.parser.netty.MQTTDecoder;
import io.moquette.parser.netty.Utils;
import io.moquette.parser.proto.messages.AbstractMessage;
import io.moquette.parser.proto.messages.ConnectMessage;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.AttributeMap;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class ConnectDecoder
extends DemuxDecoder {
    static final AttributeKey<Boolean> CONNECT_STATUS = AttributeKey.valueOf("connected");

    @Override
    void decode(AttributeMap ctx, ByteBuf in, List<Object> out) throws UnsupportedEncodingException {
        int readed;
        boolean userFlag;
        in.resetReaderIndex();
        ConnectMessage message = new ConnectMessage();
        if (!this.decodeCommonHeader(message, 0, in)) {
            in.resetReaderIndex();
            return;
        }
        int remainingLength = message.getRemainingLength();
        int start = in.readerIndex();
        int protocolNameLen = in.readUnsignedShort();
        Attribute<Integer> versionAttr = ctx.attr(MQTTDecoder.PROTOCOL_VERSION);
        switch (protocolNameLen) {
            case 6: {
                if (in.readableBytes() < 10) {
                    in.resetReaderIndex();
                    return;
                }
                byte[] encProtoName = new byte[6];
                in.readBytes(encProtoName);
                String protoName = new String(encProtoName, "UTF-8");
                if (!"MQIsdp".equals(protoName)) {
                    in.resetReaderIndex();
                    throw new CorruptedFrameException("Invalid protoName: " + protoName);
                }
                message.setProtocolName(protoName);
                versionAttr.set(3);
                break;
            }
            case 4: {
                if (in.readableBytes() < 8) {
                    in.resetReaderIndex();
                    return;
                }
                byte[] encProtoName = new byte[4];
                in.readBytes(encProtoName);
                String protoName = new String(encProtoName, "UTF-8");
                if (!"MQTT".equals(protoName)) {
                    in.resetReaderIndex();
                    throw new CorruptedFrameException("Invalid protoName: " + protoName);
                }
                message.setProtocolName(protoName);
                versionAttr.set(4);
                break;
            }
            default: {
                throw new CorruptedFrameException("Invalid protoName size: " + protocolNameLen);
            }
        }
        message.setProtocolVersion(in.readByte());
        if (message.getProtocolVersion() == 4) {
            if (message.isDupFlag() || message.isRetainFlag() || message.getQos() != AbstractMessage.QOSType.MOST_ONE) {
                throw new CorruptedFrameException("Received a CONNECT with fixed header flags != 0");
            }
            Attribute<Boolean> connectAttr = ctx.attr(CONNECT_STATUS);
            Boolean alreadyConnected = connectAttr.get();
            if (alreadyConnected == null) {
                connectAttr.set(true);
            } else if (alreadyConnected.booleanValue()) {
                throw new CorruptedFrameException("Received a second CONNECT on the same network connection");
            }
        }
        byte connFlags = in.readByte();
        if (message.getProtocolVersion() == 4 && (connFlags & 1) != 0) {
            throw new CorruptedFrameException("Received a CONNECT with connectionFlags[0(bit)] != 0");
        }
        boolean cleanSession = (connFlags & 2) >> 1 == 1;
        boolean willFlag = (connFlags & 4) >> 2 == 1;
        byte willQos = (byte)((connFlags & 0x18) >> 3);
        if (willQos > 2) {
            in.resetReaderIndex();
            throw new CorruptedFrameException("Expected will QoS in range 0..2 but found: " + willQos);
        }
        boolean willRetain = (connFlags & 0x20) >> 5 == 1;
        boolean passwordFlag = (connFlags & 0x40) >> 6 == 1;
        boolean bl = userFlag = (connFlags & 0x80) >> 7 == 1;
        if (!userFlag && passwordFlag) {
            in.resetReaderIndex();
            throw new CorruptedFrameException("Expected password flag to true if the user flag is true but was: " + passwordFlag);
        }
        message.setCleanSession(cleanSession);
        message.setWillFlag(willFlag);
        message.setWillQos(willQos);
        message.setWillRetain(willRetain);
        message.setPasswordFlag(passwordFlag);
        message.setUserFlag(userFlag);
        int keepAlive = in.readUnsignedShort();
        message.setKeepAlive(keepAlive);
        if (remainingLength == 12 && message.getProtocolVersion() == 3 || remainingLength == 10 && message.getProtocolVersion() == 4) {
            out.add(message);
            return;
        }
        String clientID = Utils.decodeString(in);
        if (clientID == null) {
            in.resetReaderIndex();
            return;
        }
        message.setClientID(clientID);
        if (willFlag) {
            String willTopic = Utils.decodeString(in);
            if (willTopic == null) {
                in.resetReaderIndex();
                return;
            }
            message.setWillTopic(willTopic);
        }
        if (willFlag) {
            byte[] willMessage = Utils.readFixedLengthContent(in);
            if (willMessage == null) {
                in.resetReaderIndex();
                return;
            }
            message.setWillMessage(willMessage);
        }
        if ((readed = in.readerIndex() - start) == remainingLength) {
            out.add(message);
            return;
        }
        if (userFlag) {
            String userName = Utils.decodeString(in);
            if (userName == null) {
                in.resetReaderIndex();
                return;
            }
            message.setUsername(userName);
        }
        if ((readed = in.readerIndex() - start) == remainingLength) {
            out.add(message);
            return;
        }
        if (passwordFlag) {
            byte[] password = Utils.readFixedLengthContent(in);
            if (password == null) {
                in.resetReaderIndex();
                return;
            }
            message.setPassword(password);
        }
        out.add(message);
    }
}

