/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.parser.netty;

import io.moquette.parser.netty.Utils;
import io.moquette.parser.proto.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.util.AttributeMap;
import java.util.List;

abstract class DemuxDecoder {
    DemuxDecoder() {
    }

    abstract void decode(AttributeMap var1, ByteBuf var2, List<Object> var3) throws Exception;

    protected boolean decodeCommonHeader(AbstractMessage message, ByteBuf in) {
        return this.genericDecodeCommonHeader(message, null, in);
    }

    protected boolean decodeCommonHeader(AbstractMessage message, int expectedFlags, ByteBuf in) {
        return this.genericDecodeCommonHeader(message, expectedFlags, in);
    }

    private boolean genericDecodeCommonHeader(AbstractMessage message, Integer expectedFlagsOpt, ByteBuf in) {
        int expectedFlags;
        if (in.readableBytes() < 2) {
            return false;
        }
        byte h1 = in.readByte();
        byte messageType = (byte)((h1 & 0xF0) >> 4);
        byte flags = (byte)(h1 & 0xF);
        if (expectedFlagsOpt != null && (byte)(expectedFlags = expectedFlagsOpt.intValue()) != flags) {
            String hexExpected = Integer.toHexString(expectedFlags);
            String hexReceived = Integer.toHexString(flags);
            throw new CorruptedFrameException(String.format("Received a message with fixed header flags (%s) != expected (%s)", hexReceived, hexExpected));
        }
        boolean dupFlag = (byte)((h1 & 8) >> 3) == 1;
        byte qosLevel = (byte)((h1 & 6) >> 1);
        boolean retainFlag = (byte)(h1 & 1) == 1;
        int remainingLength = Utils.decodeRemainingLenght(in);
        if (remainingLength == -1) {
            return false;
        }
        message.setMessageType(messageType);
        message.setDupFlag(dupFlag);
        try {
            message.setQos(AbstractMessage.QOSType.valueOf(qosLevel));
        }
        catch (IllegalArgumentException e) {
            throw new CorruptedFrameException(String.format("Received an invalid QOS: %s", e.getMessage()), e);
        }
        message.setRetainFlag(retainFlag);
        message.setRemainingLength(remainingLength);
        return true;
    }
}

