/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.parser.netty;

import io.moquette.parser.netty.DemuxDecoder;
import io.moquette.parser.netty.Utils;
import io.moquette.parser.proto.messages.AbstractMessage;
import io.moquette.parser.proto.messages.UnsubscribeMessage;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.util.AttributeMap;
import java.util.List;

class UnsubscribeDecoder
extends DemuxDecoder {
    UnsubscribeDecoder() {
    }

    @Override
    void decode(AttributeMap ctx, ByteBuf in, List<Object> out) throws Exception {
        in.resetReaderIndex();
        UnsubscribeMessage message = new UnsubscribeMessage();
        if (!this.decodeCommonHeader(message, 2, in)) {
            in.resetReaderIndex();
            return;
        }
        if (message.getQos() != AbstractMessage.QOSType.LEAST_ONE) {
            throw new CorruptedFrameException("Found an Unsubscribe message with qos other than LEAST_ONE, was: " + (Object)((Object)message.getQos()));
        }
        int start = in.readerIndex();
        message.setMessageID(in.readUnsignedShort());
        int read = in.readerIndex() - start;
        while (read < message.getRemainingLength()) {
            String topicFilter = Utils.decodeString(in);
            if (topicFilter.length() == 0) {
                throw new CorruptedFrameException("Received an UNSUBSCRIBE with empty topic filter");
            }
            message.addTopicFilter(topicFilter);
            read = in.readerIndex() - start;
        }
        if (message.topicFilters().isEmpty()) {
            throw new CorruptedFrameException("unsubscribe MUST have got at least 1 topic");
        }
        out.add(message);
    }
}

