/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.parser.netty;

import io.moquette.parser.netty.DemuxEncoder;
import io.moquette.parser.netty.Utils;
import io.moquette.parser.proto.messages.AbstractMessage;
import io.moquette.parser.proto.messages.UnsubscribeMessage;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.ReferenceCounted;

class UnsubscribeEncoder
extends DemuxEncoder<UnsubscribeMessage> {
    UnsubscribeEncoder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encode(ChannelHandlerContext chc, UnsubscribeMessage message, ByteBuf out) {
        if (message.topicFilters().isEmpty()) {
            throw new IllegalArgumentException("Found an unsubscribe message with empty topics");
        }
        if (message.getQos() != AbstractMessage.QOSType.LEAST_ONE) {
            throw new IllegalArgumentException("Expected a message with QOS 1, found " + (Object)((Object)message.getQos()));
        }
        ByteBuf variableHeaderBuff = chc.alloc().buffer(4);
        ReferenceCounted buff = null;
        try {
            variableHeaderBuff.writeShort(message.getMessageID());
            for (String topic : message.topicFilters()) {
                variableHeaderBuff.writeBytes(Utils.encodeString(topic));
            }
            int variableHeaderSize = variableHeaderBuff.readableBytes();
            byte flags = Utils.encodeFlags(message);
            buff = chc.alloc().buffer(2 + variableHeaderSize);
            ((ByteBuf)buff).writeByte(0xA0 | flags);
            ((ByteBuf)buff).writeBytes(Utils.encodeRemainingLength(variableHeaderSize));
            ((ByteBuf)buff).writeBytes(variableHeaderBuff);
            out.writeBytes((ByteBuf)buff);
        }
        finally {
            variableHeaderBuff.release();
            buff.release();
        }
    }
}

