/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.server.netty.metrics;

import io.moquette.parser.proto.messages.AbstractMessage;
import io.moquette.parser.proto.messages.ConnectMessage;
import io.moquette.parser.proto.messages.PubAckMessage;
import io.moquette.parser.proto.messages.PubCompMessage;
import io.moquette.parser.proto.messages.PubRecMessage;
import io.moquette.parser.proto.messages.PubRelMessage;
import io.moquette.parser.proto.messages.PublishMessage;
import io.moquette.parser.proto.messages.SubscribeMessage;
import io.moquette.parser.proto.messages.UnsubscribeMessage;
import io.moquette.server.netty.NettyUtils;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class MQTTMessageLogger
extends ChannelDuplexHandler {
    private static final Logger LOG = LoggerFactory.getLogger((String)"messageLogger");

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object message) {
        this.logMQTTMessage(ctx, message, "C->B");
        ctx.fireChannelRead(message);
    }

    private void logMQTTMessage(ChannelHandlerContext ctx, Object message, String direction) {
        if (!(message instanceof AbstractMessage)) {
            return;
        }
        AbstractMessage msg = (AbstractMessage)message;
        String clientID = NettyUtils.clientID(ctx.channel());
        switch (msg.getMessageType()) {
            case 1: {
                ConnectMessage connect = (ConnectMessage)msg;
                LOG.info("{} CONNECT client <{}>", (Object)direction, (Object)connect.getClientID());
                break;
            }
            case 8: {
                SubscribeMessage subscribe = (SubscribeMessage)msg;
                LOG.info("{} SUBSCRIBE <{}> to topics {}", new Object[]{direction, clientID, subscribe.subscriptions()});
                break;
            }
            case 10: {
                UnsubscribeMessage unsubscribe = (UnsubscribeMessage)msg;
                LOG.info("{} UNSUBSCRIBE <{}> to topics <{}>", new Object[]{direction, clientID, unsubscribe.topicFilters()});
                break;
            }
            case 3: {
                PublishMessage publish = (PublishMessage)msg;
                LOG.info("{} PUBLISH <{}> to topics <{}>", new Object[]{direction, clientID, publish.getTopicName()});
                break;
            }
            case 5: {
                PubRecMessage pubrec = (PubRecMessage)msg;
                LOG.info("{} PUBREC <{}> packetID <{}>", new Object[]{direction, clientID, pubrec.getMessageID()});
                break;
            }
            case 7: {
                PubCompMessage pubCompleted = (PubCompMessage)msg;
                LOG.info("{} PUBCOMP <{}> packetID <{}>", new Object[]{direction, clientID, pubCompleted.getMessageID()});
                break;
            }
            case 6: {
                PubRelMessage pubRelease = (PubRelMessage)msg;
                LOG.info("{} PUBREL <{}> packetID <{}>", new Object[]{direction, clientID, pubRelease.getMessageID()});
                break;
            }
            case 14: {
                LOG.info("{} DISCONNECT <{}>", (Object)direction, (Object)clientID);
                break;
            }
            case 4: {
                PubAckMessage pubAck = (PubAckMessage)msg;
                LOG.info("{} PUBACK <{}> packetID <{}>", new Object[]{direction, clientID, pubAck.getMessageID()});
            }
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        String clientID = NettyUtils.clientID(ctx.channel());
        if (clientID != null && !clientID.isEmpty()) {
            LOG.info("Channel closed <{}>", (Object)clientID);
        }
        ctx.fireChannelInactive();
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        this.logMQTTMessage(ctx, msg, "C<-B");
        ctx.write(msg, promise);
    }
}

