/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.spi.impl;

import io.moquette.parser.proto.messages.AbstractMessage;
import io.moquette.parser.proto.messages.PublishMessage;
import io.moquette.spi.ClientSession;
import io.moquette.spi.IMessagesStore;
import io.moquette.spi.impl.PersistentQueueMessageSender;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InternalRepublisher {
    private static final Logger LOG = LoggerFactory.getLogger(InternalRepublisher.class);
    private final PersistentQueueMessageSender messageSender;

    InternalRepublisher(PersistentQueueMessageSender messageSender) {
        this.messageSender = messageSender;
    }

    void publishRetained(ClientSession targetSession, Collection<IMessagesStore.StoredMessage> messages) {
        for (IMessagesStore.StoredMessage storedMsg : messages) {
            PublishMessage publishMsg;
            Integer packetID;
            Integer n = packetID = storedMsg.getQos() == AbstractMessage.QOSType.MOST_ONE ? null : Integer.valueOf(targetSession.nextPacketId());
            if (packetID != null) {
                LOG.trace("Adding to inflight <{}>", (Object)packetID);
                targetSession.inFlightAckWaiting(storedMsg.getGuid(), packetID);
            }
            if ((publishMsg = this.retainedPublish(storedMsg)).getQos() != AbstractMessage.QOSType.MOST_ONE) {
                publishMsg.setMessageID(packetID);
            }
            this.messageSender.sendPublish(targetSession, publishMsg);
        }
    }

    void publishStored(ClientSession clientSession, BlockingQueue<IMessagesStore.StoredMessage> publishedEvents) {
        ArrayList storedPublishes = new ArrayList();
        publishedEvents.drainTo(storedPublishes);
        for (IMessagesStore.StoredMessage pubEvt : storedPublishes) {
            LOG.trace("Adding to inflight <{}>", (Object)pubEvt.getMessageID());
            clientSession.inFlightAckWaiting(pubEvt.getGuid(), pubEvt.getMessageID());
            PublishMessage publishMsg = this.notRetainedPublish(pubEvt);
            if (publishMsg.getQos() != AbstractMessage.QOSType.MOST_ONE) {
                publishMsg.setMessageID(pubEvt.getMessageID());
            }
            this.messageSender.sendPublish(clientSession, publishMsg);
        }
    }

    private PublishMessage notRetainedPublish(IMessagesStore.StoredMessage storedMessage) {
        return InternalRepublisher.createPublishForQos(storedMessage.getTopic(), storedMessage.getQos(), storedMessage.getMessage(), false);
    }

    private PublishMessage retainedPublish(IMessagesStore.StoredMessage storedMessage) {
        return InternalRepublisher.createPublishForQos(storedMessage.getTopic(), storedMessage.getQos(), storedMessage.getMessage(), true);
    }

    public static PublishMessage createPublishForQos(String topic, AbstractMessage.QOSType qos, ByteBuffer message, boolean retained) {
        PublishMessage pubMessage = new PublishMessage();
        pubMessage.setRetainFlag(retained);
        pubMessage.setTopicName(topic);
        pubMessage.setQos(qos);
        pubMessage.setPayload(message);
        return pubMessage;
    }
}

