/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.spi.impl;

import io.moquette.interception.InterceptHandler;
import io.moquette.interception.Interceptor;
import io.moquette.interception.messages.InterceptAcknowledgedMessage;
import io.moquette.interception.messages.InterceptConnectMessage;
import io.moquette.interception.messages.InterceptConnectionLostMessage;
import io.moquette.interception.messages.InterceptDisconnectMessage;
import io.moquette.interception.messages.InterceptPublishMessage;
import io.moquette.interception.messages.InterceptSubscribeMessage;
import io.moquette.interception.messages.InterceptUnsubscribeMessage;
import io.moquette.parser.proto.messages.ConnectMessage;
import io.moquette.parser.proto.messages.PublishMessage;
import io.moquette.spi.impl.subscriptions.Subscription;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

final class BrokerInterceptor
implements Interceptor {
    private final List<InterceptHandler> handlers;
    private final ExecutorService executor;

    BrokerInterceptor(List<InterceptHandler> handlers) {
        this.handlers = new CopyOnWriteArrayList<InterceptHandler>(handlers);
        this.executor = Executors.newFixedThreadPool(1);
    }

    void stop() {
        this.executor.shutdown();
    }

    @Override
    public void notifyClientConnected(final ConnectMessage msg) {
        for (final InterceptHandler handler : this.handlers) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    handler.onConnect(new InterceptConnectMessage(msg));
                }
            });
        }
    }

    @Override
    public void notifyClientDisconnected(final String clientID, final String username) {
        for (final InterceptHandler handler : this.handlers) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    handler.onDisconnect(new InterceptDisconnectMessage(clientID, username));
                }
            });
        }
    }

    @Override
    public void notifyClientConnectionLost(final String clientID, final String username) {
        for (final InterceptHandler handler : this.handlers) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    handler.onConnectionLost(new InterceptConnectionLostMessage(clientID, username));
                }
            });
        }
    }

    @Override
    public void notifyTopicPublished(final PublishMessage msg, final String clientID, final String username) {
        for (final InterceptHandler handler : this.handlers) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    handler.onPublish(new InterceptPublishMessage(msg, clientID, username));
                }
            });
        }
    }

    @Override
    public void notifyTopicSubscribed(final Subscription sub, final String username) {
        for (final InterceptHandler handler : this.handlers) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    handler.onSubscribe(new InterceptSubscribeMessage(sub, username));
                }
            });
        }
    }

    @Override
    public void notifyTopicUnsubscribed(final String topic, final String clientID, final String username) {
        for (final InterceptHandler handler : this.handlers) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    handler.onUnsubscribe(new InterceptUnsubscribeMessage(topic, clientID, username));
                }
            });
        }
    }

    @Override
    public void notifyMessageAcknowledged(final InterceptAcknowledgedMessage msg) {
        for (final InterceptHandler handler : this.handlers) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    handler.onMessageAcknowledged(msg);
                }
            });
        }
    }

    @Override
    public boolean addInterceptHandler(InterceptHandler interceptHandler) {
        return this.handlers.add(interceptHandler);
    }

    @Override
    public boolean removeInterceptHandler(InterceptHandler interceptHandler) {
        return this.handlers.remove(interceptHandler);
    }
}

