/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.spi.impl;

import io.moquette.parser.proto.messages.PubAckMessage;
import io.moquette.parser.proto.messages.PublishMessage;
import io.moquette.server.ConnectionDescriptor;
import io.moquette.server.netty.NettyUtils;
import io.moquette.spi.IMessagesStore;
import io.moquette.spi.MessageGUID;
import io.moquette.spi.impl.BrokerInterceptor;
import io.moquette.spi.impl.DebugUtils;
import io.moquette.spi.impl.MessagesPublisher;
import io.moquette.spi.impl.ProtocolProcessor;
import io.moquette.spi.impl.subscriptions.Subscription;
import io.moquette.spi.impl.subscriptions.SubscriptionsStore;
import io.moquette.spi.security.IAuthorizator;
import io.netty.channel.Channel;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Qos1PublishHandler {
    private static final Logger LOG = LoggerFactory.getLogger(Qos1PublishHandler.class);
    private final IAuthorizator m_authorizator;
    private final SubscriptionsStore subscriptions;
    private final IMessagesStore m_messagesStore;
    private final BrokerInterceptor m_interceptor;
    private final ConcurrentMap<String, ConnectionDescriptor> connectionDescriptors;
    private final String brokerPort;
    private final MessagesPublisher publisher;

    public Qos1PublishHandler(IAuthorizator authorizator, SubscriptionsStore subscriptions, IMessagesStore messagesStore, BrokerInterceptor interceptor, ConcurrentMap<String, ConnectionDescriptor> connectionDescriptors, String brokerPort, MessagesPublisher messagesPublisher) {
        this.m_authorizator = authorizator;
        this.subscriptions = subscriptions;
        this.m_messagesStore = messagesStore;
        this.m_interceptor = interceptor;
        this.connectionDescriptors = connectionDescriptors;
        this.brokerPort = brokerPort;
        this.publisher = messagesPublisher;
    }

    void receivedPublishQos1(Channel channel, PublishMessage msg) {
        String topic = msg.getTopicName();
        if (this.checkWriteOnTopic(topic, channel)) {
            return;
        }
        IMessagesStore.StoredMessage toStoreMsg = ProtocolProcessor.asStoredMessage(msg);
        String clientID = NettyUtils.clientID(channel);
        toStoreMsg.setClientID(clientID);
        LOG.debug("publish2Subscribers_qos1 republishing to existing subscribers that matches the topic {}", (Object)topic);
        if (LOG.isTraceEnabled()) {
            LOG.trace("content <{}>", (Object)DebugUtils.payload2Str(toStoreMsg.getMessage()));
            LOG.trace("subscription tree {}", (Object)this.subscriptions.dumpTree());
        }
        List<Subscription> topicMatchingSubscriptions = this.subscriptions.matches(topic);
        this.publisher.publish2Subscribers(toStoreMsg, topicMatchingSubscriptions);
        Integer messageID = msg.getMessageID();
        if (msg.isLocal()) {
            this.sendPubAck(clientID, messageID);
        }
        LOG.info("server {} replying with PubAck to MSG ID {}", (Object)this.brokerPort, (Object)messageID);
        if (msg.isRetainFlag()) {
            if (!msg.getPayload().hasRemaining()) {
                this.m_messagesStore.cleanRetained(topic);
            } else {
                MessageGUID guid = this.m_messagesStore.storePublishForFuture(toStoreMsg);
                this.m_messagesStore.storeRetained(topic, guid);
            }
        }
        String username = NettyUtils.userName(channel);
        this.m_interceptor.notifyTopicPublished(msg, clientID, username);
    }

    boolean checkWriteOnTopic(String topic, Channel channel) {
        String clientID = NettyUtils.clientID(channel);
        String username = NettyUtils.userName(channel);
        if (!this.m_authorizator.canWrite(topic, username, clientID)) {
            LOG.debug("topic {} doesn't have write credentials", (Object)topic);
            return true;
        }
        return false;
    }

    private void sendPubAck(String clientId, int messageID) {
        LOG.trace("sendPubAck invoked");
        PubAckMessage pubAckMessage = new PubAckMessage();
        pubAckMessage.setMessageID(messageID);
        try {
            if (this.connectionDescriptors == null) {
                throw new RuntimeException("Internal bad error, found connectionDescriptors to null while it should be initialized, somewhere it's overwritten!!");
            }
            LOG.debug("clientIDs are {}", this.connectionDescriptors);
            if (this.connectionDescriptors.get(clientId) == null) {
                throw new RuntimeException(String.format("Can't find a ConnectionDescriptor for client %s in cache %s", clientId, this.connectionDescriptors));
            }
            ((ConnectionDescriptor)this.connectionDescriptors.get((Object)clientId)).channel.writeAndFlush(pubAckMessage);
        }
        catch (Throwable t) {
            LOG.error(null, t);
        }
    }
}

