/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.geojson;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.eclipse.sensinact.gateway.geojson.Feature;
import org.eclipse.sensinact.gateway.geojson.FeatureCollection;
import org.eclipse.sensinact.gateway.geojson.GeoJsonObject;
import org.eclipse.sensinact.gateway.geojson.GeoJsonType;
import org.eclipse.sensinact.gateway.geojson.Geometry;
import org.eclipse.sensinact.gateway.geojson.GeometryCollection;
import org.eclipse.sensinact.gateway.geojson.Polygon;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class GeoJsonTest {
    private ObjectMapper mapper;

    @BeforeEach
    void setUp() throws Exception {
        this.mapper = new ObjectMapper();
    }

    private URL getFileResource(String name) {
        return this.getClass().getResource("/" + name);
    }

    @Test
    void testGeometries() throws Exception {
        List geometries = (List)this.mapper.readValue(this.getFileResource("test-geometries.json"), (TypeReference)new TypeReference<List<Geometry>>(){});
        Assertions.assertEquals((int)9, (int)geometries.size());
        Assertions.assertEquals((Object)GeoJsonType.Point, (Object)((Geometry)geometries.get((int)0)).type);
        Assertions.assertEquals((Object)GeoJsonType.LineString, (Object)((Geometry)geometries.get((int)1)).type);
        Assertions.assertEquals((Object)GeoJsonType.Polygon, (Object)((Geometry)geometries.get((int)2)).type);
        Assertions.assertEquals((Object)GeoJsonType.Polygon, (Object)((Geometry)geometries.get((int)3)).type);
        Assertions.assertEquals((Object)GeoJsonType.MultiPoint, (Object)((Geometry)geometries.get((int)4)).type);
        Assertions.assertEquals((Object)GeoJsonType.MultiLineString, (Object)((Geometry)geometries.get((int)5)).type);
        Assertions.assertEquals((Object)GeoJsonType.MultiPolygon, (Object)((Geometry)geometries.get((int)6)).type);
        Assertions.assertEquals((Object)GeoJsonType.GeometryCollection, (Object)((Geometry)geometries.get((int)7)).type);
        Assertions.assertEquals((Object)GeoJsonType.MultiPolygon, (Object)((Geometry)geometries.get((int)8)).type);
        Polygon p = (Polygon)geometries.get(2);
        Assertions.assertEquals((int)1, (int)p.coordinates.size());
        Assertions.assertEquals((int)5, (int)((List)p.coordinates.get(0)).size());
        p = (Polygon)geometries.get(3);
        Assertions.assertEquals((int)2, (int)p.coordinates.size());
        Assertions.assertEquals((int)5, (int)((List)p.coordinates.get(0)).size());
        Assertions.assertEquals((int)5, (int)((List)p.coordinates.get(1)).size());
        GeometryCollection gc = (GeometryCollection)geometries.get(7);
        Assertions.assertEquals((int)2, (int)gc.geometries.size());
        Assertions.assertEquals((Object)GeoJsonType.Point, (Object)((Geometry)gc.geometries.get((int)0)).type);
        Assertions.assertEquals((Object)GeoJsonType.LineString, (Object)((Geometry)gc.geometries.get((int)1)).type);
    }

    @Test
    void testBoundingBox() throws Exception {
        List geoObjects = (List)this.mapper.readValue(this.getFileResource("test-bbox.json"), (TypeReference)new TypeReference<List<GeoJsonObject>>(){});
        Assertions.assertEquals((int)4, (int)geoObjects.size());
        Assertions.assertEquals((Object)GeoJsonType.FeatureCollection, (Object)((GeoJsonObject)geoObjects.get((int)0)).type);
        Assertions.assertEquals((Object)GeoJsonType.FeatureCollection, (Object)((GeoJsonObject)geoObjects.get((int)1)).type);
        Assertions.assertEquals((Object)GeoJsonType.Feature, (Object)((GeoJsonObject)geoObjects.get((int)2)).type);
        Assertions.assertEquals((Object)GeoJsonType.Polygon, (Object)((GeoJsonObject)geoObjects.get((int)3)).type);
        for (GeoJsonObject go : geoObjects) {
            Assertions.assertNotNull((Object)go.bbox);
            Assertions.assertFalse((boolean)go.bbox.isEmpty());
        }
    }

    @Test
    void testFeatures() throws Exception {
        List geoObjects = (List)this.mapper.readValue(this.getFileResource("test-features.json"), (TypeReference)new TypeReference<List<GeoJsonObject>>(){});
        Assertions.assertEquals((int)1, (int)geoObjects.size());
        Assertions.assertEquals((Object)GeoJsonType.FeatureCollection, (Object)((GeoJsonObject)geoObjects.get((int)0)).type);
        FeatureCollection fc = (FeatureCollection)geoObjects.get(0);
        Assertions.assertEquals((int)3, (int)fc.features.size());
        Feature f = (Feature)fc.features.get(0);
        Assertions.assertEquals((Object)"value0", f.properties.get("prop0"));
        Assertions.assertEquals((Object)GeoJsonType.Point, (Object)f.geometry.type);
        f = (Feature)fc.features.get(1);
        Assertions.assertEquals((Object)"value0", f.properties.get("prop0"));
        Assertions.assertEquals((Object)0.0, f.properties.get("prop1"));
        Assertions.assertEquals((Object)GeoJsonType.LineString, (Object)f.geometry.type);
        f = (Feature)fc.features.get(2);
        Assertions.assertEquals((Object)"value0", f.properties.get("prop0"));
        Assertions.assertEquals(Map.of("this", "that"), f.properties.get("prop1"));
        Assertions.assertEquals((Object)GeoJsonType.Polygon, (Object)f.geometry.type);
    }

    @Test
    void testForeignMembers() throws Exception {
        List geoObjects = (List)this.mapper.readValue(this.getFileResource("test-foreignMembers.json"), (TypeReference)new TypeReference<List<GeoJsonObject>>(){});
        Assertions.assertEquals((int)3, (int)geoObjects.size());
        Assertions.assertEquals((Object)GeoJsonType.Point, (Object)((GeoJsonObject)geoObjects.get((int)0)).type);
        Assertions.assertEquals((Object)GeoJsonType.Feature, (Object)((GeoJsonObject)geoObjects.get((int)1)).type);
        Assertions.assertEquals((Object)GeoJsonType.FeatureCollection, (Object)((GeoJsonObject)geoObjects.get((int)2)).type);
        Assertions.assertEquals((Object)"foo", ((GeoJsonObject)geoObjects.get((int)0)).foreignMembers.get("extra"));
        Assertions.assertEquals((Object)"LineString", ((Map)((GeoJsonObject)geoObjects.get((int)1)).foreignMembers.get("centerline")).get("type"));
        Assertions.assertEquals(Map.of("bar", "baz"), ((GeoJsonObject)geoObjects.get((int)2)).foreignMembers.get("extra"));
    }
}

