/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.extract.impl;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import org.eclipse.sensinact.core.annotation.dto.Data;
import org.eclipse.sensinact.core.annotation.dto.DuplicateAction;
import org.eclipse.sensinact.core.annotation.dto.NullAction;
import org.eclipse.sensinact.core.annotation.dto.Provider;
import org.eclipse.sensinact.core.annotation.dto.Resource;
import org.eclipse.sensinact.core.annotation.dto.Service;
import org.eclipse.sensinact.core.annotation.dto.Timestamp;
import org.eclipse.sensinact.core.dto.impl.AbstractUpdateDto;
import org.eclipse.sensinact.core.dto.impl.DataUpdateDto;
import org.eclipse.sensinact.core.dto.impl.MetadataUpdateDto;
import org.eclipse.sensinact.core.extract.impl.CustomDtoDataExtractor;
import org.eclipse.sensinact.core.extract.impl.DataExtractor;
import org.eclipse.sensinact.core.push.dto.BaseValueDto;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

public class CustomBaseValueDtoExtractorTest {
    private static final String PROVIDER = "provider";
    private static final String PROVIDER_2 = "provider2";
    private static final String SERVICE = "service";
    private static final String SERVICE_2 = "service2";
    private static final String RESOURCE = "resource";
    private static final String RESOURCE_2 = "resource2";
    private static final Integer VALUE = 5;
    private static final String VALUE_2 = "Fourteen";
    private static final String METADATA_KEY = "foo";
    private static final String METADATA_VALUE = "fizz";

    DataExtractor extractor(Class<?> clazz) {
        return new CustomDtoDataExtractor(clazz);
    }

    void populate(BaseValueDto bvd) {
        bvd.provider = PROVIDER;
        bvd.service = SERVICE;
        bvd.resource = RESOURCE;
        bvd.metadata = Collections.singletonMap(METADATA_KEY, METADATA_VALUE);
    }

    private void checkCommonFields(AbstractUpdateDto extracted) {
        this.checkCommonFields(extracted, true);
    }

    private void checkCommonFields(AbstractUpdateDto extracted, Instant time) {
        this.checkCommonFields(extracted, true, time);
    }

    private void checkCommonFields(AbstractUpdateDto extracted, String altResource, Instant time) {
        this.checkCommonFields(extracted, true, altResource, time);
    }

    private void checkCommonFields(AbstractUpdateDto extracted, boolean use1) {
        this.checkCommonFields(extracted, use1, null);
    }

    private void checkCommonFields(AbstractUpdateDto extracted, boolean use1, Instant time) {
        this.checkCommonFields(extracted, use1, null, time);
    }

    private void checkCommonFields(AbstractUpdateDto extracted, boolean use1, String altResource, Instant time) {
        Assertions.assertEquals((Object)(use1 ? PROVIDER : PROVIDER_2), (Object)extracted.provider);
        Assertions.assertEquals((Object)(use1 ? SERVICE : SERVICE_2), (Object)extracted.service);
        Assertions.assertEquals((Object)(altResource == null ? (use1 ? RESOURCE : RESOURCE_2) : altResource), (Object)extracted.resource);
        if (time == null) {
            Assertions.assertTrue((boolean)Duration.between(extracted.timestamp, Instant.now()).minusMillis(100L).isNegative(), () -> "The timestamp was not set properly got: " + extracted.timestamp + " now is: " + Instant.now());
        } else {
            Assertions.assertEquals((Object)time, (Object)extracted.timestamp);
        }
    }

    @Nested
    class CustomDataFields {
        CustomDataFields() {
        }

        @Test
        void extendedDtoMapping() {
            Instant time = Instant.now().minus(1L, ChronoUnit.DAYS).truncatedTo(ChronoUnit.SECONDS);
            ExtendedDto dto = new ExtendedDto();
            CustomBaseValueDtoExtractorTest.this.populate(dto);
            dto.foo = CustomBaseValueDtoExtractorTest.VALUE_2;
            dto.bar = VALUE;
            dto.time = time.getEpochSecond();
            List updates = CustomBaseValueDtoExtractorTest.this.extractor(ExtendedDto.class).getUpdates((Object)dto);
            Assertions.assertEquals((int)5, (int)updates.size());
            AbstractUpdateDto extracted = updates.stream().filter(DataUpdateDto.class::isInstance).filter(d -> CustomBaseValueDtoExtractorTest.RESOURCE.equals(d.resource)).findFirst().get();
            CustomBaseValueDtoExtractorTest.this.checkCommonFields(extracted, time);
            Assertions.assertTrue((boolean)(extracted instanceof DataUpdateDto), (String)("Not a data update dto " + extracted.getClass()));
            DataUpdateDto dud = (DataUpdateDto)extracted;
            Assertions.assertEquals((Object)CustomBaseValueDtoExtractorTest.VALUE_2, (Object)dud.data);
            Assertions.assertEquals(String.class, (Object)dud.type);
            Assertions.assertEquals((Object)DuplicateAction.UPDATE_ALWAYS, (Object)dud.actionOnDuplicate);
            extracted = updates.stream().filter(DataUpdateDto.class::isInstance).filter(d -> CustomBaseValueDtoExtractorTest.RESOURCE_2.equals(d.resource)).findFirst().get();
            CustomBaseValueDtoExtractorTest.this.checkCommonFields(extracted, false, time);
            Assertions.assertTrue((boolean)(extracted instanceof DataUpdateDto), (String)("Not a data update dto " + extracted.getClass()));
            dud = (DataUpdateDto)extracted;
            Assertions.assertEquals((Object)VALUE, (Object)dud.data);
            Assertions.assertEquals(Long.class, (Object)dud.type);
            Assertions.assertEquals((Object)DuplicateAction.UPDATE_ALWAYS, (Object)dud.actionOnDuplicate);
            extracted = updates.stream().filter(DataUpdateDto.class::isInstance).filter(d -> "null".equals(d.resource)).findFirst().get();
            CustomBaseValueDtoExtractorTest.this.checkCommonFields(extracted, "null", time);
            Assertions.assertEquals((Object)NullAction.UPDATE, (Object)extracted.actionOnNull);
            Assertions.assertEquals((Object)DuplicateAction.UPDATE_IF_DIFFERENT, (Object)extracted.actionOnDuplicate);
            Assertions.assertTrue((boolean)(extracted instanceof DataUpdateDto), (String)("Not a data update dto " + extracted.getClass()));
            extracted = updates.stream().filter(DataUpdateDto.class::isInstance).filter(d -> "null2".equals(d.resource)).findFirst().get();
            CustomBaseValueDtoExtractorTest.this.checkCommonFields(extracted, "null2", time);
            Assertions.assertEquals((Object)NullAction.UPDATE_IF_PRESENT, (Object)extracted.actionOnNull);
            Assertions.assertEquals((Object)DuplicateAction.UPDATE_ALWAYS, (Object)extracted.actionOnDuplicate);
            Assertions.assertTrue((boolean)(extracted instanceof DataUpdateDto), (String)("Not a data update dto " + extracted.getClass()));
            dud = (DataUpdateDto)extracted;
            Assertions.assertNull((Object)dud.data);
            Assertions.assertEquals(String.class, (Object)dud.type);
            Assertions.assertEquals((Object)DuplicateAction.UPDATE_ALWAYS, (Object)dud.actionOnDuplicate);
            extracted = updates.stream().filter(MetadataUpdateDto.class::isInstance).findFirst().get();
            CustomBaseValueDtoExtractorTest.this.checkCommonFields(extracted, time);
            Assertions.assertTrue((boolean)(extracted instanceof MetadataUpdateDto), (String)("Not a metadata update dto " + extracted.getClass()));
            MetadataUpdateDto dud2 = (MetadataUpdateDto)extracted;
            Assertions.assertEquals(Collections.singletonMap(CustomBaseValueDtoExtractorTest.METADATA_KEY, CustomBaseValueDtoExtractorTest.METADATA_VALUE), (Object)dud2.metadata);
            Assertions.assertTrue((boolean)dud2.removeNullValues, (String)"Null values should be removed");
            Assertions.assertFalse((boolean)dud2.removeMissingValues, (String)"Missing values should be kept");
            Assertions.assertEquals((Object)DuplicateAction.UPDATE_IF_DIFFERENT, (Object)dud2.actionOnDuplicate);
        }
    }

    @Nested
    class ClashingMappingsTest {
        ClashingMappingsTest() {
        }

        @Test
        void clashingDtoWithFoo() {
            ClashingDto dto = new ClashingDto();
            CustomBaseValueDtoExtractorTest.this.populate(dto);
            dto.foo = CustomBaseValueDtoExtractorTest.VALUE_2;
            List updates = CustomBaseValueDtoExtractorTest.this.extractor(ClashingDto.class).getUpdates((Object)dto);
            Assertions.assertEquals((int)2, (int)updates.size());
            AbstractUpdateDto extracted = updates.stream().filter(DataUpdateDto.class::isInstance).findFirst().get();
            CustomBaseValueDtoExtractorTest.this.checkCommonFields(extracted);
            Assertions.assertTrue((boolean)(extracted instanceof DataUpdateDto), (String)("Not a data update dto " + extracted.getClass()));
            DataUpdateDto dud = (DataUpdateDto)extracted;
            Assertions.assertEquals((Object)CustomBaseValueDtoExtractorTest.VALUE_2, (Object)dud.data);
            Assertions.assertEquals(String.class, (Object)dud.type);
            Assertions.assertEquals((Object)DuplicateAction.UPDATE_ALWAYS, (Object)dud.actionOnDuplicate);
            extracted = updates.stream().filter(MetadataUpdateDto.class::isInstance).findFirst().get();
            CustomBaseValueDtoExtractorTest.this.checkCommonFields(extracted);
            Assertions.assertTrue((boolean)(extracted instanceof MetadataUpdateDto), (String)("Not a metadata update dto " + extracted.getClass()));
            MetadataUpdateDto dud2 = (MetadataUpdateDto)extracted;
            Assertions.assertEquals(Collections.singletonMap(CustomBaseValueDtoExtractorTest.METADATA_KEY, CustomBaseValueDtoExtractorTest.METADATA_VALUE), (Object)dud2.metadata);
            Assertions.assertTrue((boolean)dud2.removeNullValues, (String)"Null values should be removed");
            Assertions.assertFalse((boolean)dud2.removeMissingValues, (String)"Missing values should be kept");
            Assertions.assertEquals((Object)DuplicateAction.UPDATE_IF_DIFFERENT, (Object)dud2.actionOnDuplicate);
        }

        @Test
        void clashingDtoWithBar() {
            ClashingDto dto = new ClashingDto();
            CustomBaseValueDtoExtractorTest.this.populate(dto);
            dto.bar = VALUE;
            List updates = CustomBaseValueDtoExtractorTest.this.extractor(ClashingDto.class).getUpdates((Object)dto);
            Assertions.assertEquals((int)2, (int)updates.size());
            AbstractUpdateDto extracted = updates.stream().filter(DataUpdateDto.class::isInstance).findFirst().get();
            CustomBaseValueDtoExtractorTest.this.checkCommonFields(extracted);
            Assertions.assertTrue((boolean)(extracted instanceof DataUpdateDto), (String)("Not a data update dto " + extracted.getClass()));
            DataUpdateDto dud = (DataUpdateDto)extracted;
            Assertions.assertEquals((Object)VALUE, (Object)dud.data);
            Assertions.assertEquals(Integer.class, (Object)dud.type);
            Assertions.assertEquals((Object)DuplicateAction.UPDATE_IF_DIFFERENT, (Object)dud.actionOnDuplicate);
            extracted = updates.stream().filter(MetadataUpdateDto.class::isInstance).findFirst().get();
            CustomBaseValueDtoExtractorTest.this.checkCommonFields(extracted);
            Assertions.assertTrue((boolean)(extracted instanceof MetadataUpdateDto), (String)("Not a metadata update dto " + extracted.getClass()));
            MetadataUpdateDto dud2 = (MetadataUpdateDto)extracted;
            Assertions.assertEquals(Collections.singletonMap(CustomBaseValueDtoExtractorTest.METADATA_KEY, CustomBaseValueDtoExtractorTest.METADATA_VALUE), (Object)dud2.metadata);
            Assertions.assertTrue((boolean)dud2.removeNullValues, (String)"Null values should be removed");
            Assertions.assertFalse((boolean)dud2.removeMissingValues, (String)"Missing values should be kept");
            Assertions.assertEquals((Object)DuplicateAction.UPDATE_IF_DIFFERENT, (Object)dud2.actionOnDuplicate);
        }

        @Test
        void clashingDtoWithFooAndBar() {
            ClashingDto dto = new ClashingDto();
            CustomBaseValueDtoExtractorTest.this.populate(dto);
            dto.foo = CustomBaseValueDtoExtractorTest.VALUE_2;
            dto.bar = VALUE;
            List updates = CustomBaseValueDtoExtractorTest.this.extractor(ClashingDto.class).getUpdates((Object)dto);
            Assertions.assertEquals((int)3, (int)updates.size());
            AbstractUpdateDto extracted = updates.stream().filter(DataUpdateDto.class::isInstance).filter(d -> String.class == ((DataUpdateDto)d).type).findFirst().get();
            CustomBaseValueDtoExtractorTest.this.checkCommonFields(extracted);
            Assertions.assertTrue((boolean)(extracted instanceof DataUpdateDto), (String)("Not a data update dto " + extracted.getClass()));
            DataUpdateDto dud = (DataUpdateDto)extracted;
            Assertions.assertEquals((Object)CustomBaseValueDtoExtractorTest.VALUE_2, (Object)dud.data);
            Assertions.assertEquals(String.class, (Object)dud.type);
            Assertions.assertEquals((Object)DuplicateAction.UPDATE_ALWAYS, (Object)dud.actionOnDuplicate);
            extracted = updates.stream().filter(DataUpdateDto.class::isInstance).filter(d -> Integer.class == ((DataUpdateDto)d).type).findFirst().get();
            CustomBaseValueDtoExtractorTest.this.checkCommonFields(extracted);
            Assertions.assertTrue((boolean)(extracted instanceof DataUpdateDto), (String)("Not a data update dto " + extracted.getClass()));
            dud = (DataUpdateDto)extracted;
            Assertions.assertEquals((Object)VALUE, (Object)dud.data);
            Assertions.assertEquals(Integer.class, (Object)dud.type);
            Assertions.assertEquals((Object)DuplicateAction.UPDATE_IF_DIFFERENT, (Object)dud.actionOnDuplicate);
            extracted = updates.stream().filter(MetadataUpdateDto.class::isInstance).findFirst().get();
            CustomBaseValueDtoExtractorTest.this.checkCommonFields(extracted);
            Assertions.assertTrue((boolean)(extracted instanceof MetadataUpdateDto), (String)("Not a metadata update dto " + extracted.getClass()));
            MetadataUpdateDto dud2 = (MetadataUpdateDto)extracted;
            Assertions.assertEquals(Collections.singletonMap(CustomBaseValueDtoExtractorTest.METADATA_KEY, CustomBaseValueDtoExtractorTest.METADATA_VALUE), (Object)dud2.metadata);
            Assertions.assertTrue((boolean)dud2.removeNullValues, (String)"Null values should be removed");
            Assertions.assertFalse((boolean)dud2.removeMissingValues, (String)"Missing values should be kept");
            Assertions.assertEquals((Object)DuplicateAction.UPDATE_IF_DIFFERENT, (Object)dud2.actionOnDuplicate);
        }
    }

    @Nested
    public class BaseValueDtoTests {
        @Test
        void basicDto() {
            BasicDto dto = new BasicDto();
            CustomBaseValueDtoExtractorTest.this.populate(dto);
            dto.foo = CustomBaseValueDtoExtractorTest.VALUE_2;
            List updates = CustomBaseValueDtoExtractorTest.this.extractor(BasicDto.class).getUpdates((Object)dto);
            Assertions.assertEquals((int)2, (int)updates.size());
            AbstractUpdateDto extracted = updates.stream().filter(DataUpdateDto.class::isInstance).findFirst().get();
            CustomBaseValueDtoExtractorTest.this.checkCommonFields(extracted);
            Assertions.assertTrue((boolean)(extracted instanceof DataUpdateDto), (String)("Not a data update dto " + extracted.getClass()));
            DataUpdateDto dud = (DataUpdateDto)extracted;
            Assertions.assertEquals((Object)CustomBaseValueDtoExtractorTest.VALUE_2, (Object)dud.data);
            Assertions.assertEquals(String.class, (Object)dud.type);
            Assertions.assertEquals((Object)DuplicateAction.UPDATE_ALWAYS, (Object)dud.actionOnDuplicate);
            extracted = updates.stream().filter(MetadataUpdateDto.class::isInstance).findFirst().get();
            CustomBaseValueDtoExtractorTest.this.checkCommonFields(extracted);
            Assertions.assertTrue((boolean)(extracted instanceof MetadataUpdateDto), (String)("Not a metadata update dto " + extracted.getClass()));
            MetadataUpdateDto dud2 = (MetadataUpdateDto)extracted;
            Assertions.assertEquals(Collections.singletonMap(CustomBaseValueDtoExtractorTest.METADATA_KEY, CustomBaseValueDtoExtractorTest.METADATA_VALUE), (Object)dud2.metadata);
            Assertions.assertTrue((boolean)dud2.removeNullValues, (String)"Null values should be removed");
            Assertions.assertFalse((boolean)dud2.removeMissingValues, (String)"Missing values should be kept");
            Assertions.assertEquals((Object)DuplicateAction.UPDATE_IF_DIFFERENT, (Object)dud2.actionOnDuplicate);
        }
    }

    public static class ExtendedDto
    extends BaseValueDto {
        @Data
        public String foo;
        @Provider(value="provider2")
        @Service(value="service2")
        @Resource(value="resource2")
        @Data(type=Long.class)
        public Integer bar;
        @Resource(value="null")
        @Data(onNull=NullAction.UPDATE, onDuplicate=DuplicateAction.UPDATE_IF_DIFFERENT)
        public String nullable;
        @Resource(value="null2")
        @Data(onNull=NullAction.UPDATE_IF_PRESENT)
        public String nullable2;
        @Timestamp(value=ChronoUnit.SECONDS)
        public Long time;
    }

    public static class ClashingDto
    extends BaseValueDto {
        @Data
        public String foo;
        @Data(onDuplicate=DuplicateAction.UPDATE_IF_DIFFERENT)
        public Integer bar;
    }

    public static class BasicDto
    extends BaseValueDto {
        @Data
        public String foo;
    }
}

