/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.integration;

import java.lang.reflect.InvocationTargetException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.sensinact.core.annotation.dto.Data;
import org.eclipse.sensinact.core.annotation.dto.Model;
import org.eclipse.sensinact.core.annotation.dto.ModelPackageUri;
import org.eclipse.sensinact.core.annotation.dto.Provider;
import org.eclipse.sensinact.core.annotation.dto.Resource;
import org.eclipse.sensinact.core.annotation.dto.Service;
import org.eclipse.sensinact.core.annotation.dto.Timestamp;
import org.eclipse.sensinact.core.command.AbstractSensinactCommand;
import org.eclipse.sensinact.core.command.AbstractTwinCommand;
import org.eclipse.sensinact.core.command.GatewayThread;
import org.eclipse.sensinact.core.command.ResourceCommand;
import org.eclipse.sensinact.core.push.DataUpdate;
import org.eclipse.sensinact.core.twin.SensinactDigitalTwin;
import org.eclipse.sensinact.core.twin.SensinactProvider;
import org.eclipse.sensinact.core.twin.SensinactResource;
import org.eclipse.sensinact.gateway.geojson.GeoJsonObject;
import org.eclipse.sensinact.gateway.geojson.Point;
import org.eclipse.sensinact.model.core.provider.Admin;
import org.eclipse.sensinact.model.core.testdata.DynamicTestSensor;
import org.eclipse.sensinact.model.core.testdata.TestAdmin;
import org.eclipse.sensinact.model.core.testdata.TestResource;
import org.eclipse.sensinact.model.core.testdata.TestSensor;
import org.eclipse.sensinact.model.core.testdata.TestTemperatur;
import org.eclipse.sensinact.model.core.testdata.TestdataFactory;
import org.eclipse.sensinact.model.core.testdata.TestdataPackage;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.osgi.test.common.annotation.InjectService;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseFactory;

public class EMFUpdateServiceTest {
    private static final String PROVIDER = "Provider";
    private static final String RESOURCE = "v1";
    private static final String SERVICE = "temp";
    private static final String DYNAMIC_PROVIDER = "DynamicProvider";
    @InjectService
    DataUpdate push;
    @InjectService
    GatewayThread gt;

    @AfterEach
    void stop(@InjectService GatewayThread gt) throws InvocationTargetException, InterruptedException {
        gt.execute((AbstractSensinactCommand)new AbstractTwinCommand<Void>(){

            protected Promise<Void> call(SensinactDigitalTwin twin, PromiseFactory pf) {
                Optional.ofNullable(twin.getProvider(EMFUpdateServiceTest.PROVIDER)).ifPresent(SensinactProvider::delete);
                return pf.resolved(null);
            }
        }).getValue();
    }

    private Object getResourceValue(String model, String provider, String service, String resource) throws InvocationTargetException, InterruptedException {
        Object value = this.gt.execute((AbstractSensinactCommand)new ResourceCommand<Object>("https://eclipse.org/sensinact/core/testdata/1.0", model, provider, service, resource){

            protected Promise<Object> call(SensinactResource resource, PromiseFactory pf) {
                return resource.getValue().map(t -> t.getValue());
            }
        }).getValue();
        return value;
    }

    @Nested
    public class EMFEClass {
        @Test
        void updateDTOERef() throws Exception {
            TestEClassDTO dto = new TestEClassDTO();
            dto.data = "13 \u00b0C";
            dto.timestamp = Instant.now().toEpochMilli();
            Promise update = EMFUpdateServiceTest.this.push.pushUpdate((Object)dto);
            Throwable t = update.getFailure();
            Assertions.assertNull((Object)t);
            Assertions.assertEquals((Object)"13 \u00b0C", (Object)EMFUpdateServiceTest.this.getResourceValue("TestSensor", EMFUpdateServiceTest.PROVIDER, EMFUpdateServiceTest.SERVICE, EMFUpdateServiceTest.RESOURCE));
        }

        @Test
        void updateDTOEClass() throws Exception {
            TestEClassServiceDTO dto = new TestEClassServiceDTO();
            dto.data = "13 \u00b0C";
            dto.timestamp = Instant.now().toEpochMilli();
            Promise update = EMFUpdateServiceTest.this.push.pushUpdate((Object)dto);
            Throwable t = update.getFailure();
            Assertions.assertNull((Object)t);
            Assertions.assertEquals((Object)"13 \u00b0C", (Object)EMFUpdateServiceTest.this.getResourceValue("TestSensor", EMFUpdateServiceTest.PROVIDER, EMFUpdateServiceTest.SERVICE, EMFUpdateServiceTest.RESOURCE));
        }

        @Test
        void dynamicUpdateDTOEClass() throws Exception {
            DynamicTestEClassDTO dto = new DynamicTestEClassDTO();
            dto.data = "13 \u00b0C";
            dto.timestamp = Instant.now().toEpochMilli();
            Promise update = EMFUpdateServiceTest.this.push.pushUpdate((Object)dto);
            Throwable t = update.getFailure();
            Assertions.assertNull((Object)t);
            Assertions.assertEquals((Object)"13 \u00b0C", (Object)EMFUpdateServiceTest.this.getResourceValue("DynamicTestSensor", EMFUpdateServiceTest.DYNAMIC_PROVIDER, "tmp", EMFUpdateServiceTest.RESOURCE));
        }

        @Test
        void nonDynamicUpdateDTOEClass() throws Exception {
            NonDynamicTestEClassDTO dto = new NonDynamicTestEClassDTO();
            dto.data = "13 \u00b0C";
            dto.timestamp = Instant.now().toEpochMilli();
            Promise update = EMFUpdateServiceTest.this.push.pushUpdate((Object)dto);
            Throwable t = update.getFailure();
            Assertions.assertNotNull((Object)t);
        }

        @Test
        void nonDynamicUpdateDTONoEClass() throws Exception {
            NonDynamicTestNoEClassDTO dto = new NonDynamicTestNoEClassDTO();
            dto.data = "13 \u00b0C";
            dto.timestamp = Instant.now().toEpochMilli();
            Promise update = EMFUpdateServiceTest.this.push.pushUpdate((Object)dto);
            Throwable t = update.getFailure();
            Assertions.assertNotNull((Object)t);
        }

        @Test
        void complexResource() throws Exception {
            NonDynamicComplexObjectDTO dto = new NonDynamicComplexObjectDTO();
            TestResource resource = TestdataFactory.eINSTANCE.createTestResource();
            resource.setFoo("test");
            resource.setBar("test2");
            dto.data = resource;
            dto.timestamp = Instant.now().toEpochMilli();
            Promise update = EMFUpdateServiceTest.this.push.pushUpdate((Object)dto);
            Throwable t = update.getFailure();
            Assertions.assertNull((Object)t);
            Object o = EMFUpdateServiceTest.this.getResourceValue(TestdataPackage.Literals.COMPLEX_TEST_SENSOR.getName(), EMFUpdateServiceTest.PROVIDER, TestdataPackage.Literals.COMPLEX_TEST_SENSOR__TEMP.getName(), TestdataPackage.Literals.TEST_TEMPERATUR_WITH_COMPLEX__TEST_RESOURCE.getName());
            Assertions.assertNotNull((Object)o);
        }

        @Provider(value="Provider")
        public class TestEClassDTO {
            @Model
            public EClass providerEClass = TestdataPackage.Literals.TEST_SENSOR;
            @Service
            public EReference serviceRef = TestdataPackage.Literals.TEST_SENSOR__TEMP;
            @Resource(value="v1")
            @Data
            public String data;
            @Timestamp(value=ChronoUnit.MILLIS)
            public long timestamp;
        }

        @Provider(value="Provider")
        public class TestEClassServiceDTO {
            @Model
            public EClass providerEClass = TestdataPackage.Literals.TEST_SENSOR;
            @Resource(value="v1")
            @Data
            @Service(value="temp")
            public String data;
            @Timestamp(value=ChronoUnit.MILLIS)
            public long timestamp;
        }

        @Provider(value="DynamicProvider")
        public class DynamicTestEClassDTO {
            @Model
            public EClass providerEClass = TestdataPackage.Literals.DYNAMIC_TEST_SENSOR;
            @Service
            public EClass service = TestdataPackage.Literals.TEST_TEMPERATUR;
            @Resource(value="v1")
            @Service(value="tmp")
            @Data
            public String data;
            @Timestamp(value=ChronoUnit.MILLIS)
            public long timestamp;
        }

        @Provider(value="Provider")
        public class NonDynamicTestEClassDTO {
            @Model
            public EClass providerEClass = TestdataPackage.Literals.TEST_SENSOR;
            @Service
            public EClass service = TestdataPackage.Literals.TEST_TEMPERATUR;
            @Resource(value="v1")
            @Service(value="tmp")
            @Data
            public String data;
            @Timestamp(value=ChronoUnit.MILLIS)
            public long timestamp;
        }

        @Provider(value="Provider")
        @ModelPackageUri(value="https://eclipse.org/sensinact/core/testdata/1.0")
        @Model(value="TestSensor")
        public class NonDynamicTestNoEClassDTO {
            @Resource(value="v1")
            @Service(value="tmp")
            @Data
            public String data;
            @Timestamp(value=ChronoUnit.MILLIS)
            public long timestamp;
        }

        @Provider(value="Provider")
        public class NonDynamicComplexObjectDTO {
            @Model
            public EClass providerEClass = TestdataPackage.Literals.COMPLEX_TEST_SENSOR;
            @Service
            public EReference service = TestdataPackage.Literals.COMPLEX_TEST_SENSOR__TEMP;
            @Resource(value="testResource")
            @Data
            public TestResource data;
            @Timestamp(value=ChronoUnit.MILLIS)
            public long timestamp;
        }

        @Provider(value="Provider")
        public class NonDynamicTestDTO {
            @Model
            public EClass providerEClass = TestdataPackage.Literals.TEST_SENSOR;
            @Service
            public EClass service = TestdataPackage.Literals.TEST_TEMPERATUR;
            @Resource(value="v1")
            @Service(value="tmp")
            @Data
            public String data;
            @Timestamp(value=ChronoUnit.MILLIS)
            public long timestamp;
        }
    }

    @Nested
    public class EMFDynamicProvider {
        @Test
        void dynamicUpdateDTO() throws Exception {
            DynamicTestSensor sensor = TestdataFactory.eINSTANCE.createDynamicTestSensor();
            sensor.setId(EMFUpdateServiceTest.DYNAMIC_PROVIDER);
            TestTemperatur temp = TestdataFactory.eINSTANCE.createTestTemperatur();
            temp.setV1("12 \u00b0C");
            EMap services = sensor.getServices();
            services.put((Object)EMFUpdateServiceTest.SERVICE, (Object)temp);
            Promise update = EMFUpdateServiceTest.this.push.pushUpdate((Object)sensor);
            Assertions.assertNull((Object)update.getFailure());
            Assertions.assertEquals((Object)"12 \u00b0C", (Object)EMFUpdateServiceTest.this.getResourceValue("DynamicTestSensor", EMFUpdateServiceTest.DYNAMIC_PROVIDER, EMFUpdateServiceTest.SERVICE, EMFUpdateServiceTest.RESOURCE));
            TestModelDTO dto = new TestModelDTO();
            dto.data = "13 \u00b0C";
            dto.timestamp = Instant.now().toEpochMilli();
            update = EMFUpdateServiceTest.this.push.pushUpdate((Object)dto);
            Throwable t = update.getFailure();
            Assertions.assertNull((Object)t);
            Assertions.assertEquals((Object)"13 \u00b0C", (Object)EMFUpdateServiceTest.this.getResourceValue("DynamicTestSensor", EMFUpdateServiceTest.DYNAMIC_PROVIDER, EMFUpdateServiceTest.SERVICE, EMFUpdateServiceTest.RESOURCE));
        }

        @ModelPackageUri(value="https://eclipse.org/sensinact/core/testdata/1.0")
        @Model(value="DynamicTestSensor")
        @Provider(value="DynamicProvider")
        @Service(value="temp")
        public class TestModelDTO {
            @Resource(value="v1")
            @Data
            public String data;
            @Timestamp(value=ChronoUnit.MILLIS)
            public long timestamp;
        }
    }

    @Nested
    public class EMFBaseDTO {
        @Test
        void basic() throws Exception {
            TestSensor sensor = TestdataFactory.eINSTANCE.createTestSensor();
            TestTemperatur temp = TestdataFactory.eINSTANCE.createTestTemperatur();
            temp.setV1("12 \u00b0C");
            sensor.setTemp(temp);
            sensor.setId(EMFUpdateServiceTest.PROVIDER);
            Promise update = EMFUpdateServiceTest.this.push.pushUpdate((Object)sensor);
            Assertions.assertNull((Object)update.getFailure());
            Assertions.assertEquals((Object)"12 \u00b0C", (Object)EMFUpdateServiceTest.this.getResourceValue("TestSensor", EMFUpdateServiceTest.PROVIDER, EMFUpdateServiceTest.SERVICE, EMFUpdateServiceTest.RESOURCE));
            temp.setV1("13 \u00b0C");
            update = EMFUpdateServiceTest.this.push.pushUpdate((Object)sensor);
            Assertions.assertNull((Object)update.getFailure());
            Assertions.assertEquals((Object)"13 \u00b0C", (Object)EMFUpdateServiceTest.this.getResourceValue("TestSensor", EMFUpdateServiceTest.PROVIDER, EMFUpdateServiceTest.SERVICE, EMFUpdateServiceTest.RESOURCE));
        }

        @Test
        void serviceOnly() throws Exception {
            TestSensor sensor = TestdataFactory.eINSTANCE.createTestSensor();
            TestTemperatur temp = TestdataFactory.eINSTANCE.createTestTemperatur();
            temp.setV1("14 \u00b0C");
            sensor.setTemp(temp);
            sensor.setId(EMFUpdateServiceTest.PROVIDER);
            Promise update = EMFUpdateServiceTest.this.push.pushUpdate((Object)sensor);
            Assertions.assertNull((Object)update.getFailure());
            Assertions.assertEquals((Object)"14 \u00b0C", (Object)EMFUpdateServiceTest.this.getResourceValue("TestSensor", EMFUpdateServiceTest.PROVIDER, EMFUpdateServiceTest.SERVICE, EMFUpdateServiceTest.RESOURCE));
            TestTemperatur temp2 = TestdataFactory.eINSTANCE.createTestTemperatur();
            temp2.setV1("13 \u00b0C");
            update = EMFUpdateServiceTest.this.push.pushUpdate((Object)temp2);
            Assertions.assertNull((Object)update.getFailure());
            Assertions.assertEquals((Object)"14 \u00b0C", (Object)EMFUpdateServiceTest.this.getResourceValue("TestSensor", EMFUpdateServiceTest.PROVIDER, EMFUpdateServiceTest.SERVICE, EMFUpdateServiceTest.RESOURCE));
        }

        @Test
        void admin() throws Exception {
            TestSensor sensor = TestdataFactory.eINSTANCE.createTestSensor();
            TestTemperatur temp = TestdataFactory.eINSTANCE.createTestTemperatur();
            TestAdmin admin = TestdataFactory.eINSTANCE.createTestAdmin();
            temp.setV1("14 \u00b0C");
            sensor.setTemp(temp);
            sensor.setId(EMFUpdateServiceTest.PROVIDER);
            sensor.setAdmin((Admin)admin);
            admin.setTestAdmin("blub");
            Point p = new Point();
            admin.setLocation((GeoJsonObject)p);
            Promise update = EMFUpdateServiceTest.this.push.pushUpdate((Object)sensor);
            Assertions.assertNull((Object)update.getFailure());
            Assertions.assertEquals((Object)p, (Object)EMFUpdateServiceTest.this.getResourceValue("TestSensor", EMFUpdateServiceTest.PROVIDER, "admin", "location"));
            Assertions.assertEquals((Object)"blub", (Object)EMFUpdateServiceTest.this.getResourceValue("TestSensor", EMFUpdateServiceTest.PROVIDER, "admin", "testAdmin"));
        }
    }
}

