/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.model.nexus.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.ContentHandler;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.emf.ecore.resource.impl.URIMappingRegistryImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.sensinact.core.emf.util.EMFTestUtil;
import org.eclipse.sensinact.core.model.nexus.ModelNexus;
import org.eclipse.sensinact.core.model.nexus.emf.EMFUtil;
import org.eclipse.sensinact.core.notification.NotificationAccumulator;
import org.eclipse.sensinact.model.core.provider.Admin;
import org.eclipse.sensinact.model.core.provider.DynamicProvider;
import org.eclipse.sensinact.model.core.provider.Provider;
import org.eclipse.sensinact.model.core.provider.ProviderPackage;
import org.eclipse.sensinact.model.core.provider.Service;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class NexusTest {
    @Mock
    NotificationAccumulator accumulator;
    private ResourceSet resourceSet;

    @BeforeEach
    void start() {
        this.resourceSet = EMFTestUtil.createResourceSet();
    }

    @AfterEach
    void tearDown() throws IOException {
        Path data = Paths.get("data", new String[0]);
        if (Files.exists(data, new LinkOption[0])) {
            Files.walkFileTree(data, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    try {
                        Files.delete(file);
                    }
                    catch (IOException e) {
                        throw exc;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (exc != null) {
                        throw exc;
                    }
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    @Nested
    public class EPackageTests {
        private ModelNexus nexus;
        private EPackage ePackage;

        @BeforeEach
        public void setup() throws IOException {
            final URI ProviderPackageURI = URI.createURI((String)"https://eclipse.org/sensinact/core/provider/1.0");
            URIMappingRegistryImpl.INSTANCE.put((Object)URI.createURI((String)"https://eclipse.org/../../../models/src/main/resources/model/sensinact.ecore"), (Object)ProviderPackageURI);
            XMLResource.URIHandler handler = new XMLResource.URIHandler(){

                public URI deresolve(URI arg0) {
                    return arg0;
                }

                public URI resolve(URI arg0) {
                    if (arg0.lastSegment().equals("sensinact.ecore")) {
                        return ProviderPackageURI.appendFragment(arg0.fragment());
                    }
                    return arg0;
                }

                public void setBaseURI(URI arg0) {
                }
            };
            this.nexus = new ModelNexus(NexusTest.this.resourceSet, ProviderPackage.eINSTANCE, () -> NexusTest.this.accumulator);
            Resource extendedPackageResource = NexusTest.this.resourceSet.createResource(URI.createURI((String)"https://eclipse.org/sensinact/test/1.0"));
            InputStream \u00edn = this.getClass().getResourceAsStream("/model/extended.ecore");
            Assertions.assertNotNull((Object)\u00edn);
            extendedPackageResource.load(\u00edn, Collections.singletonMap("URI_HANDLER", handler));
            this.ePackage = (EPackage)extendedPackageResource.getContents().get(0);
            Assertions.assertNotNull((Object)this.ePackage);
        }

        @Test
        void addModelEPackage() throws IOException, InterruptedException {
            EClassifier eClassifier = this.ePackage.getEClassifier("TemperatureSensor");
            String modelName = EMFUtil.getModelName((EClass)((EClass)eClassifier));
            Optional model = this.nexus.getModel(this.ePackage.getNsURI(), modelName);
            Assertions.assertTrue((boolean)model.isEmpty());
            this.nexus.addEPackage(this.ePackage);
            model = this.nexus.getModel(this.ePackage.getNsURI(), modelName);
            Assertions.assertTrue((boolean)model.isPresent());
        }

        @Test
        void removeModelEPackage() throws IOException, InterruptedException {
            EClassifier eClassifier = this.ePackage.getEClassifier("TemperatureSensor");
            String modelName = EMFUtil.getModelName((EClass)((EClass)eClassifier));
            Optional model = this.nexus.getModel(this.ePackage.getNsURI(), modelName);
            Assertions.assertTrue((boolean)model.isEmpty());
            this.nexus.addEPackage(this.ePackage);
            model = this.nexus.getModel(this.ePackage.getNsURI(), modelName);
            Assertions.assertTrue((boolean)model.isPresent());
            this.nexus.removeEPackage(this.ePackage);
            NexusTest.this.resourceSet.getPackageRegistry().remove((Object)this.ePackage.getNsURI());
            model = this.nexus.getModel(this.ePackage.getNsURI(), modelName);
            Assertions.assertTrue((boolean)model.isEmpty());
        }

        @Test
        void checkInstance() throws IOException, InterruptedException {
            EClassifier eClassifier = this.ePackage.getEClassifier("TemperatureSensor");
            String modelName = EMFUtil.getModelName((EClass)((EClass)eClassifier));
            Optional model = this.nexus.getModel(this.ePackage.getNsURI(), modelName);
            Assertions.assertTrue((boolean)model.isEmpty());
            this.nexus.addEPackage(this.ePackage);
            model = this.nexus.getModel(this.ePackage.getNsURI(), modelName);
            Assertions.assertTrue((boolean)model.isPresent());
            Provider provider = this.nexus.createProviderInstance(this.ePackage.getNsURI(), modelName, "test");
            Assertions.assertNotNull((Object)provider);
            Assertions.assertEquals((Object)eClassifier, (Object)provider.eClass());
        }

        @Test
        void checkInstanceRemovalOnPackageRemove() throws IOException, InterruptedException {
            EClassifier eClassifier = this.ePackage.getEClassifier("TemperatureSensor");
            String modelName = EMFUtil.getModelName((EClass)((EClass)eClassifier));
            Optional model = this.nexus.getModel(this.ePackage.getNsURI(), modelName);
            Assertions.assertTrue((boolean)model.isEmpty());
            this.nexus.addEPackage(this.ePackage);
            model = this.nexus.getModel(this.ePackage.getNsURI(), modelName);
            Assertions.assertTrue((boolean)model.isPresent());
            Provider provider = this.nexus.createProviderInstance(this.ePackage.getNsURI(), modelName, "test");
            Assertions.assertNotNull((Object)provider);
            this.nexus.removeEPackage(this.ePackage);
            NexusTest.this.resourceSet.getPackageRegistry().remove((Object)this.ePackage.getNsURI());
            model = this.nexus.getModel(this.ePackage.getNsURI(), modelName);
            Assertions.assertTrue((boolean)model.isEmpty());
            provider = this.nexus.getProvider(provider.getId());
            Assertions.assertNull((Object)provider);
        }
    }

    @Nested
    public class AdminTests {
        private ModelNexus nexus;
        private EPackage ePackage;

        @BeforeEach
        public void setup() throws IOException {
            final URI ProviderPackageURI = URI.createURI((String)"https://eclipse.org/sensinact/core/provider/1.0");
            URIMappingRegistryImpl.INSTANCE.put((Object)URI.createURI((String)"https://eclipse.org/../../../models/src/main/resources/model/sensinact.ecore"), (Object)ProviderPackageURI);
            XMLResource.URIHandler handler = new XMLResource.URIHandler(){

                public URI deresolve(URI arg0) {
                    return arg0;
                }

                public URI resolve(URI arg0) {
                    if (arg0.lastSegment().equals("sensinact.ecore")) {
                        return ProviderPackageURI.appendFragment(arg0.fragment());
                    }
                    return arg0;
                }

                public void setBaseURI(URI arg0) {
                }
            };
            this.nexus = new ModelNexus(NexusTest.this.resourceSet, ProviderPackage.eINSTANCE, () -> NexusTest.this.accumulator);
            Resource extendedPackageResource = NexusTest.this.resourceSet.createResource(URI.createURI((String)"https://eclipse.org/sensinact/test/1.0"));
            InputStream \u00edn = this.getClass().getResourceAsStream("/model/extended.ecore");
            Assertions.assertNotNull((Object)\u00edn);
            extendedPackageResource.load(\u00edn, Collections.singletonMap("URI_HANDLER", handler));
            this.ePackage = (EPackage)extendedPackageResource.getContents().get(0);
            Assertions.assertNotNull((Object)this.ePackage);
        }

        @Test
        void pushEObjectTestSimpleAttributeChange() throws IOException, InterruptedException {
            Provider provider = (Provider)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TemperatureSensor")));
            Service testService1 = (Service)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestService1")));
            Service testService2 = (Service)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestService2")));
            provider.setId("sensor");
            provider.eSet(provider.eClass().getEStructuralFeature("testAttribute"), (Object)"someAttrib");
            provider.eSet(provider.eClass().getEStructuralFeature("testService1"), (Object)testService1);
            provider.eSet(provider.eClass().getEStructuralFeature("testService2"), (Object)testService2);
            testService1.eSet(testService1.eClass().getEStructuralFeature("foo"), (Object)"foo");
            testService2.eSet(testService2.eClass().getEStructuralFeature("bar"), (Object)"bar");
            Provider saved = this.nexus.save(provider);
            Mockito.clearInvocations((Object[])new NotificationAccumulator[]{NexusTest.this.accumulator});
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{NexusTest.this.accumulator});
            EClass testAdminEClass = (EClass)this.ePackage.getEClassifier("TestAdmin");
            Admin testAdmin = (Admin)EcoreUtil.create((EClass)testAdminEClass);
            saved.setAdmin(testAdmin);
            testAdmin.setFriendlyName(provider.getId());
            testAdmin.eSet(testAdmin.eClass().getEStructuralFeature("testAdmin"), (Object)new BigInteger("1000"));
            Provider savedAgain = this.nexus.save(saved);
            Assertions.assertNotNull((Object)savedAgain.getAdmin());
            Assertions.assertEquals((Object)testAdminEClass, (Object)savedAgain.getAdmin().eClass());
        }
    }

    @Nested
    public class DynamicProviderTests {
        private EPackage ePackage;
        private ModelNexus nexus;

        @BeforeEach
        public void setup() throws IOException {
            final URI ProviderPackageURI = URI.createURI((String)"https://eclipse.org/sensinact/core/provider/1.0");
            URIMappingRegistryImpl.INSTANCE.put((Object)URI.createURI((String)"https://eclipse.org/../../../models/src/main/resources/model/sensinact.ecore"), (Object)ProviderPackageURI);
            XMLResource.URIHandler handler = new XMLResource.URIHandler(){

                public URI deresolve(URI arg0) {
                    return arg0;
                }

                public URI resolve(URI arg0) {
                    if (arg0.lastSegment().equals("sensinact.ecore")) {
                        return ProviderPackageURI.appendFragment(arg0.fragment());
                    }
                    return arg0;
                }

                public void setBaseURI(URI arg0) {
                }
            };
            this.nexus = new ModelNexus(NexusTest.this.resourceSet, ProviderPackage.eINSTANCE, () -> NexusTest.this.accumulator);
            Resource extendedPackageResource = NexusTest.this.resourceSet.createResource(URI.createURI((String)"https://eclipse.org/sensinact/test/1.0"));
            InputStream \u00edn = this.getClass().getResourceAsStream("/model/extended.ecore");
            Assertions.assertNotNull((Object)\u00edn);
            extendedPackageResource.load(\u00edn, Collections.singletonMap("URI_HANDLER", handler));
            this.ePackage = (EPackage)extendedPackageResource.getContents().get(0);
            Assertions.assertNotNull((Object)this.ePackage);
        }

        @Test
        void duplicatedServiceTest() {
            DynamicProvider provider = (DynamicProvider)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("DynamicTemperatureSensor")));
            Service testService1 = (Service)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestService1")));
            Service testService2 = (Service)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestService2")));
            Service testService3 = (Service)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestService1")));
            Service testService4 = (Service)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestService2")));
            Admin testAdmin = (Admin)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestAdmin")));
            provider.setId("sensor");
            provider.setAdmin(testAdmin);
            provider.eSet(provider.eClass().getEStructuralFeature("testAttribute"), (Object)"someAttrib");
            provider.eSet(provider.eClass().getEStructuralFeature("testService1"), (Object)testService1);
            provider.getServices().put((Object)"testService1", (Object)testService3);
            testService1.eSet(testService1.eClass().getEStructuralFeature("foo"), (Object)"foo");
            testService2.eSet(testService2.eClass().getEStructuralFeature("bar"), (Object)"bar");
            testService3.eSet(testService3.eClass().getEStructuralFeature("foo"), (Object)"fizz");
            testService4.eSet(testService4.eClass().getEStructuralFeature("bar"), (Object)"buzz");
            testAdmin.setFriendlyName(provider.getId());
            testAdmin.eSet(testAdmin.eClass().getEStructuralFeature("testAdmin"), (Object)new BigInteger("1000"));
            Assertions.assertThrows(IllegalArgumentException.class, () -> this.nexus.save((Provider)provider));
        }
    }

    @Nested
    public class LinkedProviderTests {
        @Test
        void addLink() {
            ModelNexus nexus = new ModelNexus(NexusTest.this.resourceSet, ProviderPackage.eINSTANCE, () -> NexusTest.this.accumulator);
            Instant now = Instant.now();
            EClass model = nexus.createModel("TestModel", now);
            EReference service = nexus.createService(model, "testservice", now);
            EReference service2 = nexus.createService(model, "testservice2", now);
            EAttribute resource = nexus.createResource(service.getEReferenceType(), "testValue", String.class, now, null);
            EAttribute resource2 = nexus.createResource(service2.getEReferenceType(), "testValue", String.class, now, null);
            EClass model2 = nexus.createModel("something_else", now);
            EReference service3 = nexus.createService(model2, "whatever", now);
            EAttribute resource3 = nexus.createResource(service3.getEReferenceType(), "testValue", String.class, now, null);
            Provider p = nexus.createProviderInstance("TestModel", "testprovider", now);
            Provider p2 = nexus.createProviderInstance("TestModel", "testproviderNew", now);
            Provider p3 = nexus.createProviderInstance("something_else", "something_else", now);
            nexus.handleDataUpdate(p, service.getName(), service, service.getEReferenceType(), (EStructuralFeature)resource, (Object)"test", now);
            nexus.handleDataUpdate(p2, service2.getName(), service2, service2.getEReferenceType(), (EStructuralFeature)resource2, (Object)"test2", now);
            nexus.handleDataUpdate(p3, service3.getName(), service3, service3.getEReferenceType(), (EStructuralFeature)resource3, (Object)"test2", now);
            nexus.linkProviders("testprovider", "testproviderNew", Instant.now());
            Provider provider = nexus.getProvider(EMFUtil.constructPackageUri((String)"TestModel"), "TestModel", "testprovider");
            Assertions.assertEquals((int)1, (int)provider.getLinkedProviders().size());
            nexus.linkProviders("testprovider", "something_else", Instant.now());
            Assertions.assertEquals((int)2, (int)provider.getLinkedProviders().size());
        }

        @Test
        void removeLink() {
            ModelNexus nexus = new ModelNexus(NexusTest.this.resourceSet, ProviderPackage.eINSTANCE, () -> NexusTest.this.accumulator);
            Instant now = Instant.now();
            EClass model = nexus.createModel("TestModel", now);
            EReference service = nexus.createService(model, "testservice", now);
            EReference service2 = nexus.createService(model, "testservice2", now);
            EAttribute resource = nexus.createResource(service.getEReferenceType(), "testValue", String.class, now, null);
            EAttribute resource2 = nexus.createResource(service2.getEReferenceType(), "testValue", String.class, now, null);
            EClass model2 = nexus.createModel("something_else", now);
            EReference service3 = nexus.createService(model2, "whatever", now);
            EAttribute resource3 = nexus.createResource(service3.getEReferenceType(), "testValue", String.class, now, null);
            Provider p = nexus.createProviderInstance("TestModel", "testprovider", now);
            Provider p2 = nexus.createProviderInstance("TestModel", "testproviderNew", now);
            Provider p3 = nexus.createProviderInstance("something_else", "something_else", now);
            nexus.handleDataUpdate(p, service.getName(), service, model2, (EStructuralFeature)resource, (Object)"test", now);
            nexus.handleDataUpdate(p2, service2.getName(), service2, model2, (EStructuralFeature)resource2, (Object)"test2", now);
            nexus.handleDataUpdate(p3, service3.getName(), service3, model2, (EStructuralFeature)resource3, (Object)"test2", now);
            nexus.linkProviders("testprovider", "testproviderNew", Instant.now());
            Provider provider = nexus.getProvider(EMFUtil.constructPackageUri((String)"TestModel"), "TestModel", "testprovider");
            Assertions.assertEquals((int)1, (int)provider.getLinkedProviders().size());
            nexus.linkProviders("testprovider", "something_else", Instant.now());
            Assertions.assertEquals((int)2, (int)provider.getLinkedProviders().size());
            nexus.unlinkProviders("testprovider", "testproviderNew", Instant.now());
            Assertions.assertEquals((int)1, (int)provider.getLinkedProviders().size());
        }
    }

    @Nested
    public class BasicModelTests {
        private static final String TEST_VALUE = "testValue";
        private static final String TESTSERVICE = "testservice";
        private static final String TESTPROVIDER = "testprovider";
        private static final String TEST_MODEL = "TestModel";
        private final String TEST_PKG = EMFUtil.constructPackageUri((String)"TestModel");

        @Test
        void basicTest() {
            NexusTest.this.resourceSet.setURIConverter(new URIConverter(){

                public void setAttributes(URI uri, Map<String, ?> attributes, Map<?, ?> options) throws IOException {
                }

                public URI normalize(URI uri) {
                    return null;
                }

                public Map<URI, URI> getURIMap() {
                    return null;
                }

                public EList<URIHandler> getURIHandlers() {
                    return null;
                }

                public URIHandler getURIHandler(URI uri) {
                    return null;
                }

                public EList<ContentHandler> getContentHandlers() {
                    return null;
                }

                public Map<String, ?> getAttributes(URI uri, Map<?, ?> options) {
                    return null;
                }

                public boolean exists(URI uri, Map<?, ?> options) {
                    return false;
                }

                public void delete(URI uri, Map<?, ?> options) throws IOException {
                }

                public OutputStream createOutputStream(URI uri, Map<?, ?> options) throws IOException {
                    return null;
                }

                public OutputStream createOutputStream(URI uri) throws IOException {
                    return null;
                }

                public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
                    return null;
                }

                public InputStream createInputStream(URI uri) throws IOException {
                    return null;
                }

                public Map<String, ?> contentDescription(URI uri, Map<?, ?> options) throws IOException {
                    return null;
                }
            });
            ModelNexus nexus = new ModelNexus(NexusTest.this.resourceSet, ProviderPackage.eINSTANCE, () -> NexusTest.this.accumulator);
            Instant now = Instant.now();
            EClass model = nexus.createModel(TEST_MODEL, now);
            EReference service = nexus.createService(model, TESTSERVICE, now);
            EAttribute resource = nexus.createResource(service.getEReferenceType(), TEST_VALUE, String.class, now, null);
            Provider p = nexus.createProviderInstance(this.TEST_PKG, TEST_MODEL, TESTPROVIDER, now);
            nexus.handleDataUpdate(p, service.getName(), service, service.getEReferenceType(), (EStructuralFeature)resource, (Object)"test", now);
            Provider provider = nexus.getProvider(this.TEST_PKG, TEST_MODEL, TESTPROVIDER);
            Assertions.assertNotNull((Object)provider);
            Assertions.assertNotNull((Object)provider.getAdmin());
            Assertions.assertEquals((Object)TESTPROVIDER, (Object)provider.getAdmin().getFriendlyName());
            EStructuralFeature serviceFeature = provider.eClass().getEStructuralFeature(TESTSERVICE);
            Assertions.assertNotNull((Object)serviceFeature);
            Assertions.assertEquals((Object)TESTSERVICE, (Object)serviceFeature.getName());
            EClass eClass = (EClass)serviceFeature.getEType();
            Assertions.assertEquals((Object)"Testservice", (Object)eClass.getName());
            Service svc = (Service)provider.eGet(serviceFeature);
            Assertions.assertNotNull((Object)svc);
            EStructuralFeature valueFeature = eClass.getEStructuralFeature(TEST_VALUE);
            Assertions.assertNotNull((Object)valueFeature);
            Assertions.assertEquals((Object)valueFeature.getEType(), (Object)EcorePackage.Literals.ESTRING);
            Object value = svc.eGet(valueFeature);
            Assertions.assertEquals((Object)"test", (Object)value);
        }

        @Test
        void sensiNactProvider() {
            ModelNexus nexus = new ModelNexus(NexusTest.this.resourceSet, ProviderPackage.eINSTANCE, () -> NexusTest.this.accumulator);
            Collection providers = nexus.getProviders();
            Assertions.assertEquals((int)1, (int)providers.size());
            Provider provider = (Provider)providers.iterator().next();
            Assertions.assertNotNull((Object)provider.getAdmin());
            Assertions.assertEquals((Object)"sensiNact", (Object)provider.getAdmin().getFriendlyName());
            EStructuralFeature serviceFeature = provider.eClass().getEStructuralFeature("system");
            Assertions.assertNotNull((Object)serviceFeature);
            Assertions.assertEquals((Object)"system", (Object)serviceFeature.getName());
            EClass eClass = (EClass)serviceFeature.getEType();
            Service service = (Service)provider.eGet(serviceFeature);
            Assertions.assertNotNull((Object)service);
            EStructuralFeature versionFeature = eClass.getEStructuralFeature("version");
            Assertions.assertNotNull((Object)versionFeature);
            Assertions.assertEquals((Object)EcorePackage.Literals.EDOUBLE, (Object)versionFeature.getEType());
            Object value = service.eGet(versionFeature);
            Assertions.assertEquals((Object)0.1, (Object)value);
            EStructuralFeature startedFeature = eClass.getEStructuralFeature("started");
            Assertions.assertNotNull((Object)startedFeature);
            Assertions.assertEquals((Object)startedFeature.getEType(), (Object)ProviderPackage.eINSTANCE.getEInstant());
            Instant started = (Instant)service.eGet(startedFeature);
            Assertions.assertNotNull((Object)started);
            Assertions.assertEquals((Object)Instant.now().truncatedTo(ChronoUnit.DAYS), (Object)started.truncatedTo(ChronoUnit.DAYS));
        }

        @Test
        void basicServiceExtensionTest() {
            ModelNexus nexus = new ModelNexus(NexusTest.this.resourceSet, ProviderPackage.eINSTANCE, () -> NexusTest.this.accumulator);
            Instant now = Instant.now();
            EClass model = nexus.createModel(TEST_MODEL, now);
            EReference service = nexus.createService(model, TESTSERVICE, now);
            EAttribute resource = nexus.createResource(service.getEReferenceType(), TEST_VALUE, String.class, now, null);
            Provider p = nexus.createProviderInstance(this.TEST_PKG, TEST_MODEL, TESTPROVIDER, now);
            nexus.handleDataUpdate(p, service.getName(), service, service.getEReferenceType(), (EStructuralFeature)resource, (Object)"test", now);
            Provider provider = nexus.getProvider(this.TEST_PKG, TEST_MODEL, TESTPROVIDER);
            Assertions.assertNotNull((Object)provider);
            EStructuralFeature serviceFeature = provider.eClass().getEStructuralFeature(TESTSERVICE);
            Service svc = (Service)provider.eGet(serviceFeature);
            EStructuralFeature valueFeature = svc.eClass().getEStructuralFeature(TEST_VALUE);
            Assertions.assertNotNull((Object)valueFeature);
            Assertions.assertEquals((Object)valueFeature.getEType(), (Object)EcorePackage.Literals.ESTRING);
            Object value = svc.eGet(valueFeature);
            Assertions.assertEquals((Object)"test", (Object)value);
            EAttribute resource2 = nexus.createResource(service.getEReferenceType(), "testValue2", String.class, now, null);
            nexus.handleDataUpdate(p, service.getName(), service, service.getEReferenceType(), (EStructuralFeature)resource2, (Object)"test", Instant.now());
            Provider updatedProvider = nexus.getProvider(this.TEST_PKG, TEST_MODEL, TESTPROVIDER);
            Assertions.assertEquals((Object)provider, (Object)updatedProvider);
            Service updateService = (Service)updatedProvider.eGet(serviceFeature);
            Assertions.assertEquals((Object)svc, (Object)updateService);
            value = updateService.eGet(valueFeature);
            Assertions.assertEquals((Object)"test", (Object)value);
            EStructuralFeature valueFeature2 = updateService.eClass().getEStructuralFeature("testValue2");
            Assertions.assertNotNull((Object)valueFeature2);
            Assertions.assertEquals((Object)valueFeature2.getEType(), (Object)EcorePackage.Literals.ESTRING);
            Object value2 = updateService.eGet(valueFeature2);
            Assertions.assertEquals((Object)"test", (Object)value2);
        }

        @Test
        void basicSecondServiceTest() {
            ModelNexus nexus = new ModelNexus(NexusTest.this.resourceSet, ProviderPackage.eINSTANCE, () -> NexusTest.this.accumulator);
            Instant now = Instant.now();
            EClass model = nexus.createModel(TEST_MODEL, now);
            EReference service = nexus.createService(model, TESTSERVICE, now);
            EAttribute resource = nexus.createResource(service.getEReferenceType(), TEST_VALUE, String.class, now, null);
            Provider p = nexus.createProviderInstance(this.TEST_PKG, TEST_MODEL, TESTPROVIDER, now);
            nexus.handleDataUpdate(p, service.getName(), service, service.getEReferenceType(), (EStructuralFeature)resource, (Object)"test", now);
            Provider provider = nexus.getProvider(this.TEST_PKG, TEST_MODEL, TESTPROVIDER);
            Assertions.assertNotNull((Object)provider);
            EStructuralFeature serviceFeature = provider.eClass().getEStructuralFeature(TESTSERVICE);
            Service svc = (Service)provider.eGet(serviceFeature);
            EStructuralFeature valueFeature = svc.eClass().getEStructuralFeature(TEST_VALUE);
            Assertions.assertNotNull((Object)valueFeature);
            Assertions.assertEquals((Object)valueFeature.getEType(), (Object)EcorePackage.Literals.ESTRING);
            Object value = svc.eGet(valueFeature);
            Assertions.assertEquals((Object)"test", (Object)value);
            EReference service2 = nexus.createService(model, "testservice2", now);
            EAttribute resource2 = nexus.createResource(service2.getEReferenceType(), TEST_VALUE, String.class, now, null);
            nexus.handleDataUpdate(p, service2.getName(), service2, service2.getEReferenceType(), (EStructuralFeature)resource2, (Object)"test2", Instant.now());
            svc = (Service)p.eGet(serviceFeature);
            Assertions.assertNotNull((Object)valueFeature);
            Assertions.assertEquals((Object)valueFeature.getEType(), (Object)EcorePackage.Literals.ESTRING);
            value = svc.eGet(valueFeature);
            Assertions.assertEquals((Object)"test", (Object)value);
            EStructuralFeature serviceFeature2 = p.eClass().getEStructuralFeature("testservice2");
            Service svc2 = (Service)p.eGet(serviceFeature2);
            EStructuralFeature valueFeature2 = svc2.eClass().getEStructuralFeature(TEST_VALUE);
            Assertions.assertNotNull((Object)valueFeature2);
            Assertions.assertEquals((Object)valueFeature2.getEType(), (Object)EcorePackage.Literals.ESTRING);
            Object value2 = svc2.eGet(valueFeature2);
            Assertions.assertEquals((Object)"test2", (Object)value2);
        }

        @Test
        void basicFullProviderTest() {
            int svcIdx;
            int modelIdx;
            ModelNexus nexus = new ModelNexus(NexusTest.this.resourceSet, ProviderPackage.eINSTANCE, () -> NexusTest.this.accumulator);
            for (modelIdx = 0; modelIdx < 2; ++modelIdx) {
                EClass model = nexus.createModel("model_" + modelIdx, Instant.now());
                for (svcIdx = 0; svcIdx < 2; ++svcIdx) {
                    EReference service = nexus.createService(model, "service_" + svcIdx, Instant.now());
                    EAttribute resource = nexus.createResource(service.getEReferenceType(), "resource", Integer.class, Instant.now(), null);
                    Provider p = svcIdx == 0 ? nexus.createProviderInstance(EMFUtil.constructPackageUri((EClass)model), EMFUtil.getModelName((EClass)model), "provider_" + modelIdx, Instant.now()) : nexus.getProvider("provider_" + modelIdx);
                    System.out.println("Calling update with model_" + modelIdx + ", provider_" + modelIdx + ", service_" + svcIdx + ", resource , 42...");
                    nexus.handleDataUpdate(p, service.getName(), service, service.getEReferenceType(), (EStructuralFeature)resource, (Object)42, Instant.now());
                }
            }
            for (modelIdx = 0; modelIdx < 2; ++modelIdx) {
                Provider provider = nexus.getProvider(null, "model_" + modelIdx, "provider_" + modelIdx);
                Assertions.assertNotNull((Object)provider);
                for (svcIdx = 0; svcIdx < 2; ++svcIdx) {
                    EStructuralFeature serviceFeature = provider.eClass().getEStructuralFeature("service_" + svcIdx);
                    Service service = (Service)provider.eGet(serviceFeature);
                    EStructuralFeature valueFeature = service.eClass().getEStructuralFeature("resource");
                    Assertions.assertNotNull((Object)valueFeature);
                    Assertions.assertEquals((Object)valueFeature.getEType(), (Object)EcorePackage.Literals.EINTEGER_OBJECT);
                    Object value = service.eGet(valueFeature);
                    Assertions.assertEquals((Object)42, (Object)value);
                }
            }
        }

        @Test
        void basicFullProviderTestWithPackage() {
            int svcIdx;
            int modelIdx;
            ModelNexus nexus = new ModelNexus(NexusTest.this.resourceSet, ProviderPackage.eINSTANCE, () -> NexusTest.this.accumulator);
            for (modelIdx = 0; modelIdx < 2; ++modelIdx) {
                EClass model = nexus.createModel(this.TEST_PKG, "model_" + modelIdx, Instant.now());
                for (svcIdx = 0; svcIdx < 2; ++svcIdx) {
                    EReference service = nexus.createService(model, "service_" + svcIdx, Instant.now());
                    EAttribute resource = nexus.createResource(service.getEReferenceType(), "resource", Integer.class, Instant.now(), null);
                    Provider p = svcIdx == 0 ? nexus.createProviderInstance(this.TEST_PKG, EMFUtil.getModelName((EClass)model), "provider_" + modelIdx, Instant.now()) : nexus.getProvider("provider_" + modelIdx);
                    System.out.println("Calling update with model_" + modelIdx + ", provider_" + modelIdx + ", service_" + svcIdx + ", resource , 42...");
                    nexus.handleDataUpdate(p, service.getName(), service, service.getEReferenceType(), (EStructuralFeature)resource, (Object)42, Instant.now());
                }
            }
            for (modelIdx = 0; modelIdx < 2; ++modelIdx) {
                Provider provider = nexus.getProvider(this.TEST_PKG, "model_" + modelIdx, "provider_" + modelIdx);
                Assertions.assertNotNull((Object)provider);
                for (svcIdx = 0; svcIdx < 2; ++svcIdx) {
                    EStructuralFeature serviceFeature = provider.eClass().getEStructuralFeature("service_" + svcIdx);
                    Service service = (Service)provider.eGet(serviceFeature);
                    EStructuralFeature valueFeature = service.eClass().getEStructuralFeature("resource");
                    Assertions.assertNotNull((Object)valueFeature);
                    Assertions.assertEquals((Object)valueFeature.getEType(), (Object)EcorePackage.Literals.EINTEGER_OBJECT);
                    Object value = service.eGet(valueFeature);
                    Assertions.assertEquals((Object)42, (Object)value);
                }
            }
        }

        @Test
        void basicPersistanceTest() throws IOException {
            ModelNexus nexus = new ModelNexus(NexusTest.this.resourceSet, ProviderPackage.eINSTANCE, () -> NexusTest.this.accumulator);
            Instant now = Instant.now();
            EClass model = nexus.createModel(TEST_MODEL, now);
            EReference service = nexus.createService(model, TESTSERVICE, now);
            EReference service2 = nexus.createService(model, "testservice2", now);
            EAttribute resource = nexus.createResource(service.getEReferenceType(), TEST_VALUE, String.class, now, null);
            EAttribute resource2 = nexus.createResource(service2.getEReferenceType(), TEST_VALUE, String.class, now, null);
            Provider p = nexus.createProviderInstance(this.TEST_PKG, TEST_MODEL, TESTPROVIDER, now);
            nexus.handleDataUpdate(p, service.getName(), service, service.getEReferenceType(), (EStructuralFeature)resource, (Object)"test", now);
            nexus.handleDataUpdate(p, service2.getName(), service2, service2.getEReferenceType(), (EStructuralFeature)resource2, (Object)"test2", now);
            nexus.shutDown();
            nexus = new ModelNexus(NexusTest.this.resourceSet, ProviderPackage.eINSTANCE, () -> NexusTest.this.accumulator);
            Provider provider = nexus.getProvider(this.TEST_PKG, TEST_MODEL, TESTPROVIDER);
            Assertions.assertNotNull((Object)provider);
            EStructuralFeature serviceFeature = provider.eClass().getEStructuralFeature("testservice2");
            Service svc = (Service)provider.eGet(serviceFeature);
            EStructuralFeature valueFeature = svc.eClass().getEStructuralFeature(TEST_VALUE);
            Assertions.assertNotNull((Object)valueFeature);
            Assertions.assertEquals((Object)valueFeature.getEType(), (Object)EcorePackage.Literals.ESTRING);
            Object value = svc.eGet(valueFeature);
            Assertions.assertEquals((Object)"test2", (Object)value);
        }

        @Test
        void basicPersistanceTestMultiple() throws IOException {
            ModelNexus nexus = new ModelNexus(NexusTest.this.resourceSet, ProviderPackage.eINSTANCE, () -> NexusTest.this.accumulator);
            Instant now = Instant.now();
            EClass model = nexus.createModel(TEST_MODEL, now);
            EClass model2 = nexus.createModel("TestModelNew", now);
            EReference service = nexus.createService(model, TESTSERVICE, now);
            EReference service2 = nexus.createService(model2, "testservice2", now);
            EAttribute resource = nexus.createResource(service.getEReferenceType(), TEST_VALUE, String.class, now, null);
            EAttribute resource2 = nexus.createResource(service2.getEReferenceType(), TEST_VALUE, String.class, now, null);
            EClass model3 = nexus.createModel("something_else", now);
            EReference service3 = nexus.createService(model3, "whatever", now);
            EAttribute resource3 = nexus.createResource(service3.getEReferenceType(), TEST_VALUE, String.class, now, null);
            Provider p = nexus.createProviderInstance(this.TEST_PKG, TEST_MODEL, TESTPROVIDER, now);
            Provider p2 = nexus.createProviderInstance(EMFUtil.constructPackageUri((String)"TestModelNew"), "TestModelNew", "testproviderNew", now);
            Provider p3 = nexus.createProviderInstance(EMFUtil.constructPackageUri((String)"something_else"), "something_else", "something_else", now);
            nexus.handleDataUpdate(p, service.getName(), service, service.getEReferenceType(), (EStructuralFeature)resource, (Object)"test", now);
            nexus.handleDataUpdate(p2, service2.getName(), service2, service2.getEReferenceType(), (EStructuralFeature)resource2, (Object)"test2", now);
            nexus.handleDataUpdate(p3, service3.getName(), service3, service3.getEReferenceType(), (EStructuralFeature)resource3, (Object)"test2", now);
            nexus.shutDown();
            nexus = new ModelNexus(NexusTest.this.resourceSet, ProviderPackage.eINSTANCE, () -> NexusTest.this.accumulator);
            this.assertObject(nexus, this.TEST_PKG, TEST_MODEL, TESTPROVIDER, TESTSERVICE, TEST_VALUE, "test");
            this.assertObject(nexus, EMFUtil.constructPackageUri((String)"TestModelNew"), "TestModelNew", "testproviderNew", "testservice2", TEST_VALUE, "test2");
            this.assertObject(nexus, EMFUtil.constructPackageUri((String)"something_else"), "something_else", "something_else", "whatever", TEST_VALUE, "test2");
        }

        void assertObject(ModelNexus nexus, String modelPackageUri, String modelName, String provider, String service, String resource, String value) {
            Provider providerObject = nexus.getProvider(modelPackageUri, modelName, provider);
            Assertions.assertNotNull((Object)providerObject);
            EStructuralFeature serviceFeature = providerObject.eClass().getEStructuralFeature(service);
            Service serviceObject = (Service)providerObject.eGet(serviceFeature);
            EStructuralFeature valueFeature = serviceObject.eClass().getEStructuralFeature(resource);
            Assertions.assertNotNull((Object)valueFeature);
            Assertions.assertEquals((Object)valueFeature.getEType(), (Object)EcorePackage.Literals.ESTRING);
            Object valueObject = serviceObject.eGet(valueFeature);
            Assertions.assertEquals((Object)value, (Object)valueObject);
        }

        @Test
        void testFindProviderWithoutModel() {
            ModelNexus nexus = new ModelNexus(NexusTest.this.resourceSet, ProviderPackage.eINSTANCE, () -> NexusTest.this.accumulator);
            Instant now = Instant.now();
            EClass model = nexus.createModel(TEST_MODEL, now);
            EReference service = nexus.createService(model, TESTSERVICE, now);
            EAttribute resource = nexus.createResource(service.getEReferenceType(), TEST_VALUE, String.class, now, null);
            Provider p = nexus.createProviderInstance(this.TEST_PKG, TEST_MODEL, TESTPROVIDER, now);
            nexus.handleDataUpdate(p, service.getName(), service, service.getEReferenceType(), (EStructuralFeature)resource, (Object)"test", now);
            Assertions.assertEquals((Object)TEST_MODEL, (Object)nexus.getProviderModel(TESTPROVIDER));
            Provider provider = nexus.getProvider(TESTPROVIDER);
            Assertions.assertNotNull((Object)provider);
            Assertions.assertEquals((Object)TESTPROVIDER, (Object)provider.getId());
            Assertions.assertSame((Object)nexus.getProvider(this.TEST_PKG, TEST_MODEL, TESTPROVIDER), (Object)provider);
        }

        @Test
        void testUnableToCreateProviderNoModel() {
            ModelNexus nexus = new ModelNexus(NexusTest.this.resourceSet, ProviderPackage.eINSTANCE, () -> NexusTest.this.accumulator);
            Instant now = Instant.now();
            Assertions.assertThrows(IllegalArgumentException.class, () -> nexus.createProviderInstance(this.TEST_PKG, TEST_MODEL, TESTPROVIDER, now));
        }

        @Test
        void testUnableToCreateProviderDifferentModelAndClashingId() {
            ModelNexus nexus = new ModelNexus(NexusTest.this.resourceSet, ProviderPackage.eINSTANCE, () -> NexusTest.this.accumulator);
            Instant now = Instant.now();
            nexus.createModel(this.TEST_PKG, TEST_MODEL, now);
            nexus.createModel(this.TEST_PKG, "TestModel2", now);
            nexus.createProviderInstance(this.TEST_PKG, TEST_MODEL, TESTPROVIDER, now);
            Assertions.assertThrows(IllegalArgumentException.class, () -> nexus.createProviderInstance(this.TEST_PKG, "TestModel2", TESTPROVIDER, now));
        }

        @ParameterizedTest
        @ValueSource(strings={"test", "123Test", "final", "http://test.de/asldjkhasdlj", "123$.final/-", "protected"})
        void testCreateModelWithStrangeName(String name) {
            ModelNexus nexus = new ModelNexus(NexusTest.this.resourceSet, ProviderPackage.eINSTANCE, () -> NexusTest.this.accumulator);
            nexus.createModel(name, Instant.now());
            Provider providerInstance = nexus.createProviderInstance(name, "test", Instant.now());
            System.out.println(name + " - " + providerInstance.eClass().getName());
            Assertions.assertNotNull((Object)providerInstance);
            Assertions.assertEquals((Object)name, (Object)EMFUtil.getModelName((EClass)providerInstance.eClass()));
            Assertions.assertNotEquals((Object)name, (Object)providerInstance.eClass().getName());
        }

        @Test
        void testDeleteModel() {
            ModelNexus nexus = new ModelNexus(NexusTest.this.resourceSet, ProviderPackage.eINSTANCE, () -> NexusTest.this.accumulator);
            Instant now = Instant.now();
            EClass model = nexus.createModel(this.TEST_PKG, TEST_MODEL, now);
            EClass model2 = nexus.createModel(this.TEST_PKG, "TestModel2", now);
            EPackage ePackage = model.getEPackage();
            Assertions.assertFalse((boolean)nexus.getModel(this.TEST_PKG, TEST_MODEL).isEmpty());
            Assertions.assertFalse((boolean)nexus.getModel(this.TEST_PKG, "TestModel2").isEmpty());
            Assertions.assertTrue((boolean)nexus.registered(model));
            Assertions.assertTrue((boolean)nexus.registered(model2));
            nexus.createProviderInstance(this.TEST_PKG, TEST_MODEL, TESTPROVIDER);
            nexus.createProviderInstance(this.TEST_PKG, "TestModel2", "testprovider2");
            Assertions.assertNotNull((Object)nexus.getProvider(TESTPROVIDER));
            Assertions.assertNotNull((Object)nexus.getProvider("testprovider2"));
            nexus.deleteModel(this.TEST_PKG, "TestModel2");
            Assertions.assertFalse((boolean)nexus.getModel(this.TEST_PKG, TEST_MODEL).isEmpty());
            Assertions.assertNotNull((Object)nexus.getProvider(TESTPROVIDER));
            Assertions.assertTrue((boolean)nexus.registered(model));
            Assertions.assertTrue((boolean)nexus.getModel(this.TEST_PKG, "TestModel2").isEmpty());
            Assertions.assertNull((Object)nexus.getProvider("testprovider2"));
            Assertions.assertFalse((boolean)nexus.registered(model2));
            Assertions.assertTrue((boolean)nexus.registered(ePackage));
            nexus.deleteModel(this.TEST_PKG, TEST_MODEL);
            Assertions.assertTrue((boolean)nexus.getModel(this.TEST_PKG, TEST_MODEL).isEmpty());
            Assertions.assertNull((Object)nexus.getProvider(TESTPROVIDER));
            Assertions.assertFalse((boolean)nexus.registered(model));
            Assertions.assertTrue((boolean)nexus.getModel(this.TEST_PKG, "TestModel2").isEmpty());
            Assertions.assertNull((Object)nexus.getProvider("testprovider2"));
            Assertions.assertFalse((boolean)nexus.registered(model2));
            Assertions.assertFalse((boolean)nexus.registered(ePackage));
        }
    }
}

