/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.model.nexus.impl;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.URIMappingRegistryImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.sensinact.core.emf.util.EMFTestUtil;
import org.eclipse.sensinact.core.model.nexus.ModelNexus;
import org.eclipse.sensinact.core.model.nexus.emf.EMFUtil;
import org.eclipse.sensinact.core.notification.NotificationAccumulator;
import org.eclipse.sensinact.model.core.metadata.ResourceMetadata;
import org.eclipse.sensinact.model.core.provider.Admin;
import org.eclipse.sensinact.model.core.provider.DynamicProvider;
import org.eclipse.sensinact.model.core.provider.FeatureCustomMetadata;
import org.eclipse.sensinact.model.core.provider.Metadata;
import org.eclipse.sensinact.model.core.provider.Provider;
import org.eclipse.sensinact.model.core.provider.ProviderFactory;
import org.eclipse.sensinact.model.core.provider.ProviderPackage;
import org.eclipse.sensinact.model.core.provider.Service;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class SubscriptionTest {
    @Mock
    NotificationAccumulator accumulator;
    private ResourceSet resourceSet;

    @BeforeEach
    void start() {
        this.resourceSet = EMFTestUtil.createResourceSet();
    }

    @AfterEach
    void tearDown() throws IOException {
        Path data = Paths.get("data", new String[0]);
        if (Files.exists(data, new LinkOption[0])) {
            Files.walkFileTree(data, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    try {
                        Files.delete(file);
                    }
                    catch (IOException e) {
                        throw exc;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (exc != null) {
                        throw exc;
                    }
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    private static void verifyServiceChangeNottification(NotificationAccumulator accumulator, Provider provider, Service oldService, Service newService, String serviceName) {
        EMFUtil.streamAttributes((EClass)oldService.eClass()).filter(arg_0 -> ((Service)oldService).eIsSet(arg_0)).forEach(ea -> SubscriptionTest.verifyServiceAttributeChangeNotification(accumulator, provider, oldService, newService, ea, serviceName));
    }

    private static void verifyServiceRemoveNottification(NotificationAccumulator accumulator, Provider provider, Service oldService, String serviceName) {
        EMFUtil.streamAttributes((EClass)oldService.eClass()).filter(arg_0 -> ((Service)oldService).eIsSet(arg_0)).forEach(ea -> SubscriptionTest.verifyServiceAttributeRemoveNotification(accumulator, provider, oldService, ea));
        ((NotificationAccumulator)Mockito.verify((Object)accumulator)).removeService(provider.eClass().getEPackage().getNsURI(), EMFUtil.getModelName((EClass)provider.eClass()), provider.getId(), serviceName);
    }

    private static void verifyNewProviderNotification(NotificationAccumulator accumulator, Provider provider) {
        ((NotificationAccumulator)Mockito.verify((Object)accumulator)).addProvider(provider.eClass().getEPackage().getNsURI(), EMFUtil.getModelName((EClass)provider.eClass()), provider.getId());
        provider.eClass().getEAllReferences().stream().filter(ea -> ea.getEContainingClass().getEPackage() != EcorePackage.eINSTANCE).filter(arg_0 -> ((Provider)provider).eIsSet(arg_0)).map(arg_0 -> ((Provider)provider).eGet(arg_0)).filter(Service.class::isInstance).map(Service.class::cast).forEach(s -> SubscriptionTest.verifyNewServiceNottification(accumulator, provider, s, s.eContainingFeature().getName()));
        if (provider instanceof DynamicProvider) {
            ((DynamicProvider)provider).getServices().forEach(e -> SubscriptionTest.verifyNewServiceNottification(accumulator, provider, (Service)e.getValue(), (String)e.getKey()));
        }
    }

    private static void verifyNewServiceNottification(NotificationAccumulator accumulator, Provider provider, Service service, String serviceName) {
        ((NotificationAccumulator)Mockito.verify((Object)accumulator)).addService(provider.eClass().getEPackage().getNsURI(), EMFUtil.getModelName((EClass)provider.eClass()), provider.getId(), serviceName);
        EMFUtil.streamAttributes((EClass)service.eClass()).filter(arg_0 -> ((Service)service).eIsSet(arg_0)).forEach(ea -> SubscriptionTest.verifyNewServiceAttributeNotification(accumulator, provider, service, serviceName, ea));
    }

    private static void verifyNewServiceAttributeNotification(NotificationAccumulator accumulator, Provider provider, Service service, String serviceName, EAttribute attribute) {
        String modelName = EMFUtil.getModelName((EClass)provider.eClass());
        ((NotificationAccumulator)Mockito.verify((Object)accumulator)).addResource(provider.eClass().getEPackage().getNsURI(), modelName, provider.getId(), serviceName, attribute.getName());
        ((NotificationAccumulator)Mockito.verify((Object)accumulator)).resourceValueUpdate(provider.eClass().getEPackage().getNsURI(), modelName, provider.getId(), serviceName, attribute.getName(), attribute.getEType().getInstanceClass(), null, service.eGet((EStructuralFeature)attribute), SubscriptionTest.getTimestampForService(service, (EStructuralFeature)attribute));
        ((NotificationAccumulator)Mockito.verify((Object)accumulator)).metadataValueUpdate(provider.eClass().getEPackage().getNsURI(), modelName, provider.getId(), serviceName, attribute.getName(), null, Map.of("value", service.eGet((EStructuralFeature)attribute), "timestamp", SubscriptionTest.getTimestampForService(service, (EStructuralFeature)attribute)), SubscriptionTest.getTimestampForService(service, (EStructuralFeature)attribute));
    }

    private static void verifyServiceAttributeRemoveNotification(NotificationAccumulator accumulator, Provider provider, Service oldService, EAttribute attribute) {
        String modelName = EMFUtil.getModelName((EClass)provider.eClass());
        ((NotificationAccumulator)Mockito.verify((Object)accumulator)).resourceValueUpdate(provider.eClass().getEPackage().getNsURI(), modelName, provider.getId(), oldService.eContainingFeature().getName(), attribute.getName(), attribute.getEType().getInstanceClass(), oldService.eGet((EStructuralFeature)attribute), null, (Instant)Mockito.any());
        ((NotificationAccumulator)Mockito.verify((Object)accumulator)).metadataValueUpdate(provider.eClass().getEPackage().getNsURI(), modelName, provider.getId(), oldService.eContainingFeature().getName(), attribute.getName(), Map.of("value", oldService.eGet((EStructuralFeature)attribute), "timestamp", SubscriptionTest.getTimestampForService(oldService, (EStructuralFeature)attribute)), null, (Instant)Mockito.any());
        ((NotificationAccumulator)Mockito.verify((Object)accumulator)).removeResource(provider.eClass().getEPackage().getNsURI(), modelName, provider.getId(), oldService.eContainingFeature().getName(), attribute.getName());
    }

    private static void verifyServiceAttributeChangeNotification(NotificationAccumulator accumulator, Provider provider, Service oldService, Service newService, EAttribute attribute, String serviceName) {
        if (Objects.equals(oldService.eGet((EStructuralFeature)attribute), newService.eGet((EStructuralFeature)attribute))) {
            return;
        }
        String modelName = EMFUtil.getModelName((EClass)provider.eClass());
        ((NotificationAccumulator)Mockito.verify((Object)accumulator)).resourceValueUpdate((String)ArgumentMatchers.eq((Object)provider.eClass().getEPackage().getNsURI()), (String)ArgumentMatchers.eq((Object)modelName), (String)ArgumentMatchers.eq((Object)provider.getId()), (String)ArgumentMatchers.eq((Object)serviceName), (String)ArgumentMatchers.eq((Object)attribute.getName()), (Class)ArgumentMatchers.eq((Object)attribute.getEType().getInstanceClass()), ArgumentMatchers.eq((Object)oldService.eGet((EStructuralFeature)attribute)), ArgumentMatchers.eq((Object)newService.eGet((EStructuralFeature)attribute)), (Instant)Mockito.any());
        ((NotificationAccumulator)Mockito.verify((Object)accumulator)).metadataValueUpdate(provider.eClass().getEPackage().getNsURI(), modelName, provider.getId(), serviceName, attribute.getName(), Map.of("value", oldService.eGet((EStructuralFeature)attribute), "timestamp", SubscriptionTest.getTimestampForService(oldService, (EStructuralFeature)attribute)), Map.of("value", newService.eGet((EStructuralFeature)attribute), "timestamp", SubscriptionTest.getTimestampForService(newService, (EStructuralFeature)attribute)), SubscriptionTest.getTimestampForService(newService, (EStructuralFeature)attribute));
    }

    private static Instant getTimestampForService(Service service, EStructuralFeature feature) {
        return ((Metadata)service.getMetadata().get((Object)feature)).getTimestamp();
    }

    @Nested
    public class EObjectPushTests {
        private ModelNexus nexus;
        private EPackage ePackage;

        @BeforeEach
        public void setup() throws IOException {
            final URI ProviderPackageURI = URI.createURI((String)"https://eclipse.org/sensinact/core/provider/1.0");
            URIMappingRegistryImpl.INSTANCE.put((Object)URI.createURI((String)"https://eclipse.org/../../../models/src/main/resources/model/sensinact.ecore"), (Object)ProviderPackageURI);
            XMLResource.URIHandler handler = new XMLResource.URIHandler(){

                public URI deresolve(URI arg0) {
                    return arg0;
                }

                public URI resolve(URI arg0) {
                    if (arg0.lastSegment().equals("sensinact.ecore")) {
                        return ProviderPackageURI.appendFragment(arg0.fragment());
                    }
                    return arg0;
                }

                public void setBaseURI(URI arg0) {
                }
            };
            this.nexus = new ModelNexus(SubscriptionTest.this.resourceSet, ProviderPackage.eINSTANCE, () -> SubscriptionTest.this.accumulator);
            Resource extendedPackageResource = SubscriptionTest.this.resourceSet.createResource(URI.createURI((String)"https://eclipse.org/sensinact/test/1.0"));
            InputStream \u00edn = this.getClass().getResourceAsStream("/model/extended.ecore");
            Assertions.assertNotNull((Object)\u00edn);
            extendedPackageResource.load(\u00edn, Collections.singletonMap("URI_HANDLER", handler));
            this.ePackage = (EPackage)extendedPackageResource.getContents().get(0);
            Assertions.assertNotNull((Object)this.ePackage);
        }

        @Test
        void pushEObjectTestSimple() throws IOException {
            Provider provider = (Provider)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TemperatureSensor")));
            Service testService1 = (Service)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestService1")));
            Service testService2 = (Service)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestService2")));
            Admin testAdmin = (Admin)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestAdmin")));
            provider.setId("sensor");
            provider.setAdmin(testAdmin);
            provider.eSet(provider.eClass().getEStructuralFeature("testAttribute"), (Object)"someAttrib");
            provider.eSet(provider.eClass().getEStructuralFeature("testService1"), (Object)testService1);
            provider.eSet(provider.eClass().getEStructuralFeature("testService2"), (Object)testService2);
            testService1.eSet(testService1.eClass().getEStructuralFeature("foo"), (Object)"foo");
            testService2.eSet(testService2.eClass().getEStructuralFeature("bar"), (Object)"bar");
            testAdmin.setFriendlyName(provider.getId());
            testAdmin.eSet(testAdmin.eClass().getEStructuralFeature("testAdmin"), (Object)new BigInteger("1000"));
            Provider saved = this.nexus.save(provider);
            SubscriptionTest.verifyNewProviderNotification(SubscriptionTest.this.accumulator, saved);
        }

        @Test
        void pushEObjectTestSimpleWithServiceMap() throws IOException {
            DynamicProvider provider = (DynamicProvider)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("DynamicTemperatureSensor")));
            Service testService1 = (Service)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestService1")));
            Service testService2 = (Service)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestService2")));
            Admin testAdmin = (Admin)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestAdmin")));
            Service testService3 = (Service)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestService1")));
            Service testService4 = (Service)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestService2")));
            provider.setId("sensor");
            provider.setAdmin(testAdmin);
            provider.eSet(provider.eClass().getEStructuralFeature("testAttribute"), (Object)"someAttrib");
            provider.eSet(provider.eClass().getEStructuralFeature("testService1"), (Object)testService1);
            provider.eSet(provider.eClass().getEStructuralFeature("testService2"), (Object)testService2);
            testService3.eSet(testService1.eClass().getEStructuralFeature("foo"), (Object)"foo");
            testService4.eSet(testService2.eClass().getEStructuralFeature("bar"), (Object)"bar");
            testAdmin.setFriendlyName(provider.getId());
            testAdmin.eSet(testAdmin.eClass().getEStructuralFeature("testAdmin"), (Object)new BigInteger("1000"));
            provider.getServices().put((Object)"testService3", (Object)testService3);
            provider.getServices().put((Object)"testService4", (Object)testService4);
            Provider saved = this.nexus.save((Provider)provider);
            SubscriptionTest.verifyNewProviderNotification(SubscriptionTest.this.accumulator, saved);
        }

        @Test
        void pushEObjectTestSimpleWithServiceMapRemoveService() throws IOException {
            DynamicProvider provider = (DynamicProvider)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("DynamicTemperatureSensor")));
            Service testService1 = (Service)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestService1")));
            Service testService2 = (Service)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestService2")));
            Admin testAdmin = (Admin)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestAdmin")));
            Service testService3 = (Service)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestService1")));
            Service testService4 = (Service)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestService2")));
            provider.setId("sensor");
            provider.setAdmin(testAdmin);
            provider.eSet(provider.eClass().getEStructuralFeature("testAttribute"), (Object)"someAttrib");
            provider.eSet(provider.eClass().getEStructuralFeature("testService1"), (Object)testService1);
            provider.eSet(provider.eClass().getEStructuralFeature("testService2"), (Object)testService2);
            testService3.eSet(testService1.eClass().getEStructuralFeature("foo"), (Object)"foo");
            testService4.eSet(testService2.eClass().getEStructuralFeature("bar"), (Object)"bar");
            testAdmin.setFriendlyName(provider.getId());
            testAdmin.eSet(testAdmin.eClass().getEStructuralFeature("testAdmin"), (Object)new BigInteger("1000"));
            provider.getServices().put((Object)"testService3", (Object)testService3);
            provider.getServices().put((Object)"testService4", (Object)testService4);
            Provider saved = this.nexus.save((Provider)provider);
            Assertions.assertTrue((boolean)(saved instanceof DynamicProvider));
            SubscriptionTest.verifyNewProviderNotification(SubscriptionTest.this.accumulator, saved);
            DynamicProvider dynamic = (DynamicProvider)saved;
            Service service = (Service)dynamic.getServices().removeKey((Object)"testService4");
            dynamic.getServices().put((Object)"bla", (Object)service);
            saved = this.nexus.save((Provider)dynamic);
            this.verifyProviderUpdateNotification(SubscriptionTest.this.accumulator, (Provider)provider, saved);
        }

        @Test
        void pushEObjectTestSimpleAttributeAddWithSetTimestamp() throws IOException {
            Provider provider = (Provider)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TemperatureSensor")));
            Service testService1 = (Service)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestService1")));
            Service testService2 = (Service)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestService2")));
            Admin testAdmin = (Admin)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestAdmin")));
            provider.setId("sensor");
            provider.setAdmin(testAdmin);
            provider.eSet(provider.eClass().getEStructuralFeature("testAttribute"), (Object)"someAttrib");
            provider.eSet(provider.eClass().getEStructuralFeature("testService1"), (Object)testService1);
            provider.eSet(provider.eClass().getEStructuralFeature("testService2"), (Object)testService2);
            testService1.eSet(testService1.eClass().getEStructuralFeature("foo"), (Object)"foo");
            testService2.eSet(testService2.eClass().getEStructuralFeature("bar"), (Object)"bar");
            testAdmin.setFriendlyName(provider.getId());
            testAdmin.eSet(testAdmin.eClass().getEStructuralFeature("testAdmin"), (Object)new BigInteger("1000"));
            Provider saved = this.nexus.save(provider);
            Mockito.clearInvocations((Object[])new NotificationAccumulator[]{SubscriptionTest.this.accumulator});
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SubscriptionTest.this.accumulator});
            ((Service)saved.eGet(provider.eClass().getEStructuralFeature("testService1"))).eSet(testService1.eClass().getEStructuralFeature("foo2"), (Object)"somethingElse");
            Metadata newMetadata = ProviderFactory.eINSTANCE.createMetadata();
            newMetadata.setTimestamp(Instant.now());
            ((Service)saved.eGet(provider.eClass().getEStructuralFeature("testService1"))).getMetadata().put((Object)testService1.eClass().getEStructuralFeature("foo2"), (Object)newMetadata);
            Instant mark = Instant.now();
            Mockito.clearInvocations((Object[])new NotificationAccumulator[]{SubscriptionTest.this.accumulator});
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SubscriptionTest.this.accumulator});
            Provider toTest = this.nexus.save(saved);
            Metadata curMetadata = (Metadata)((Service)toTest.eGet(provider.eClass().getEStructuralFeature("testService1"))).getMetadata().get((Object)testService1.eClass().getEStructuralFeature("foo"));
            Assertions.assertNotNull((Object)curMetadata);
            Assertions.assertFalse((boolean)curMetadata.getTimestamp().isAfter(mark));
            String modelName = EMFUtil.getModelName((EClass)provider.eClass());
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).addResource(this.ePackage.getNsURI(), modelName, provider.getId(), "testService1", "foo2");
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).resourceValueUpdate(this.ePackage.getNsURI(), modelName, provider.getId(), "testService1", "foo2", String.class, null, (Object)"somethingElse", newMetadata.getTimestamp());
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).metadataValueUpdate(this.ePackage.getNsURI(), modelName, provider.getId(), "testService1", "foo2", null, Map.of("value", "somethingElse", "timestamp", newMetadata.getTimestamp()), newMetadata.getTimestamp());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SubscriptionTest.this.accumulator});
        }

        @Test
        void pushEObjectTestSimpleAttributeChange() throws IOException, InterruptedException {
            Provider provider = (Provider)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TemperatureSensor")));
            Service testService1 = (Service)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestService1")));
            Service testService2 = (Service)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestService2")));
            Admin testAdmin = (Admin)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestAdmin")));
            provider.setId("sensor");
            provider.setAdmin(testAdmin);
            provider.eSet(provider.eClass().getEStructuralFeature("testAttribute"), (Object)"someAttrib");
            provider.eSet(provider.eClass().getEStructuralFeature("testService1"), (Object)testService1);
            provider.eSet(provider.eClass().getEStructuralFeature("testService2"), (Object)testService2);
            testService1.eSet(testService1.eClass().getEStructuralFeature("foo"), (Object)"foo");
            testService2.eSet(testService2.eClass().getEStructuralFeature("bar"), (Object)"bar");
            testAdmin.setFriendlyName(provider.getId());
            testAdmin.eSet(testAdmin.eClass().getEStructuralFeature("testAdmin"), (Object)new BigInteger("1000"));
            Provider saved = this.nexus.save(provider);
            Mockito.clearInvocations((Object[])new NotificationAccumulator[]{SubscriptionTest.this.accumulator});
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SubscriptionTest.this.accumulator});
            ((Service)saved.eGet(provider.eClass().getEStructuralFeature("testService1"))).eSet(testService1.eClass().getEStructuralFeature("foo"), (Object)"foo2");
            Metadata oldMetadata = (Metadata)((Service)saved.eGet(provider.eClass().getEStructuralFeature("testService1"))).getMetadata().get((Object)testService1.eClass().getEStructuralFeature("foo"));
            ((Service)saved.eGet(provider.eClass().getEStructuralFeature("testService1"))).getMetadata().clear();
            Instant mark = Instant.now();
            Thread.sleep(100L);
            Provider toTest = this.nexus.save(saved);
            Metadata curMetadata = (Metadata)((Service)toTest.eGet(provider.eClass().getEStructuralFeature("testService1"))).getMetadata().get((Object)testService1.eClass().getEStructuralFeature("foo"));
            Assertions.assertNotNull((Object)curMetadata);
            Assertions.assertTrue((boolean)curMetadata.getTimestamp().isAfter(mark));
            String modelName = EMFUtil.getModelName((EClass)provider.eClass());
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).resourceValueUpdate(this.ePackage.getNsURI(), modelName, provider.getId(), "testService1", "foo", String.class, (Object)"foo", (Object)"foo2", curMetadata.getTimestamp());
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).metadataValueUpdate(this.ePackage.getNsURI(), modelName, provider.getId(), "testService1", "foo", Map.of("value", "foo", "timestamp", oldMetadata.getTimestamp()), Map.of("value", "foo2", "timestamp", curMetadata.getTimestamp()), curMetadata.getTimestamp());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SubscriptionTest.this.accumulator});
        }

        @Test
        void pushEObjectMetadataIsBecomesResourceMetadata() throws IOException, InterruptedException {
            Provider provider = (Provider)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TemperatureSensor")));
            Service testService1 = (Service)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestService1")));
            Service testService2 = (Service)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestService2")));
            Admin testAdmin = (Admin)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestAdmin")));
            provider.setId("sensor");
            provider.setAdmin(testAdmin);
            provider.eSet(provider.eClass().getEStructuralFeature("testAttribute"), (Object)"someAttrib");
            provider.eSet(provider.eClass().getEStructuralFeature("testService1"), (Object)testService1);
            provider.eSet(provider.eClass().getEStructuralFeature("testService2"), (Object)testService2);
            testService1.eSet(testService1.eClass().getEStructuralFeature("foo"), (Object)"foo");
            testService2.eSet(testService2.eClass().getEStructuralFeature("bar"), (Object)"bar");
            Metadata initialMetadata = ProviderFactory.eINSTANCE.createMetadata();
            initialMetadata.setTimestamp(Instant.now());
            testService1.getMetadata().put((Object)testService1.eClass().getEStructuralFeature("foo"), (Object)initialMetadata);
            testAdmin.setFriendlyName(provider.getId());
            testAdmin.eSet(testAdmin.eClass().getEStructuralFeature("testAdmin"), (Object)new BigInteger("1000"));
            Provider saved = this.nexus.save(provider);
            Metadata initialMetadataToCheck = (Metadata)((Service)saved.eGet(provider.eClass().getEStructuralFeature("testService1"))).getMetadata().get((Object)testService1.eClass().getEStructuralFeature("foo"));
            Assertions.assertNotNull((Object)initialMetadataToCheck);
            Assertions.assertTrue((boolean)(initialMetadataToCheck instanceof ResourceMetadata));
            Mockito.clearInvocations((Object[])new NotificationAccumulator[]{SubscriptionTest.this.accumulator});
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SubscriptionTest.this.accumulator});
            ((Service)saved.eGet(provider.eClass().getEStructuralFeature("testService1"))).eSet(testService1.eClass().getEStructuralFeature("foo2"), (Object)"somethingElse");
            Metadata newMetadata = ProviderFactory.eINSTANCE.createMetadata();
            newMetadata.setTimestamp(Instant.now());
            FeatureCustomMetadata fcm = ProviderFactory.eINSTANCE.createFeatureCustomMetadata();
            fcm.setName("test.meta.1");
            fcm.setValue((Object)"some Test");
            fcm.setTimestamp(Instant.now());
            newMetadata.getExtra().add((Object)fcm);
            ((Service)saved.eGet(provider.eClass().getEStructuralFeature("testService1"))).getMetadata().put((Object)testService1.eClass().getEStructuralFeature("foo2"), (Object)newMetadata);
            Instant mark = Instant.now();
            Mockito.clearInvocations((Object[])new NotificationAccumulator[]{SubscriptionTest.this.accumulator});
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SubscriptionTest.this.accumulator});
            Provider toTest = this.nexus.save(saved);
            Metadata curMetadata = (Metadata)((Service)toTest.eGet(provider.eClass().getEStructuralFeature("testService1"))).getMetadata().get((Object)testService1.eClass().getEStructuralFeature("foo"));
            Assertions.assertNotNull((Object)curMetadata);
            Assertions.assertFalse((boolean)curMetadata.getTimestamp().isAfter(mark));
            Assertions.assertTrue((boolean)(curMetadata instanceof ResourceMetadata));
            String modelName = EMFUtil.getModelName((EClass)provider.eClass());
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).addResource(this.ePackage.getNsURI(), modelName, provider.getId(), "testService1", "foo2");
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).resourceValueUpdate(this.ePackage.getNsURI(), modelName, provider.getId(), "testService1", "foo2", String.class, null, (Object)"somethingElse", newMetadata.getTimestamp());
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).metadataValueUpdate(this.ePackage.getNsURI(), modelName, provider.getId(), "testService1", "foo2", null, Map.of("test.meta.1", "some Test", "value", "somethingElse", "timestamp", newMetadata.getTimestamp()), newMetadata.getTimestamp());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SubscriptionTest.this.accumulator});
        }

        @Test
        void pushEObjectTestSimpleAttributeChangeWithMetadata() throws IOException, InterruptedException {
            Provider provider = (Provider)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TemperatureSensor")));
            Service testService1 = (Service)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestService1")));
            Service testService2 = (Service)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestService2")));
            Admin testAdmin = (Admin)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestAdmin")));
            provider.setId("sensor");
            provider.setAdmin(testAdmin);
            provider.eSet(provider.eClass().getEStructuralFeature("testAttribute"), (Object)"someAttrib");
            provider.eSet(provider.eClass().getEStructuralFeature("testService1"), (Object)testService1);
            provider.eSet(provider.eClass().getEStructuralFeature("testService2"), (Object)testService2);
            testService1.eSet(testService1.eClass().getEStructuralFeature("foo"), (Object)"foo");
            testService2.eSet(testService2.eClass().getEStructuralFeature("bar"), (Object)"bar");
            testAdmin.setFriendlyName(provider.getId());
            testAdmin.eSet(testAdmin.eClass().getEStructuralFeature("testAdmin"), (Object)new BigInteger("1000"));
            Provider saved = this.nexus.save(provider);
            Mockito.clearInvocations((Object[])new NotificationAccumulator[]{SubscriptionTest.this.accumulator});
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SubscriptionTest.this.accumulator});
            ((Service)saved.eGet(provider.eClass().getEStructuralFeature("testService1"))).eSet(testService1.eClass().getEStructuralFeature("foo"), (Object)"foo2");
            Metadata oldMetadata = (Metadata)((Service)saved.eGet(provider.eClass().getEStructuralFeature("testService1"))).getMetadata().get((Object)testService1.eClass().getEStructuralFeature("foo"));
            FeatureCustomMetadata fcm = ProviderFactory.eINSTANCE.createFeatureCustomMetadata();
            fcm.setName("test.meta.1");
            fcm.setValue((Object)"some Test");
            fcm.setTimestamp(Instant.now());
            oldMetadata.getExtra().add((Object)fcm);
            fcm = ProviderFactory.eINSTANCE.createFeatureCustomMetadata();
            fcm.setName("test.meta.2");
            fcm.setValue((Object)2);
            fcm.setTimestamp(Instant.now());
            Instant mark = Instant.now();
            Thread.sleep(100L);
            oldMetadata.getExtra().add((Object)fcm);
            Instant oldMetadataTimestampToCompare = oldMetadata.getTimestamp();
            oldMetadata.setTimestamp(Instant.now());
            Thread.sleep(100L);
            Provider toTest = this.nexus.save(saved);
            Metadata curMetadata = (Metadata)((Service)toTest.eGet(provider.eClass().getEStructuralFeature("testService1"))).getMetadata().get((Object)testService1.eClass().getEStructuralFeature("foo"));
            System.err.println(mark);
            System.err.println(curMetadata.getTimestamp());
            Assertions.assertNotNull((Object)curMetadata);
            Assertions.assertTrue((boolean)curMetadata.getTimestamp().isAfter(mark));
            String modelName = EMFUtil.getModelName((EClass)provider.eClass());
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).resourceValueUpdate(this.ePackage.getNsURI(), modelName, provider.getId(), "testService1", "foo", String.class, (Object)"foo", (Object)"foo2", curMetadata.getTimestamp());
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).metadataValueUpdate(this.ePackage.getNsURI(), modelName, provider.getId(), "testService1", "foo", Map.of("value", "foo", "timestamp", oldMetadataTimestampToCompare), Map.of("test.meta.1", "some Test", "test.meta.2", 2, "value", "foo2", "timestamp", curMetadata.getTimestamp()), curMetadata.getTimestamp());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SubscriptionTest.this.accumulator});
        }

        @Test
        void pushEObjectTestSimpleAttributeChangeWithModelAnnotationMetadata() throws IOException, InterruptedException {
            Provider provider = (Provider)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TemperatureSensor")));
            Service testService1 = (Service)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestService1")));
            Service testService2 = (Service)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestService2")));
            Admin testAdmin = (Admin)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestAdmin")));
            provider.setId("sensor");
            provider.setAdmin(testAdmin);
            provider.eSet(provider.eClass().getEStructuralFeature("testAttribute"), (Object)"someAttrib");
            provider.eSet(provider.eClass().getEStructuralFeature("testService1"), (Object)testService1);
            provider.eSet(provider.eClass().getEStructuralFeature("testService2"), (Object)testService2);
            testService1.eSet(testService1.eClass().getEStructuralFeature("foo"), (Object)"foo");
            testService2.eSet(testService2.eClass().getEStructuralFeature("bar"), (Object)"bar");
            testAdmin.setFriendlyName(provider.getId());
            testAdmin.eSet(testAdmin.eClass().getEStructuralFeature("testAdmin"), (Object)new BigInteger("1000"));
            Provider saved = this.nexus.save(provider);
            Mockito.clearInvocations((Object[])new NotificationAccumulator[]{SubscriptionTest.this.accumulator});
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SubscriptionTest.this.accumulator});
            ((Service)saved.eGet(provider.eClass().getEStructuralFeature("testService2"))).eSet(testService2.eClass().getEStructuralFeature("annotated"), (Object)"avalue");
            Instant mark = Instant.now();
            Thread.sleep(100L);
            Provider toTest = this.nexus.save(saved);
            Metadata curMetadata = (Metadata)((Service)toTest.eGet(provider.eClass().getEStructuralFeature("testService2"))).getMetadata().get((Object)testService2.eClass().getEStructuralFeature("annotated"));
            System.err.println(mark);
            System.err.println(curMetadata.getTimestamp());
            Assertions.assertNotNull((Object)curMetadata);
            Assertions.assertTrue((boolean)curMetadata.getTimestamp().isAfter(mark));
            Assertions.assertEquals((int)0, (int)curMetadata.getExtra().size());
            String modelName = EMFUtil.getModelName((EClass)provider.eClass());
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).addResource(this.ePackage.getNsURI(), modelName, provider.getId(), "testService2", "annotated");
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).resourceValueUpdate(this.ePackage.getNsURI(), modelName, provider.getId(), "testService2", "annotated", String.class, null, (Object)"avalue", curMetadata.getTimestamp());
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).metadataValueUpdate(this.ePackage.getNsURI(), modelName, provider.getId(), "testService2", "annotated", null, Map.of("test", "testMetadata", "test2", "testMetadata2", "value", "avalue", "timestamp", curMetadata.getTimestamp()), curMetadata.getTimestamp());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SubscriptionTest.this.accumulator});
        }

        @Test
        void pushEObjectTestSimpleAttributeChangeWithModelAnnotationMetadataWithOverwrite() throws IOException, InterruptedException {
            Provider provider = (Provider)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TemperatureSensor")));
            Service testService1 = (Service)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestService1")));
            Service testService2 = (Service)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestService2")));
            Admin testAdmin = (Admin)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestAdmin")));
            provider.setId("sensor");
            provider.setAdmin(testAdmin);
            provider.eSet(provider.eClass().getEStructuralFeature("testAttribute"), (Object)"someAttrib");
            provider.eSet(provider.eClass().getEStructuralFeature("testService1"), (Object)testService1);
            provider.eSet(provider.eClass().getEStructuralFeature("testService2"), (Object)testService2);
            testService1.eSet(testService1.eClass().getEStructuralFeature("foo"), (Object)"foo");
            testService2.eSet(testService2.eClass().getEStructuralFeature("bar"), (Object)"bar");
            testAdmin.setFriendlyName(provider.getId());
            testAdmin.eSet(testAdmin.eClass().getEStructuralFeature("testAdmin"), (Object)new BigInteger("1000"));
            Provider saved = this.nexus.save(provider);
            Mockito.clearInvocations((Object[])new NotificationAccumulator[]{SubscriptionTest.this.accumulator});
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SubscriptionTest.this.accumulator});
            ((Service)saved.eGet(provider.eClass().getEStructuralFeature("testService2"))).eSet(testService2.eClass().getEStructuralFeature("annotated"), (Object)"avalue");
            Metadata overwrite = (Metadata)((Service)saved.eGet(provider.eClass().getEStructuralFeature("testService2"))).getMetadata().get((Object)testService2.eClass().getEStructuralFeature("annotated"));
            Assertions.assertNull((Object)overwrite);
            overwrite = ProviderFactory.eINSTANCE.createMetadata();
            FeatureCustomMetadata fcm = ProviderFactory.eINSTANCE.createFeatureCustomMetadata();
            fcm.setName("test");
            fcm.setValue((Object)"Something different");
            fcm.setTimestamp(Instant.now());
            overwrite.getExtra().add((Object)fcm);
            ((Service)saved.eGet(provider.eClass().getEStructuralFeature("testService2"))).getMetadata().put((Object)testService2.eClass().getEStructuralFeature("annotated"), (Object)overwrite);
            Instant mark = Instant.now();
            Thread.sleep(100L);
            Provider toTest = this.nexus.save(saved);
            Metadata curMetadata = (Metadata)((Service)toTest.eGet(provider.eClass().getEStructuralFeature("testService2"))).getMetadata().get((Object)testService2.eClass().getEStructuralFeature("annotated"));
            System.err.println(mark);
            System.err.println(curMetadata.getTimestamp());
            Assertions.assertNotNull((Object)curMetadata);
            Assertions.assertTrue((boolean)curMetadata.getTimestamp().isAfter(mark));
            Assertions.assertNotEquals((Object)overwrite, (Object)curMetadata);
            Assertions.assertEquals((int)1, (int)curMetadata.getExtra().size());
            Assertions.assertEquals((Object)"test", (Object)((FeatureCustomMetadata)curMetadata.getExtra().get(0)).getName());
            Assertions.assertEquals((Object)fcm.getValue(), (Object)((FeatureCustomMetadata)curMetadata.getExtra().get(0)).getValue());
            String modelName = EMFUtil.getModelName((EClass)provider.eClass());
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).addResource(this.ePackage.getNsURI(), modelName, provider.getId(), "testService2", "annotated");
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).resourceValueUpdate(this.ePackage.getNsURI(), modelName, provider.getId(), "testService2", "annotated", String.class, null, (Object)"avalue", curMetadata.getTimestamp());
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).metadataValueUpdate(this.ePackage.getNsURI(), modelName, provider.getId(), "testService2", "annotated", null, Map.of("test", fcm.getValue(), "test2", "testMetadata2", "value", "avalue", "timestamp", curMetadata.getTimestamp()), curMetadata.getTimestamp());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SubscriptionTest.this.accumulator});
        }

        @Test
        void pushEObjectTestSimpleAttributeChangeWithRemoveOfExtraMetadata() throws IOException, InterruptedException {
            Provider provider = (Provider)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TemperatureSensor")));
            Service testService1 = (Service)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestService1")));
            Service testService2 = (Service)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestService2")));
            Admin testAdmin = (Admin)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestAdmin")));
            provider.setId("sensor");
            provider.setAdmin(testAdmin);
            provider.eSet(provider.eClass().getEStructuralFeature("testAttribute"), (Object)"someAttrib");
            provider.eSet(provider.eClass().getEStructuralFeature("testService1"), (Object)testService1);
            provider.eSet(provider.eClass().getEStructuralFeature("testService2"), (Object)testService2);
            testService1.eSet(testService1.eClass().getEStructuralFeature("foo"), (Object)"foo");
            testService2.eSet(testService2.eClass().getEStructuralFeature("bar"), (Object)"bar");
            testAdmin.setFriendlyName(provider.getId());
            testAdmin.eSet(testAdmin.eClass().getEStructuralFeature("testAdmin"), (Object)new BigInteger("1000"));
            Metadata metadata = ProviderFactory.eINSTANCE.createMetadata();
            testService1.getMetadata().put((Object)testService1.eClass().getEStructuralFeature("foo"), (Object)metadata);
            FeatureCustomMetadata fcm = ProviderFactory.eINSTANCE.createFeatureCustomMetadata();
            fcm.setName("test.meta.1");
            fcm.setValue((Object)"some Test");
            fcm.setTimestamp(Instant.now());
            metadata.getExtra().add((Object)fcm);
            fcm = ProviderFactory.eINSTANCE.createFeatureCustomMetadata();
            fcm.setName("test.meta.2");
            fcm.setValue((Object)2);
            fcm.setTimestamp(Instant.now());
            metadata.getExtra().add((Object)fcm);
            Provider saved = this.nexus.save(provider);
            Mockito.clearInvocations((Object[])new NotificationAccumulator[]{SubscriptionTest.this.accumulator});
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SubscriptionTest.this.accumulator});
            Metadata oldMetadata = (Metadata)((Service)saved.eGet(provider.eClass().getEStructuralFeature("testService1"))).getMetadata().get((Object)testService1.eClass().getEStructuralFeature("foo"));
            oldMetadata.getExtra().remove(1);
            Instant mark = Instant.now();
            Thread.sleep(100L);
            Instant oldMetadataTimestampToCompare = oldMetadata.getTimestamp();
            oldMetadata.setTimestamp(Instant.now());
            Thread.sleep(100L);
            Provider toTest = this.nexus.save(saved);
            Metadata curMetadata = (Metadata)((Service)toTest.eGet(provider.eClass().getEStructuralFeature("testService1"))).getMetadata().get((Object)testService1.eClass().getEStructuralFeature("foo"));
            System.err.println(mark);
            System.err.println(curMetadata.getTimestamp());
            Assertions.assertNotNull((Object)curMetadata);
            Assertions.assertTrue((boolean)curMetadata.getTimestamp().isAfter(mark));
            String modelName = EMFUtil.getModelName((EClass)provider.eClass());
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).resourceValueUpdate(this.ePackage.getNsURI(), modelName, provider.getId(), "testService1", "foo", String.class, (Object)"foo", (Object)"foo", curMetadata.getTimestamp());
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).metadataValueUpdate(this.ePackage.getNsURI(), modelName, provider.getId(), "testService1", "foo", Map.of("test.meta.1", "some Test", "test.meta.2", 2, "value", "foo", "timestamp", oldMetadataTimestampToCompare), Map.of("test.meta.1", "some Test", "value", "foo", "timestamp", curMetadata.getTimestamp()), curMetadata.getTimestamp());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SubscriptionTest.this.accumulator});
        }

        @Test
        void pushEObjectUpateAdminNotRemoved() throws IOException {
            Provider provider = (Provider)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TemperatureSensor")));
            provider.setId("sensor");
            Provider saved = this.nexus.save(provider);
            saved.setAdmin(null);
            Provider test = this.nexus.save(saved);
            Assertions.assertNotNull((Object)test.getAdmin());
        }

        @Test
        void pushEObjectTestAttributeUpdates() throws IOException {
            Provider provider = (Provider)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TemperatureSensor")));
            Service testService1 = (Service)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestService1")));
            Service testService2 = (Service)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestService2")));
            Admin testAdmin = (Admin)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestAdmin")));
            provider.setId("sensor");
            provider.setAdmin(testAdmin);
            provider.eSet(provider.eClass().getEStructuralFeature("testAttribute"), (Object)"someAttrib");
            provider.eSet(provider.eClass().getEStructuralFeature("testService1"), (Object)testService1);
            provider.eSet(provider.eClass().getEStructuralFeature("testService2"), (Object)testService2);
            testService1.eSet(testService1.eClass().getEStructuralFeature("foo"), (Object)"foo");
            testService2.eSet(testService2.eClass().getEStructuralFeature("bar"), (Object)"bar");
            testAdmin.setFriendlyName(provider.getId());
            testAdmin.eSet(testAdmin.eClass().getEStructuralFeature("testAdmin"), (Object)new BigInteger("1000"));
            Provider saved = this.nexus.save(provider);
            SubscriptionTest.verifyNewProviderNotification(SubscriptionTest.this.accumulator, saved);
            this.stripMetadata(saved);
            ((Service)saved.eGet(provider.eClass().getEStructuralFeature("testService1"))).eSet(testService1.eClass().getEStructuralFeature("foo"), (Object)"foo2");
            Provider modified = this.nexus.save(saved);
            this.verifyProviderUpdateNotification(SubscriptionTest.this.accumulator, saved, modified);
        }

        @Test
        void pushEObjectTestAttributeUpdatesMultiple() throws IOException {
            Provider provider = (Provider)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TemperatureSensor")));
            Service testService1 = (Service)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestService1")));
            Service testService2 = (Service)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestService2")));
            Admin testAdmin = (Admin)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestAdmin")));
            provider.setId("sensor");
            provider.setAdmin(testAdmin);
            provider.eSet(provider.eClass().getEStructuralFeature("testAttribute"), (Object)"someAttrib");
            provider.eSet(provider.eClass().getEStructuralFeature("testService1"), (Object)testService1);
            provider.eSet(provider.eClass().getEStructuralFeature("testService2"), (Object)testService2);
            testService1.eSet(testService1.eClass().getEStructuralFeature("foo"), (Object)"foo");
            testService2.eSet(testService2.eClass().getEStructuralFeature("bar"), (Object)"bar");
            testAdmin.setFriendlyName(provider.getId());
            testAdmin.eSet(testAdmin.eClass().getEStructuralFeature("testAdmin"), (Object)new BigInteger("1000"));
            Provider saved = this.nexus.save(provider);
            SubscriptionTest.verifyNewProviderNotification(SubscriptionTest.this.accumulator, saved);
            this.stripMetadata(saved);
            ((Service)saved.eGet(provider.eClass().getEStructuralFeature("testService1"))).eSet(testService1.eClass().getEStructuralFeature("foo"), (Object)"foo2");
            ((Service)saved.eGet(provider.eClass().getEStructuralFeature("testService2"))).eSet(testService2.eClass().getEStructuralFeature("bar"), (Object)"bar2");
            Provider modified = this.nexus.save(saved);
            this.verifyProviderUpdateNotification(SubscriptionTest.this.accumulator, saved, modified);
        }

        @Test
        void pushEObjectTestAttributeUpdatesMultipleWithServiceMap() throws IOException {
            DynamicProvider provider = (DynamicProvider)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("DynamicTemperatureSensor")));
            Service testService1 = (Service)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestService1")));
            Service testService2 = (Service)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestService2")));
            Service testService3 = (Service)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestService1")));
            Service testService4 = (Service)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestService2")));
            Admin testAdmin = (Admin)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestAdmin")));
            provider.setId("sensor");
            provider.setAdmin(testAdmin);
            provider.eSet(provider.eClass().getEStructuralFeature("testAttribute"), (Object)"someAttrib");
            provider.eSet(provider.eClass().getEStructuralFeature("testService1"), (Object)testService1);
            provider.eSet(provider.eClass().getEStructuralFeature("testService2"), (Object)testService2);
            provider.getServices().put((Object)"testService3", (Object)testService3);
            provider.getServices().put((Object)"testService4", (Object)testService4);
            testService1.eSet(testService1.eClass().getEStructuralFeature("foo"), (Object)"foo");
            testService2.eSet(testService2.eClass().getEStructuralFeature("bar"), (Object)"bar");
            testService3.eSet(testService3.eClass().getEStructuralFeature("foo"), (Object)"fizz");
            testService4.eSet(testService4.eClass().getEStructuralFeature("bar"), (Object)"buzz");
            testAdmin.setFriendlyName(provider.getId());
            testAdmin.eSet(testAdmin.eClass().getEStructuralFeature("testAdmin"), (Object)new BigInteger("1000"));
            DynamicProvider saved = (DynamicProvider)this.nexus.save((Provider)provider);
            SubscriptionTest.verifyNewProviderNotification(SubscriptionTest.this.accumulator, (Provider)saved);
            this.stripMetadata((Provider)saved);
            ((Service)saved.eGet(provider.eClass().getEStructuralFeature("testService1"))).eSet(testService1.eClass().getEStructuralFeature("foo"), (Object)"foo2");
            ((Service)saved.eGet(provider.eClass().getEStructuralFeature("testService2"))).eSet(testService2.eClass().getEStructuralFeature("bar"), (Object)"bar2");
            ((Service)saved.getServices().get((Object)"testService3")).eSet(testService1.eClass().getEStructuralFeature("foo"), (Object)"fizz2");
            ((Service)saved.getServices().get((Object)"testService4")).eSet(testService2.eClass().getEStructuralFeature("bar"), (Object)"buzz2");
            Provider modified = this.nexus.save((Provider)saved);
            this.verifyProviderUpdateNotification(SubscriptionTest.this.accumulator, (Provider)saved, modified);
        }

        @Test
        void pushEObjectTestAttributeRemove() throws IOException {
            Provider provider = (Provider)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TemperatureSensor")));
            Service testService1 = (Service)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestService1")));
            Service testService2 = (Service)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestService2")));
            Admin testAdmin = (Admin)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestAdmin")));
            provider.setId("sensor");
            provider.setAdmin(testAdmin);
            provider.eSet(provider.eClass().getEStructuralFeature("testAttribute"), (Object)"someAttrib");
            provider.eSet(provider.eClass().getEStructuralFeature("testService1"), (Object)testService1);
            provider.eSet(provider.eClass().getEStructuralFeature("testService2"), (Object)testService2);
            testService1.eSet(testService1.eClass().getEStructuralFeature("foo"), (Object)"foo");
            testService2.eSet(testService2.eClass().getEStructuralFeature("bar"), (Object)"bar");
            testAdmin.setFriendlyName(provider.getId());
            testAdmin.eSet(testAdmin.eClass().getEStructuralFeature("testAdmin"), (Object)new BigInteger("1000"));
            Provider saved = this.nexus.save(provider);
            SubscriptionTest.verifyNewProviderNotification(SubscriptionTest.this.accumulator, saved);
            this.stripMetadata(saved);
            ((Service)saved.eGet(provider.eClass().getEStructuralFeature("testService1"))).eUnset(testService1.eClass().getEStructuralFeature("foo"));
            Provider modified = this.nexus.save(saved);
            this.verifyProviderUpdateNotification(SubscriptionTest.this.accumulator, saved, modified);
        }

        @Test
        void pushEObjectTestAttributeWithMetadata() throws IOException {
            Provider provider = (Provider)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TemperatureSensor")));
            Service testService1 = (Service)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestService1")));
            Service testService2 = (Service)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestService2")));
            Admin testAdmin = (Admin)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestAdmin")));
            provider.setId("sensor");
            provider.setAdmin(testAdmin);
            provider.eSet(provider.eClass().getEStructuralFeature("testAttribute"), (Object)"someAttrib");
            provider.eSet(provider.eClass().getEStructuralFeature("testService1"), (Object)testService1);
            provider.eSet(provider.eClass().getEStructuralFeature("testService2"), (Object)testService2);
            testService1.eSet(testService1.eClass().getEStructuralFeature("foo"), (Object)"foo");
            testService2.eSet(testService2.eClass().getEStructuralFeature("bar"), (Object)"bar");
            testAdmin.setFriendlyName(provider.getId());
            testAdmin.eSet(testAdmin.eClass().getEStructuralFeature("testAdmin"), (Object)new BigInteger("1000"));
            Provider saved = this.nexus.save(provider);
            SubscriptionTest.verifyNewProviderNotification(SubscriptionTest.this.accumulator, saved);
            Metadata resourceMetadata = (Metadata)saved.getAdmin().getMetadata().get((Object)ProviderPackage.Literals.ADMIN__FRIENDLY_NAME);
            this.stripMetadata(saved);
            saved.getAdmin().getMetadata().put((Object)ProviderPackage.Literals.ADMIN__FRIENDLY_NAME, (Object)resourceMetadata);
            resourceMetadata.setTimestamp(Instant.now());
            saved.getAdmin().setFriendlyName("Something new");
            Provider modified = this.nexus.save(saved);
            this.verifyProviderUpdateNotification(SubscriptionTest.this.accumulator, saved, modified);
        }

        @Test
        void pushEObjectTestComplexResourceUpdates() throws IOException {
            Provider provider = (Provider)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TemperatureSensor")));
            Service testService1 = (Service)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestServiceWithComplex")));
            Service testService2 = (Service)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestService2")));
            Admin testAdmin = (Admin)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestAdmin")));
            provider.setId("sensor");
            provider.setAdmin(testAdmin);
            provider.eSet(provider.eClass().getEStructuralFeature("testAttribute"), (Object)"someAttrib");
            provider.eSet(provider.eClass().getEStructuralFeature("testService1"), (Object)testService1);
            provider.eSet(provider.eClass().getEStructuralFeature("testService2"), (Object)testService2);
            testService1.eSet(testService1.eClass().getEStructuralFeature("foo"), (Object)"foo");
            testService2.eSet(testService2.eClass().getEStructuralFeature("bar"), (Object)"bar");
            EObject fooBar = EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("FooBar")));
            fooBar.eSet(fooBar.eClass().getEStructuralFeature("test"), (Object)"foo");
            testService1.eSet(testService1.eClass().getEStructuralFeature("complexTest"), (Object)fooBar);
            testAdmin.setFriendlyName(provider.getId());
            testAdmin.eSet(testAdmin.eClass().getEStructuralFeature("testAdmin"), (Object)new BigInteger("1000"));
            Provider saved = this.nexus.save(provider);
            SubscriptionTest.verifyNewProviderNotification(SubscriptionTest.this.accumulator, saved);
            this.stripMetadata(saved);
            ((Service)saved.eGet(provider.eClass().getEStructuralFeature("testService1"))).eSet(testService1.eClass().getEStructuralFeature("foo"), (Object)"foo2");
            Provider modified = this.nexus.save(saved);
            this.verifyProviderUpdateNotification(SubscriptionTest.this.accumulator, saved, modified);
        }

        @Test
        void pushEObjectTestComplexResourceNoUpdate() throws IOException {
            Provider provider = (Provider)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TemperatureSensor")));
            Service testService1 = (Service)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestServiceWithComplex")));
            Service testService2 = (Service)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestService2")));
            Admin testAdmin = (Admin)EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("TestAdmin")));
            provider.setId("sensor");
            provider.setAdmin(testAdmin);
            provider.eSet(provider.eClass().getEStructuralFeature("testAttribute"), (Object)"someAttrib");
            provider.eSet(provider.eClass().getEStructuralFeature("testService1"), (Object)testService1);
            provider.eSet(provider.eClass().getEStructuralFeature("testService2"), (Object)testService2);
            testService1.eSet(testService1.eClass().getEStructuralFeature("foo"), (Object)"foo");
            testService2.eSet(testService2.eClass().getEStructuralFeature("bar"), (Object)"bar");
            EObject fooBar = EcoreUtil.create((EClass)((EClass)this.ePackage.getEClassifier("FooBar")));
            fooBar.eSet(fooBar.eClass().getEStructuralFeature("test"), (Object)"foo");
            testService1.eSet(testService1.eClass().getEStructuralFeature("complexTest"), (Object)fooBar);
            testAdmin.setFriendlyName(provider.getId());
            testAdmin.eSet(testAdmin.eClass().getEStructuralFeature("testAdmin"), (Object)new BigInteger("1000"));
            Provider saved = this.nexus.save(provider);
            SubscriptionTest.verifyNewProviderNotification(SubscriptionTest.this.accumulator, saved);
            Mockito.clearInvocations((Object[])new NotificationAccumulator[]{SubscriptionTest.this.accumulator});
            Provider modified = this.nexus.save((Provider)EcoreUtil.copy((EObject)saved));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SubscriptionTest.this.accumulator});
        }

        private void stripMetadata(Provider provider) {
            provider.eClass().getEAllReferences().stream().filter(ref -> ProviderPackage.Literals.SERVICE.isSuperTypeOf(ref.getEReferenceType())).filter(arg_0 -> ((Provider)provider).eIsSet(arg_0)).map(arg_0 -> ((Provider)provider).eGet(arg_0)).map(Service.class::cast).map(Service::getMetadata).forEach(List::clear);
        }

        private void verifyProviderUpdateNotification(NotificationAccumulator accumulator, Provider oldProvider, Provider newProvider) {
            EClass eClass = null;
            if (oldProvider == null && newProvider != null) {
                eClass = newProvider.eClass();
                ((NotificationAccumulator)Mockito.verify((Object)accumulator)).addProvider(this.ePackage.getNsURI(), newProvider.eClass().getName(), newProvider.getId());
            } else {
                eClass = oldProvider.eClass();
            }
            eClass.getEAllReferences().stream().filter(ea -> ea.getEContainingClass().getEPackage() != EcorePackage.eINSTANCE).filter(ref -> ProviderPackage.Literals.SERVICE.isSuperTypeOf(ref.getEReferenceType())).filter(ref -> ProviderPackage.Literals.SERVICE.isSuperTypeOf(ref.getEReferenceType())).forEach(ref -> this.verifyNotificationsForService(accumulator, oldProvider, newProvider, (EReference)ref));
            if (oldProvider != null && newProvider == null) {
                ((NotificationAccumulator)Mockito.verify((Object)accumulator)).removeProvider(this.ePackage.getNsURI(), eClass.getName(), oldProvider.getId());
            }
        }

        private void verifyNotificationsForService(NotificationAccumulator accumulator, Provider oldProvider, Provider newProvider, EReference ref) {
            Service newService;
            Service oldService = oldProvider == null ? null : (Service)oldProvider.eGet((EStructuralFeature)ref);
            Service service = newService = newProvider == null ? null : (Service)newProvider.eGet((EStructuralFeature)ref);
            if (oldService == null && newService != null) {
                SubscriptionTest.verifyNewServiceNottification(accumulator, newProvider, newService, ref.getName());
            } else if (newService == null && oldService != null) {
                SubscriptionTest.verifyServiceRemoveNottification(accumulator, newProvider, oldService, ref.getName());
            } else {
                SubscriptionTest.verifyServiceChangeNottification(accumulator, newProvider, oldService, newService, ref.getName());
            }
        }
    }

    @Nested
    public class BasicEventsTest {
        private static final String TEST_MODEL = "testmodel";
        private static final String TEST_PROVIDER = "testprovider";
        private static final String TEST_SERVICE = "testservice";
        private static final String TEST_SERVICE_2 = "testservice2";
        private static final String TEST_RESOURCE = "testValue";
        private static final String TEST_RESOURCE_2 = "testValue2";
        private static final String TEST_VALUE = "test";
        private static final String TEST_VALUE_2 = "test2";
        private final String TEST_MODEL_PKG = EMFUtil.constructPackageUri((String)"testmodel");

        @Test
        void basicTest() {
            ModelNexus nexus = new ModelNexus(SubscriptionTest.this.resourceSet, ProviderPackage.eINSTANCE, () -> SubscriptionTest.this.accumulator);
            Mockito.clearInvocations((Object[])new NotificationAccumulator[]{SubscriptionTest.this.accumulator});
            Instant now = Instant.now();
            EClass model = nexus.createModel(TEST_MODEL, now);
            EReference service = nexus.createService(model, TEST_SERVICE, now);
            EAttribute resource = nexus.createResource(service.getEReferenceType(), TEST_RESOURCE, String.class, now, null);
            Provider p = nexus.createProviderInstance(TEST_MODEL, TEST_PROVIDER, now);
            nexus.handleDataUpdate(p, service.getName(), service, service.getEReferenceType(), (EStructuralFeature)resource, (Object)TEST_VALUE, now);
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).addProvider(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER);
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).addService(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER, ProviderPackage.Literals.PROVIDER__ADMIN.getName());
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).addResource(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER, ProviderPackage.Literals.PROVIDER__ADMIN.getName(), ProviderPackage.Literals.ADMIN__FRIENDLY_NAME.getName());
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).resourceValueUpdate(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER, ProviderPackage.Literals.PROVIDER__ADMIN.getName(), ProviderPackage.Literals.ADMIN__FRIENDLY_NAME.getName(), String.class, null, (Object)TEST_PROVIDER, now);
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).metadataValueUpdate(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER, ProviderPackage.Literals.PROVIDER__ADMIN.getName(), ProviderPackage.Literals.ADMIN__FRIENDLY_NAME.getName(), null, Map.of("value", TEST_PROVIDER, "timestamp", now), now);
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).addResource(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER, ProviderPackage.Literals.PROVIDER__ADMIN.getName(), ProviderPackage.Literals.ADMIN__MODEL_PACKAGE_URI.getName());
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).addResource(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER, ProviderPackage.Literals.PROVIDER__ADMIN.getName(), ProviderPackage.Literals.ADMIN__MODEL.getName());
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).resourceValueUpdate(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER, ProviderPackage.Literals.PROVIDER__ADMIN.getName(), ProviderPackage.Literals.ADMIN__MODEL_PACKAGE_URI.getName(), String.class, null, (Object)model.getEPackage().getNsURI(), now);
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).resourceValueUpdate(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER, ProviderPackage.Literals.PROVIDER__ADMIN.getName(), ProviderPackage.Literals.ADMIN__MODEL.getName(), String.class, null, (Object)EMFUtil.getModelName((EClass)model), now);
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).metadataValueUpdate(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER, ProviderPackage.Literals.PROVIDER__ADMIN.getName(), ProviderPackage.Literals.ADMIN__MODEL_PACKAGE_URI.getName(), null, Map.of("value", model.getEPackage().getNsURI(), "timestamp", now), now);
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).metadataValueUpdate(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER, ProviderPackage.Literals.PROVIDER__ADMIN.getName(), ProviderPackage.Literals.ADMIN__MODEL.getName(), null, Map.of("value", EMFUtil.getModelName((EClass)model), "timestamp", now), now);
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).addService(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER, TEST_SERVICE);
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).addService(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER, TEST_SERVICE);
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).addResource(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER, TEST_SERVICE, TEST_RESOURCE);
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).resourceValueUpdate(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER, TEST_SERVICE, TEST_RESOURCE, String.class, null, (Object)TEST_VALUE, now);
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).metadataValueUpdate(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER, TEST_SERVICE, TEST_RESOURCE, null, Map.of("value", TEST_VALUE, "timestamp", now), now);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SubscriptionTest.this.accumulator});
        }

        @Test
        void basicServiceExtensionTest() {
            ModelNexus nexus = new ModelNexus(SubscriptionTest.this.resourceSet, ProviderPackage.eINSTANCE, () -> SubscriptionTest.this.accumulator);
            Mockito.clearInvocations((Object[])new NotificationAccumulator[]{SubscriptionTest.this.accumulator});
            Instant now = Instant.now();
            Instant before = now.minus(Duration.ofHours(1L));
            EClass model = nexus.createModel(TEST_MODEL, before);
            EReference service = nexus.createService(model, TEST_SERVICE, before);
            EAttribute resource = nexus.createResource(service.getEReferenceType(), TEST_RESOURCE, String.class, before, null);
            EAttribute resource2 = nexus.createResource(service.getEReferenceType(), TEST_RESOURCE_2, String.class, before, null);
            Provider p = nexus.createProviderInstance(TEST_MODEL, TEST_PROVIDER, before);
            nexus.handleDataUpdate(p, service.getName(), service, service.getEReferenceType(), (EStructuralFeature)resource, (Object)TEST_VALUE, before);
            nexus.handleDataUpdate(p, service.getName(), service, service.getEReferenceType(), (EStructuralFeature)resource2, (Object)TEST_VALUE, now);
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).addProvider(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER);
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).addService(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER, ProviderPackage.Literals.PROVIDER__ADMIN.getName());
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).addResource(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER, ProviderPackage.Literals.PROVIDER__ADMIN.getName(), ProviderPackage.Literals.ADMIN__FRIENDLY_NAME.getName());
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).resourceValueUpdate(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER, ProviderPackage.Literals.PROVIDER__ADMIN.getName(), ProviderPackage.Literals.ADMIN__FRIENDLY_NAME.getName(), String.class, null, (Object)TEST_PROVIDER, before);
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).metadataValueUpdate(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER, ProviderPackage.Literals.PROVIDER__ADMIN.getName(), ProviderPackage.Literals.ADMIN__FRIENDLY_NAME.getName(), null, Map.of("value", TEST_PROVIDER, "timestamp", before), before);
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).addResource(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER, ProviderPackage.Literals.PROVIDER__ADMIN.getName(), ProviderPackage.Literals.ADMIN__MODEL_PACKAGE_URI.getName());
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).addResource(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER, ProviderPackage.Literals.PROVIDER__ADMIN.getName(), ProviderPackage.Literals.ADMIN__MODEL.getName());
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).resourceValueUpdate(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER, ProviderPackage.Literals.PROVIDER__ADMIN.getName(), ProviderPackage.Literals.ADMIN__MODEL_PACKAGE_URI.getName(), String.class, null, (Object)model.getEPackage().getNsURI(), before);
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).resourceValueUpdate(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER, ProviderPackage.Literals.PROVIDER__ADMIN.getName(), ProviderPackage.Literals.ADMIN__MODEL.getName(), String.class, null, (Object)EMFUtil.getModelName((EClass)model), before);
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).metadataValueUpdate(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER, ProviderPackage.Literals.PROVIDER__ADMIN.getName(), ProviderPackage.Literals.ADMIN__MODEL_PACKAGE_URI.getName(), null, Map.of("value", model.getEPackage().getNsURI(), "timestamp", before), before);
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).metadataValueUpdate(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER, ProviderPackage.Literals.PROVIDER__ADMIN.getName(), ProviderPackage.Literals.ADMIN__MODEL.getName(), null, Map.of("value", EMFUtil.getModelName((EClass)model), "timestamp", before), before);
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).addService(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER, TEST_SERVICE);
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).addResource(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER, TEST_SERVICE, TEST_RESOURCE);
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).addResource(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER, TEST_SERVICE, TEST_RESOURCE_2);
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).resourceValueUpdate(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER, TEST_SERVICE, TEST_RESOURCE, String.class, null, (Object)TEST_VALUE, before);
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).resourceValueUpdate(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER, TEST_SERVICE, TEST_RESOURCE_2, String.class, null, (Object)TEST_VALUE, now);
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).metadataValueUpdate(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER, TEST_SERVICE, TEST_RESOURCE, null, Map.of("value", TEST_VALUE, "timestamp", before), before);
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).metadataValueUpdate(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER, TEST_SERVICE, TEST_RESOURCE_2, null, Map.of("value", TEST_VALUE, "timestamp", now), now);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SubscriptionTest.this.accumulator});
        }

        @Test
        void basicSecondServiceTest() {
            ModelNexus nexus = new ModelNexus(SubscriptionTest.this.resourceSet, ProviderPackage.eINSTANCE, () -> SubscriptionTest.this.accumulator);
            Mockito.clearInvocations((Object[])new NotificationAccumulator[]{SubscriptionTest.this.accumulator});
            Instant now = Instant.now();
            Instant before = now.minus(Duration.ofHours(1L));
            EClass model = nexus.createModel(TEST_MODEL, before);
            EReference service = nexus.createService(model, TEST_SERVICE, before);
            EReference service2 = nexus.createService(model, TEST_SERVICE_2, before);
            EAttribute resource = nexus.createResource(service.getEReferenceType(), TEST_RESOURCE, String.class, before, null);
            EAttribute resource2 = nexus.createResource(service2.getEReferenceType(), TEST_RESOURCE_2, String.class, before, null);
            Provider p = nexus.createProviderInstance(TEST_MODEL, TEST_PROVIDER, before);
            nexus.handleDataUpdate(p, service.getName(), service, service.getEReferenceType(), (EStructuralFeature)resource, (Object)TEST_VALUE, before);
            nexus.handleDataUpdate(p, service2.getName(), service2, service2.getEReferenceType(), (EStructuralFeature)resource2, (Object)TEST_VALUE_2, now);
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).addProvider(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER);
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).addService(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER, ProviderPackage.Literals.PROVIDER__ADMIN.getName());
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).addResource(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER, ProviderPackage.Literals.PROVIDER__ADMIN.getName(), ProviderPackage.Literals.ADMIN__FRIENDLY_NAME.getName());
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).resourceValueUpdate(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER, ProviderPackage.Literals.PROVIDER__ADMIN.getName(), ProviderPackage.Literals.ADMIN__FRIENDLY_NAME.getName(), String.class, null, (Object)TEST_PROVIDER, before);
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).metadataValueUpdate(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER, ProviderPackage.Literals.PROVIDER__ADMIN.getName(), ProviderPackage.Literals.ADMIN__FRIENDLY_NAME.getName(), null, Map.of("value", TEST_PROVIDER, "timestamp", before), before);
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).addResource(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER, ProviderPackage.Literals.PROVIDER__ADMIN.getName(), ProviderPackage.Literals.ADMIN__MODEL_PACKAGE_URI.getName());
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).addResource(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER, ProviderPackage.Literals.PROVIDER__ADMIN.getName(), ProviderPackage.Literals.ADMIN__MODEL.getName());
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).resourceValueUpdate(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER, ProviderPackage.Literals.PROVIDER__ADMIN.getName(), ProviderPackage.Literals.ADMIN__MODEL_PACKAGE_URI.getName(), String.class, null, (Object)model.getEPackage().getNsURI(), before);
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).resourceValueUpdate(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER, ProviderPackage.Literals.PROVIDER__ADMIN.getName(), ProviderPackage.Literals.ADMIN__MODEL.getName(), String.class, null, (Object)EMFUtil.getModelName((EClass)model), before);
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).metadataValueUpdate(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER, ProviderPackage.Literals.PROVIDER__ADMIN.getName(), ProviderPackage.Literals.ADMIN__MODEL_PACKAGE_URI.getName(), null, Map.of("value", model.getEPackage().getNsURI(), "timestamp", before), before);
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).metadataValueUpdate(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER, ProviderPackage.Literals.PROVIDER__ADMIN.getName(), ProviderPackage.Literals.ADMIN__MODEL.getName(), null, Map.of("value", EMFUtil.getModelName((EClass)model), "timestamp", before), before);
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).addService(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER, TEST_SERVICE);
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).addService(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER, TEST_SERVICE_2);
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).addResource(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER, TEST_SERVICE, TEST_RESOURCE);
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).addResource(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER, TEST_SERVICE_2, TEST_RESOURCE_2);
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).resourceValueUpdate(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER, TEST_SERVICE, TEST_RESOURCE, String.class, null, (Object)TEST_VALUE, before);
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).resourceValueUpdate(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER, TEST_SERVICE_2, TEST_RESOURCE_2, String.class, null, (Object)TEST_VALUE_2, now);
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).metadataValueUpdate(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER, TEST_SERVICE, TEST_RESOURCE, null, Map.of("value", TEST_VALUE, "timestamp", before), before);
            ((NotificationAccumulator)Mockito.verify((Object)SubscriptionTest.this.accumulator)).metadataValueUpdate(this.TEST_MODEL_PKG, TEST_MODEL, TEST_PROVIDER, TEST_SERVICE_2, TEST_RESOURCE_2, null, Map.of("value", TEST_VALUE_2, "timestamp", now), now);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SubscriptionTest.this.accumulator});
        }
    }
}

