/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.twin.impl;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.URIMappingRegistryImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.sensinact.core.command.impl.ActionHandler;
import org.eclipse.sensinact.core.emf.twin.SensinactEMFProvider;
import org.eclipse.sensinact.core.emf.util.EMFTestUtil;
import org.eclipse.sensinact.core.model.ResourceType;
import org.eclipse.sensinact.core.model.ServiceBuilder;
import org.eclipse.sensinact.core.model.impl.SensinactModelManagerImpl;
import org.eclipse.sensinact.core.model.nexus.ModelNexus;
import org.eclipse.sensinact.core.model.nexus.emf.EMFUtil;
import org.eclipse.sensinact.core.notification.NotificationAccumulator;
import org.eclipse.sensinact.core.snapshot.ProviderSnapshot;
import org.eclipse.sensinact.core.snapshot.ResourceSnapshot;
import org.eclipse.sensinact.core.snapshot.ServiceSnapshot;
import org.eclipse.sensinact.core.twin.SensinactProvider;
import org.eclipse.sensinact.core.twin.SensinactResource;
import org.eclipse.sensinact.core.twin.SensinactService;
import org.eclipse.sensinact.core.twin.TimedValue;
import org.eclipse.sensinact.core.twin.impl.SensinactDigitalTwinImpl;
import org.eclipse.sensinact.core.twin.impl.SensinactResourceImpl;
import org.eclipse.sensinact.model.core.provider.Admin;
import org.eclipse.sensinact.model.core.provider.DynamicProvider;
import org.eclipse.sensinact.model.core.provider.Provider;
import org.eclipse.sensinact.model.core.provider.ProviderPackage;
import org.eclipse.sensinact.model.core.provider.Service;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseFactory;

@ExtendWith(value={MockitoExtension.class})
public class SensinactTwinTest {
    private static final String TEST_MODEL = "testmodel";
    private static final String TEST_MODEL_WITH_METADATA = "testmodel_Metadata";
    private static final String TEST_PROVIDER = "testprovider";
    private static final String TEST_SERVICE = "testservice";
    private static final String TEST_RESOURCE = "testValue";
    private static final String TEST_ACTION_RESOURCE = "testAction";
    @Mock
    NotificationAccumulator accumulator;
    @Mock
    ActionHandler actionHandler;
    private PromiseFactory promiseFactory = new PromiseFactory(PromiseFactory.inlineExecutor());
    private ResourceSet resourceSet;
    private ModelNexus nexus;
    private SensinactModelManagerImpl manager;
    private SensinactDigitalTwinImpl twinImpl;
    private EPackage ePackage;

    @BeforeEach
    void start() throws IOException {
        this.resourceSet = EMFTestUtil.createResourceSet();
        this.nexus = new ModelNexus(this.resourceSet, ProviderPackage.eINSTANCE, () -> this.accumulator, this.actionHandler);
        this.manager = new SensinactModelManagerImpl(this.nexus);
        this.twinImpl = new SensinactDigitalTwinImpl(this.nexus, this.promiseFactory);
        ((ServiceBuilder)this.manager.createModel(TEST_MODEL).withService(TEST_SERVICE).withResource(TEST_RESOURCE).withType(Integer.class).build()).withResource(TEST_ACTION_RESOURCE).withType(Double.class).withAction(List.of(new AbstractMap.SimpleEntry<String, Class<String>>("foo", String.class), new AbstractMap.SimpleEntry<String, Class<Instant>>("bar", Instant.class))).buildAll();
        ((ServiceBuilder)this.manager.createModel(TEST_MODEL_WITH_METADATA).withService(TEST_SERVICE).withResource(TEST_RESOURCE).withType(Integer.class).withDefaultMetadata(Map.of("foo", "bar")).build()).withResource(TEST_ACTION_RESOURCE).withType(Double.class).withAction(List.of(new AbstractMap.SimpleEntry<String, Class<String>>("foo", String.class), new AbstractMap.SimpleEntry<String, Class<Instant>>("bar", Instant.class))).withDefaultMetadata(Map.of("fizz", "buzz")).buildAll();
        final URI ProviderPackageURI = URI.createURI((String)"https://eclipse.org/sensinact/core/provider/1.0");
        URIMappingRegistryImpl.INSTANCE.put((Object)URI.createURI((String)"https://eclipse.org/../../../models/src/main/resources/model/sensinact.ecore"), (Object)ProviderPackageURI);
        XMLResource.URIHandler handler = new XMLResource.URIHandler(){

            public URI deresolve(URI arg0) {
                return arg0;
            }

            public URI resolve(URI arg0) {
                if (arg0.lastSegment().equals("sensinact.ecore")) {
                    return ProviderPackageURI.appendFragment(arg0.fragment());
                }
                return arg0;
            }

            public void setBaseURI(URI arg0) {
            }
        };
        Resource extendedPackageResource = this.resourceSet.createResource(URI.createURI((String)"https://eclipse.org/sensinact/test/1.0"));
        InputStream \u00edn = this.getClass().getResourceAsStream("/model/extended.ecore");
        Assertions.assertNotNull((Object)\u00edn);
        extendedPackageResource.load(\u00edn, Collections.singletonMap("URI_HANDLER", handler));
        this.ePackage = (EPackage)extendedPackageResource.getContents().get(0);
        Assertions.assertNotNull((Object)this.ePackage);
    }

    @Nested
    public class FilterTests {
        @Test
        void simpleEmptyFilter() {
            List list = SensinactTwinTest.this.twinImpl.filteredSnapshot(null, null, null, null);
            Assertions.assertEquals((int)1, (int)list.size());
            SensinactTwinTest.this.twinImpl.createProvider(SensinactTwinTest.TEST_MODEL, SensinactTwinTest.TEST_PROVIDER);
            list = SensinactTwinTest.this.twinImpl.filteredSnapshot(null, null, null, null);
            Assertions.assertEquals((int)2, (int)list.size());
        }

        @Test
        void simpleProviderNameFilter() {
            SensinactTwinTest.this.twinImpl.createProvider(SensinactTwinTest.TEST_MODEL, SensinactTwinTest.TEST_PROVIDER);
            List list = SensinactTwinTest.this.twinImpl.filteredSnapshot(null, p -> "foo".equals(p.getName()), null, null);
            Assertions.assertTrue((boolean)list.isEmpty());
            list = SensinactTwinTest.this.twinImpl.filteredSnapshot(null, p -> SensinactTwinTest.TEST_PROVIDER.equals(p.getName()), null, null);
            Assertions.assertEquals((int)1, (int)list.size());
        }

        @Test
        void testSnapshotProviderDefaultMetadata() throws InvocationTargetException, InterruptedException {
            SensinactTwinTest.this.twinImpl.createProvider(SensinactTwinTest.TEST_MODEL_WITH_METADATA, SensinactTwinTest.TEST_PROVIDER);
            List list = SensinactTwinTest.this.twinImpl.filteredSnapshot(null, p -> SensinactTwinTest.TEST_PROVIDER.equals(p.getName()), null, null);
            Assertions.assertEquals((int)1, (int)list.size());
            ResourceSnapshot rs = ((ProviderSnapshot)list.get(0)).getServices().stream().filter(s -> SensinactTwinTest.TEST_SERVICE.equals(s.getName())).flatMap(s -> s.getResources().stream()).filter(r -> SensinactTwinTest.TEST_RESOURCE.equals(r.getName())).findFirst().get();
            Map metadata = rs.getMetadata();
            Assertions.assertEquals(Set.of("foo", "timestamp"), metadata.keySet());
            Assertions.assertEquals((Object)"bar", metadata.get("foo"));
            Assertions.assertNull(metadata.get("timestamp"));
            rs = ((ProviderSnapshot)list.get(0)).getServices().stream().filter(s -> SensinactTwinTest.TEST_SERVICE.equals(s.getName())).flatMap(s -> s.getResources().stream()).filter(r -> SensinactTwinTest.TEST_ACTION_RESOURCE.equals(r.getName())).findFirst().get();
            metadata = rs.getMetadata();
            Assertions.assertEquals(Set.of("fizz", "timestamp"), metadata.keySet());
            Assertions.assertEquals((Object)"buzz", metadata.get("fizz"));
            Assertions.assertNull(metadata.get("timestamp"));
        }

        @Test
        void simpleResourceValueFilter() throws Exception {
            SensinactTwinTest.this.twinImpl.createProvider(SensinactTwinTest.TEST_MODEL, SensinactTwinTest.TEST_PROVIDER);
            SensinactTwinTest.this.twinImpl.getResource(SensinactTwinTest.TEST_PROVIDER, SensinactTwinTest.TEST_SERVICE, SensinactTwinTest.TEST_RESOURCE).setValue((Object)5).getValue();
            Predicate<ResourceSnapshot> p = r -> SensinactTwinTest.TEST_RESOURCE.equals(r.getName());
            List list = SensinactTwinTest.this.twinImpl.filteredSnapshot(null, null, null, p);
            Assertions.assertEquals((int)1, (int)list.size());
            Assertions.assertEquals((int)2, (int)((ProviderSnapshot)list.get(0)).getServices().size());
            ServiceSnapshot serviceSnapshot = ((ProviderSnapshot)list.get(0)).getServices().stream().filter(s -> SensinactTwinTest.TEST_SERVICE.equals(s.getName())).findFirst().get();
            Assertions.assertEquals((Object)5, (Object)((ResourceSnapshot)serviceSnapshot.getResources().get(0)).getValue().getValue());
        }

        @Test
        void simpleResourceValueFilterWithDynamicResource() throws Exception {
            DynamicProvider provider = (DynamicProvider)EcoreUtil.create((EClass)((EClass)SensinactTwinTest.this.ePackage.getEClassifier("DynamicTemperatureSensor")));
            Service testService1 = (Service)EcoreUtil.create((EClass)((EClass)SensinactTwinTest.this.ePackage.getEClassifier("TestService1")));
            Service testService2 = (Service)EcoreUtil.create((EClass)((EClass)SensinactTwinTest.this.ePackage.getEClassifier("TestService1")));
            Admin testAdmin = (Admin)EcoreUtil.create((EClass)((EClass)SensinactTwinTest.this.ePackage.getEClassifier("TestAdmin")));
            provider.setId("sensor");
            provider.setAdmin(testAdmin);
            provider.eSet(provider.eClass().getEStructuralFeature("testAttribute"), (Object)"someAttrib");
            provider.eSet(provider.eClass().getEStructuralFeature("testService1"), (Object)testService1);
            provider.getServices().put((Object)SensinactTwinTest.TEST_SERVICE, (Object)testService2);
            testService1.eSet(testService1.eClass().getEStructuralFeature("foo"), (Object)"foo");
            testService2.eSet(testService2.eClass().getEStructuralFeature("foo"), (Object)"fizz");
            testAdmin.setFriendlyName(provider.getId());
            testAdmin.eSet(testAdmin.eClass().getEStructuralFeature("testAdmin"), (Object)new BigInteger("1000"));
            SensinactTwinTest.this.nexus.save((Provider)provider);
            Predicate<ResourceSnapshot> p = r -> "foo".equals(r.getName());
            List list = SensinactTwinTest.this.twinImpl.filteredSnapshot(null, null, null, p);
            Assertions.assertEquals((int)1, (int)list.size());
            Assertions.assertEquals((int)4, (int)((ProviderSnapshot)list.get(0)).getServices().size());
            ServiceSnapshot serviceSnapshot = ((ProviderSnapshot)list.get(0)).getServices().stream().filter(s -> SensinactTwinTest.TEST_SERVICE.equals(s.getName())).findFirst().get();
            Assertions.assertEquals((Object)"fizz", (Object)((ResourceSnapshot)serviceSnapshot.getResources().get(0)).getValue().getValue());
        }
    }

    @Nested
    public class ProviderTests {
        @Test
        void testEmptyModelNexus() {
            Assertions.assertEquals(List.of("sensiNact"), SensinactTwinTest.this.twinImpl.getProviders().stream().map(SensinactProvider::getName).collect(Collectors.toList()));
        }

        @Test
        void testCreateProvider() {
            SensinactEMFProvider provider = SensinactTwinTest.this.twinImpl.createProvider(SensinactTwinTest.TEST_MODEL, SensinactTwinTest.TEST_PROVIDER);
            Assertions.assertEquals((Object)SensinactTwinTest.TEST_MODEL, (Object)provider.getModelName());
            Assertions.assertEquals((Object)SensinactTwinTest.TEST_PROVIDER, (Object)provider.getName());
            Assertions.assertEquals(Set.of(SensinactTwinTest.TEST_SERVICE, "admin"), provider.getServices().keySet());
            Assertions.assertEquals(Set.of(SensinactTwinTest.TEST_RESOURCE, SensinactTwinTest.TEST_ACTION_RESOURCE), ((SensinactService)provider.getServices().get(SensinactTwinTest.TEST_SERVICE)).getResources().keySet());
        }

        @Test
        void testMetadataWithoutValue() throws Exception {
            SensinactTwinTest.this.twinImpl.createProvider(SensinactTwinTest.TEST_MODEL, SensinactTwinTest.TEST_PROVIDER);
            SensinactResourceImpl rc = SensinactTwinTest.this.twinImpl.getResource(SensinactTwinTest.TEST_PROVIDER, SensinactTwinTest.TEST_SERVICE, SensinactTwinTest.TEST_RESOURCE);
            rc.setMetadataValue("description", (Object)"test", Instant.now()).getValue();
            Assertions.assertEquals((Object)"test", (Object)((TimedValue)rc.getMetadataValue("description").getValue()).getValue());
        }

        @Test
        void testCreateProviderDefaultMetadata() throws InvocationTargetException, InterruptedException {
            SensinactEMFProvider provider = SensinactTwinTest.this.twinImpl.createProvider(SensinactTwinTest.TEST_MODEL_WITH_METADATA, SensinactTwinTest.TEST_PROVIDER);
            SensinactService service = (SensinactService)provider.getServices().get(SensinactTwinTest.TEST_SERVICE);
            SensinactResource resource = (SensinactResource)service.getResources().get(SensinactTwinTest.TEST_RESOURCE);
            Map metadata = (Map)resource.getMetadataValues().getValue();
            Assertions.assertEquals(Set.of("foo", "timestamp"), metadata.keySet());
            Assertions.assertEquals((Object)"bar", metadata.get("foo"));
            Assertions.assertNull(metadata.get("timestamp"));
            TimedValue metadataValue = (TimedValue)resource.getMetadataValue("foo").getValue();
            Assertions.assertEquals((Object)"bar", (Object)metadataValue.getValue());
            Assertions.assertNull((Object)metadataValue.getTimestamp());
            resource = (SensinactResource)service.getResources().get(SensinactTwinTest.TEST_ACTION_RESOURCE);
            metadata = (Map)resource.getMetadataValues().getValue();
            Assertions.assertEquals(Set.of("fizz", "timestamp"), metadata.keySet());
            Assertions.assertEquals((Object)"buzz", metadata.get("fizz"));
            Assertions.assertNull(metadata.get("timestamp"));
            metadataValue = (TimedValue)resource.getMetadataValue("fizz").getValue();
            Assertions.assertEquals((Object)"buzz", (Object)metadataValue.getValue());
            Assertions.assertNull((Object)metadataValue.getTimestamp());
        }

        @Test
        void testOverrideProviderDefaultMetadata() throws InvocationTargetException, InterruptedException {
            SensinactEMFProvider provider = SensinactTwinTest.this.twinImpl.createProvider(SensinactTwinTest.TEST_MODEL_WITH_METADATA, SensinactTwinTest.TEST_PROVIDER);
            SensinactService service = (SensinactService)provider.getServices().get(SensinactTwinTest.TEST_SERVICE);
            SensinactResource resource = (SensinactResource)service.getResources().get(SensinactTwinTest.TEST_RESOURCE);
            Instant timestamp = Instant.parse("2020-01-01T00:00:00Z");
            resource.setMetadataValue("extra", (Object)42, timestamp).getValue();
            Map metadata = (Map)resource.getMetadataValues().getValue();
            Assertions.assertEquals(Set.of("foo", "timestamp", "extra"), metadata.keySet());
            Assertions.assertEquals((Object)"bar", metadata.get("foo"));
            Assertions.assertEquals((Object)42, metadata.get("extra"));
            Assertions.assertNull(metadata.get("timestamp"));
            TimedValue metadataValue = (TimedValue)resource.getMetadataValue("foo").getValue();
            Assertions.assertEquals((Object)"bar", (Object)metadataValue.getValue());
            Assertions.assertNull((Object)metadataValue.getTimestamp());
            metadataValue = (TimedValue)resource.getMetadataValue("extra").getValue();
            Assertions.assertEquals((Object)42, (Object)metadataValue.getValue());
            Assertions.assertEquals((Object)timestamp, (Object)metadataValue.getTimestamp());
            resource = (SensinactResource)service.getResources().get(SensinactTwinTest.TEST_ACTION_RESOURCE);
            resource.setMetadataValue("fizz", (Object)42, timestamp).getValue();
            metadata = (Map)resource.getMetadataValues().getValue();
            Assertions.assertEquals(Set.of("fizz", "timestamp"), metadata.keySet());
            Assertions.assertEquals((Object)42, metadata.get("fizz"));
            Assertions.assertNull(metadata.get("timestamp"));
            metadataValue = (TimedValue)resource.getMetadataValue("fizz").getValue();
            Assertions.assertEquals((Object)42, (Object)metadataValue.getValue());
            Assertions.assertEquals((Object)timestamp, (Object)metadataValue.getTimestamp());
        }

        @Test
        void basicResourceSet() throws Exception {
            SensinactTwinTest.this.twinImpl.createProvider(SensinactTwinTest.TEST_MODEL, SensinactTwinTest.TEST_PROVIDER);
            SensinactResourceImpl resource = SensinactTwinTest.this.twinImpl.getResource(SensinactTwinTest.TEST_PROVIDER, SensinactTwinTest.TEST_SERVICE, SensinactTwinTest.TEST_RESOURCE);
            Assertions.assertEquals(Integer.class, (Object)resource.getType());
            Assertions.assertEquals((Object)ResourceType.SENSOR, (Object)resource.getResourceType());
            Promise value = resource.getValue();
            Assertions.assertEquals(null, (Object)((TimedValue)value.getValue()).getValue());
            Assertions.assertEquals(null, (Object)((TimedValue)value.getValue()).getTimestamp());
            Instant timestamp = Instant.parse("2023-02-14T15:00:00.000Z");
            resource.setValue((Object)42, timestamp);
            value = resource.getValue();
            Assertions.assertEquals((Object)42, (Object)((TimedValue)value.getValue()).getValue());
            Assertions.assertEquals((Object)timestamp, (Object)((TimedValue)value.getValue()).getTimestamp());
        }

        @Test
        void basicActionResource() throws Exception {
            SensinactTwinTest.this.twinImpl.createProvider(SensinactTwinTest.TEST_MODEL, SensinactTwinTest.TEST_PROVIDER);
            SensinactResourceImpl resource = SensinactTwinTest.this.twinImpl.getResource(SensinactTwinTest.TEST_PROVIDER, SensinactTwinTest.TEST_SERVICE, SensinactTwinTest.TEST_ACTION_RESOURCE);
            Assertions.assertEquals(Double.class, (Object)resource.getType());
            Assertions.assertEquals((Object)ResourceType.ACTION, (Object)resource.getResourceType());
            Promise value = resource.getValue();
            Assertions.assertEquals(IllegalArgumentException.class, value.getFailure().getClass());
            Assertions.assertEquals(List.of(new AbstractMap.SimpleEntry<String, Class<String>>("foo", String.class), new AbstractMap.SimpleEntry<String, Class<Instant>>("bar", Instant.class)), (Object)resource.getArguments());
            Map<String, Instant> arguments = Map.of("foo", "bar", "foobar", Instant.now());
            Mockito.when((Object)SensinactTwinTest.this.actionHandler.act(EMFUtil.constructPackageUri((String)SensinactTwinTest.TEST_MODEL), SensinactTwinTest.TEST_MODEL, SensinactTwinTest.TEST_PROVIDER, SensinactTwinTest.TEST_SERVICE, SensinactTwinTest.TEST_ACTION_RESOURCE, arguments)).thenReturn((Object)SensinactTwinTest.this.promiseFactory.resolved((Object)4.2).delay(1000L));
            Promise act = resource.act(arguments);
            Assertions.assertFalse((boolean)act.isDone());
            Assertions.assertEquals((Object)4.2, (Object)act.getValue());
        }
    }
}

