/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.tx.control.jdbc.local.impl;

import java.sql.Driver;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.apache.aries.tx.control.jdbc.common.impl.AbstractInternalJDBCConnectionProviderFactory;
import org.apache.aries.tx.control.jdbc.common.impl.AbstractJDBCConnectionProvider;
import org.apache.aries.tx.control.jdbc.common.impl.DriverDataSource;
import org.apache.aries.tx.control.jdbc.local.impl.JDBCConnectionProviderImpl;
import org.osgi.service.jdbc.DataSourceFactory;
import org.osgi.service.transaction.control.TransactionException;

public class JDBCConnectionProviderFactoryImpl
extends AbstractInternalJDBCConnectionProviderFactory {
    @Override
    public AbstractJDBCConnectionProvider getProviderFor(DataSourceFactory dsf, Properties jdbcProperties, Map<String, Object> resourceProviderProperties) {
        DataSource unpooled;
        this.checkEnlistment(resourceProviderProperties);
        try {
            unpooled = JDBCConnectionProviderFactoryImpl.toBoolean(resourceProviderProperties, "osgi.use.driver", false) ? new DriverDataSource(dsf.createDriver(null), jdbcProperties.getProperty("url"), jdbcProperties) : dsf.createDataSource(jdbcProperties);
        }
        catch (SQLException sqle) {
            throw new TransactionException("Unable to create the JDBC resource provider", (Throwable)sqle);
        }
        DataSource toUse = this.poolIfNecessary(resourceProviderProperties, unpooled);
        return new JDBCConnectionProviderImpl(toUse);
    }

    @Override
    public AbstractJDBCConnectionProvider getProviderFor(DataSource ds, Map<String, Object> resourceProviderProperties) {
        this.checkEnlistment(resourceProviderProperties);
        DataSource toUse = this.poolIfNecessary(resourceProviderProperties, ds);
        return new JDBCConnectionProviderImpl(toUse);
    }

    @Override
    public AbstractJDBCConnectionProvider getProviderFor(Driver driver, Properties jdbcProperties, Map<String, Object> resourceProviderProperties) {
        this.checkEnlistment(resourceProviderProperties);
        DataSource toUse = this.poolIfNecessary(resourceProviderProperties, new DriverDataSource(driver, jdbcProperties.getProperty("url"), jdbcProperties));
        return new JDBCConnectionProviderImpl(toUse);
    }

    @Override
    public AbstractJDBCConnectionProvider getProviderFor(XADataSource ds, Map<String, Object> resourceProviderProperties) {
        this.checkEnlistment(resourceProviderProperties);
        if (!(ds instanceof DataSource)) {
            throw new TransactionException("This resource Provider does not support XA transactions, and the supplied XADataSource is not a DataSource");
        }
        DataSource unpooled = (DataSource)((Object)ds);
        return new JDBCConnectionProviderImpl(this.poolIfNecessary(resourceProviderProperties, unpooled));
    }

    private void checkEnlistment(Map<String, Object> resourceProviderProperties) {
        if (JDBCConnectionProviderFactoryImpl.toBoolean(resourceProviderProperties, "osgi.xa.enabled", false)) {
            throw new TransactionException("This Resource Provider does not support XA transactions");
        }
        if (!JDBCConnectionProviderFactoryImpl.toBoolean(resourceProviderProperties, "osgi.local.enabled", true)) {
            throw new TransactionException("This Resource Provider always enlists in local transactions as it does not support XA");
        }
    }
}

