/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.commands.gogo;

import java.util.Map;
import org.apache.felix.service.command.Descriptor;
import org.apache.felix.service.command.annotations.GogoCommand;
import org.eclipse.sensinact.core.twin.TimedValue;
import org.eclipse.sensinact.gateway.commands.gogo.SensiNactCommandSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={MetaCommands.class})
@GogoCommand(scope="sna", function={"meta"})
public class MetaCommands {
    @Reference
    private SensiNactCommandSession session;

    @Descriptor(value="List all the metadata properties for a resource")
    public MetaDTO meta(@Descriptor(value="the provider ID") String provider, @Descriptor(value="the service ID") String service, @Descriptor(value="the resource ID") String resource) {
        Map metadata = this.session.get().getResourceMetadata(provider, service, resource);
        MetaDTO dto = new MetaDTO();
        dto.provider = provider;
        dto.service = service;
        dto.resource = resource;
        dto.metadata = metadata;
        return dto;
    }

    @Descriptor(value="Get the value of a resource's metadata")
    public String meta(@Descriptor(value="the provider ID") String provider, @Descriptor(value="the service ID") String service, @Descriptor(value="the resource ID") String resource, @Descriptor(value="the metadata property to get") String metadata) {
        TimedValue data = this.session.get().getResourceMetadataValue(provider, service, resource, metadata);
        if (data == null) {
            return "<NULL>";
        }
        return data.toString();
    }

    @Descriptor(value="Set the metadata value of a resource")
    public String meta(@Descriptor(value="the provider ID") String provider, @Descriptor(value="the service ID") String service, @Descriptor(value="the resource ID") String resource, @Descriptor(value="the metadata property") String metadata, @Descriptor(value="the value to set") Object value) {
        this.session.get().setResourceMetadata(provider, service, resource, metadata, value);
        return provider + "/" + service + "/" + resource + " \u2192 " + metadata + " = " + value;
    }

    public static class MetaDTO {
        public String provider;
        public String service;
        public String resource;
        public Map<String, Object> metadata;
    }
}

