/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.northbound.query.test.integration;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.sensinact.core.push.DataUpdate;
import org.eclipse.sensinact.core.push.dto.GenericDto;
import org.eclipse.sensinact.northbound.query.api.AbstractQueryDTO;
import org.eclipse.sensinact.northbound.query.api.AbstractResultDTO;
import org.eclipse.sensinact.northbound.query.api.EResultType;
import org.eclipse.sensinact.northbound.query.api.IQueryHandler;
import org.eclipse.sensinact.northbound.query.dto.SensinactPath;
import org.eclipse.sensinact.northbound.query.dto.query.QueryDescribeDTO;
import org.eclipse.sensinact.northbound.query.dto.query.QueryListDTO;
import org.eclipse.sensinact.northbound.query.dto.result.CompleteProviderDescriptionDTO;
import org.eclipse.sensinact.northbound.query.dto.result.MetadataDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ResponseDescribeProviderDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ResponseDescribeResourceDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ResponseDescribeServiceDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ResultDescribeProvidersDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ResultListProvidersDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ResultListResourcesDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ResultListServicesDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ShortResourceDescriptionDTO;
import org.eclipse.sensinact.northbound.query.dto.result.TypedResponse;
import org.eclipse.sensinact.northbound.query.test.integration.TestUtils;
import org.eclipse.sensinact.northbound.security.api.UserInfo;
import org.eclipse.sensinact.northbound.session.SensiNactSession;
import org.eclipse.sensinact.northbound.session.SensiNactSessionManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.osgi.annotation.bundle.Requirement;
import org.osgi.test.common.annotation.InjectService;
import org.osgi.test.common.annotation.Property;
import org.osgi.test.common.annotation.config.WithConfiguration;

@WithConfiguration(pid="sensinact.session.manager", properties={@Property(key="auth.policy", value={"ALLOW_ALL"})})
@Requirement(namespace="osgi.service", filter="(objectClass=org.eclipse.sensinact.northbound.session.SensiNactSessionManager)")
public class DescriptionsTest {
    private static final UserInfo USER = UserInfo.ANONYMOUS;
    private static final String PROVIDER = "QueryHandlerDescriptionProvider";
    private static final String PROVIDER_2 = "QueryHandlerDescriptionProvider_2";
    private static final String SERVICE = "service";
    private static final String RESOURCE = "resource";
    private static final Integer VALUE = 42;
    SensiNactSession session;
    @InjectService
    DataUpdate push;
    @InjectService
    IQueryHandler handler;
    final TestUtils utils = new TestUtils();

    @BeforeEach
    void start(@InjectService SensiNactSessionManager sessionManager) {
        this.session = sessionManager.getDefaultSession(USER);
    }

    @Test
    void completeList() throws Exception {
        GenericDto dto = this.utils.makeDto(PROVIDER, SERVICE, RESOURCE, VALUE, Integer.class);
        this.push.pushUpdate((Object)dto).getValue();
        QueryDescribeDTO query = new QueryDescribeDTO();
        query.uri = new SensinactPath();
        AbstractResultDTO rawResult = this.handler.handleQuery(this.session, (AbstractQueryDTO)query);
        this.utils.assertResultSuccess(rawResult, EResultType.COMPLETE_LIST, new String[0]);
        ResultDescribeProvidersDTO result = (ResultDescribeProvidersDTO)rawResult;
        CompleteProviderDescriptionDTO providerDto = result.providers.stream().filter(p -> PROVIDER.equals(p.name)).findFirst().get();
        boolean gotAdmin = false;
        boolean gotService = false;
        block8: for (ResponseDescribeServiceDTO svc : providerDto.services) {
            List resources = svc.resources.stream().map(r -> r.name).collect(Collectors.toList());
            switch (svc.name) {
                case "admin": {
                    gotAdmin = true;
                    Assertions.assertTrue((boolean)resources.contains("location"), (String)"Location admin resource is missing");
                    Assertions.assertTrue((boolean)resources.contains("friendlyName"), (String)"FriendlyName admin resource is missing");
                    continue block8;
                }
                case "service": {
                    gotService = true;
                    Assertions.assertEquals((int)1, (int)svc.resources.size(), (String)("Too many resources for the test service: " + resources));
                    Assertions.assertEquals((Object)RESOURCE, (Object)((ShortResourceDescriptionDTO)svc.resources.get((int)0)).name, (String)"Wrong test service resource name");
                    continue block8;
                }
            }
            Assertions.fail((String)("Unknown service found: " + svc.name));
        }
        Assertions.assertTrue((boolean)gotAdmin, (String)"Admin service not found");
        Assertions.assertTrue((boolean)gotService, (String)"Test service not found");
    }

    @Test
    void providersList() throws Exception {
        GenericDto dto = this.utils.makeDto(PROVIDER, SERVICE, RESOURCE, VALUE, Integer.class);
        this.push.pushUpdate((Object)dto).getValue();
        QueryListDTO query = new QueryListDTO();
        query.uri = new SensinactPath();
        AbstractResultDTO rawResult = this.handler.handleQuery(this.session, (AbstractQueryDTO)query);
        this.utils.assertResultSuccess(rawResult, EResultType.PROVIDERS_LIST, new String[0]);
        ResultListProvidersDTO result = (ResultListProvidersDTO)rawResult;
        Assertions.assertEquals(Set.of("sensiNact", PROVIDER), Set.copyOf(result.providers));
        dto.model = dto.provider = PROVIDER_2;
        this.push.pushUpdate((Object)dto).getValue();
        rawResult = this.handler.handleQuery(this.session, (AbstractQueryDTO)query);
        this.utils.assertResultSuccess(rawResult, EResultType.PROVIDERS_LIST, new String[0]);
        result = (ResultListProvidersDTO)rawResult;
        Assertions.assertEquals(Set.of("sensiNact", PROVIDER, PROVIDER_2), Set.copyOf(result.providers));
    }

    @Test
    void providerDescription() throws Exception {
        GenericDto dto = this.utils.makeDto(PROVIDER, SERVICE, RESOURCE, VALUE, Integer.class);
        this.push.pushUpdate((Object)dto).getValue();
        QueryDescribeDTO query = new QueryDescribeDTO();
        query.uri = new SensinactPath(PROVIDER);
        AbstractResultDTO rawResult = this.handler.handleQuery(this.session, (AbstractQueryDTO)query);
        this.utils.assertResultSuccess(rawResult, EResultType.DESCRIBE_PROVIDER, PROVIDER);
        TypedResponse result = (TypedResponse)rawResult;
        ResponseDescribeProviderDTO descr = this.utils.convert(result, ResponseDescribeProviderDTO.class);
        Assertions.assertEquals((Object)PROVIDER, (Object)descr.name);
        Assertions.assertEquals(Set.of("admin", SERVICE), Set.copyOf(descr.services));
    }

    @Test
    void servicesList() throws Exception {
        GenericDto dto = this.utils.makeDto(PROVIDER, SERVICE, RESOURCE, VALUE, Integer.class);
        this.push.pushUpdate((Object)dto).getValue();
        QueryListDTO query = new QueryListDTO();
        query.uri = new SensinactPath(PROVIDER);
        AbstractResultDTO rawResult = this.handler.handleQuery(this.session, (AbstractQueryDTO)query);
        this.utils.assertResultSuccess(rawResult, EResultType.SERVICES_LIST, PROVIDER);
        ResultListServicesDTO result = (ResultListServicesDTO)rawResult;
        Assertions.assertEquals(Set.of("admin", SERVICE), Set.copyOf(result.services));
    }

    @Test
    void serviceDescription() throws Exception {
        GenericDto dto = this.utils.makeDto(PROVIDER, SERVICE, RESOURCE, VALUE, Integer.class);
        this.push.pushUpdate((Object)dto).getValue();
        QueryDescribeDTO query = new QueryDescribeDTO();
        query.uri = new SensinactPath(PROVIDER, SERVICE);
        AbstractResultDTO rawResult = this.handler.handleQuery(this.session, (AbstractQueryDTO)query);
        this.utils.assertResultSuccess(rawResult, EResultType.DESCRIBE_SERVICE, PROVIDER, SERVICE);
        TypedResponse result = (TypedResponse)rawResult;
        ResponseDescribeServiceDTO descr = this.utils.convert(result, ResponseDescribeServiceDTO.class);
        Assertions.assertEquals((Object)SERVICE, (Object)descr.name);
        Assertions.assertEquals(List.of(RESOURCE), descr.resources.stream().map(r -> r.name).collect(Collectors.toList()));
    }

    @Test
    void resourcesList() throws Exception {
        GenericDto dto = this.utils.makeDto(PROVIDER, SERVICE, RESOURCE, VALUE, Integer.class);
        this.push.pushUpdate((Object)dto).getValue();
        QueryListDTO query = new QueryListDTO();
        query.uri = new SensinactPath(PROVIDER, SERVICE);
        AbstractResultDTO rawResult = this.handler.handleQuery(this.session, (AbstractQueryDTO)query);
        this.utils.assertResultSuccess(rawResult, EResultType.RESOURCES_LIST, PROVIDER, SERVICE);
        ResultListResourcesDTO result = (ResultListResourcesDTO)rawResult;
        Assertions.assertEquals(List.of(RESOURCE), (Object)result.resources);
    }

    @Test
    void resourceDescription() throws Exception {
        GenericDto dto = this.utils.makeDto(PROVIDER, SERVICE, RESOURCE, VALUE, Integer.class);
        this.push.pushUpdate((Object)dto).getValue();
        QueryDescribeDTO query = new QueryDescribeDTO();
        query.uri = new SensinactPath(PROVIDER, SERVICE, RESOURCE);
        AbstractResultDTO rawResult = this.handler.handleQuery(this.session, (AbstractQueryDTO)query);
        this.utils.assertResultSuccess(rawResult, EResultType.DESCRIBE_RESOURCE, PROVIDER, SERVICE, RESOURCE);
        ResponseDescribeResourceDTO describeResourceDTO = this.utils.convert((TypedResponse)rawResult, ResponseDescribeResourceDTO.class);
        Assertions.assertEquals((Object)RESOURCE, (Object)describeResourceDTO.name);
        Assertions.assertTrue((boolean)describeResourceDTO.attributes.isEmpty());
        dto.metadata = Map.of("unit", "dB");
        dto.type = null;
        dto.value = null;
        this.push.pushUpdate((Object)dto).getValue();
        rawResult = this.handler.handleQuery(this.session, (AbstractQueryDTO)query);
        this.utils.assertResultSuccess(rawResult, EResultType.DESCRIBE_RESOURCE, PROVIDER, SERVICE, RESOURCE);
        describeResourceDTO = this.utils.convert((TypedResponse)rawResult, ResponseDescribeResourceDTO.class);
        Assertions.assertEquals((Object)RESOURCE, (Object)describeResourceDTO.name);
        Assertions.assertEquals((int)1, (int)describeResourceDTO.attributes.size());
        MetadataDTO metadataDTO = (MetadataDTO)describeResourceDTO.attributes.get(0);
        Assertions.assertEquals((Object)"unit", (Object)metadataDTO.name);
        Assertions.assertEquals((Object)"dB", (Object)metadataDTO.value);
        Assertions.assertEquals((Object)String.class.getName(), (Object)metadataDTO.type);
    }
}

