/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.northbound.query.test.integration;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.eclipse.sensinact.core.notification.ResourceDataNotification;
import org.eclipse.sensinact.core.push.dto.GenericDto;
import org.eclipse.sensinact.northbound.query.api.AbstractResultDTO;
import org.eclipse.sensinact.northbound.query.api.EResultType;
import org.eclipse.sensinact.northbound.query.dto.result.TypedResponse;
import org.junit.jupiter.api.Assertions;

public class TestUtils {
    private final ObjectMapper mapper = new ObjectMapper();

    public GenericDto makeDto(String provider, String service, String resource, Object value, Class<?> type) {
        return this.makeDto(provider, provider, service, resource, value, type);
    }

    public GenericDto makeDto(String model, String provider, String service, String resource, Object value, Class<?> type) {
        GenericDto dto = new GenericDto();
        dto.model = model;
        dto.provider = provider;
        dto.service = service;
        dto.resource = resource;
        dto.value = value;
        dto.type = type;
        return dto;
    }

    public <T> T convert(TypedResponse<?> dto, Class<T> type) {
        return (T)this.mapper.convertValue((Object)dto.response, type);
    }

    public void assertNotification(GenericDto expected, ResourceDataNotification notification) {
        Assertions.assertNotNull((Object)notification);
        Assertions.assertEquals((Object)expected.provider, (Object)notification.provider);
        Assertions.assertEquals((Object)expected.service, (Object)notification.service);
        Assertions.assertEquals((Object)expected.resource, (Object)notification.resource);
        Assertions.assertEquals((Object)expected.value, (Object)notification.newValue);
    }

    public void assertResultSuccess(AbstractResultDTO result, EResultType expectedType, String ... uriParts) {
        Assertions.assertEquals((int)200, (int)result.statusCode, (String)"Invalid status code");
        Assertions.assertNull((Object)result.error, (String)"Got an error");
        Assertions.assertEquals((Object)expectedType, (Object)result.type, (String)"Invalid result type");
        Assertions.assertEquals((Object)("/" + String.join((CharSequence)"/", uriParts)), (Object)result.uri, (String)"Invalid URI");
    }

    public void assertResultNoContent(AbstractResultDTO result, EResultType expectedType, String ... uriParts) {
        Assertions.assertEquals((int)204, (int)result.statusCode, (String)"Invalid status code");
        Assertions.assertEquals((Object)"No value set", (Object)result.error);
        Assertions.assertEquals((Object)expectedType, (Object)result.type, (String)"Invalid result type");
        Assertions.assertEquals((Object)("/" + String.join((CharSequence)"/", uriParts)), (Object)result.uri, (String)"Invalid URI");
    }
}

