/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.northbound.rest.integration;

import com.fasterxml.jackson.databind.JsonNode;
import jakarta.ws.rs.core.Application;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.sensinact.core.annotation.verb.ACT;
import org.eclipse.sensinact.core.annotation.verb.ActParam;
import org.eclipse.sensinact.core.notification.ResourceDataNotification;
import org.eclipse.sensinact.core.push.DataUpdate;
import org.eclipse.sensinact.core.push.dto.GenericDto;
import org.eclipse.sensinact.gateway.geojson.Coordinates;
import org.eclipse.sensinact.gateway.geojson.GeoJsonObject;
import org.eclipse.sensinact.gateway.geojson.Point;
import org.eclipse.sensinact.northbound.query.api.AbstractResultDTO;
import org.eclipse.sensinact.northbound.query.api.EResultType;
import org.eclipse.sensinact.northbound.query.dto.query.AccessMethodCallParameterDTO;
import org.eclipse.sensinact.northbound.query.dto.query.WrappedAccessMethodCallParametersDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ResponseGetDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ResultActDTO;
import org.eclipse.sensinact.northbound.query.dto.result.TypedResponse;
import org.eclipse.sensinact.northbound.rest.integration.TestUtils;
import org.eclipse.sensinact.northbound.security.api.UserInfo;
import org.eclipse.sensinact.northbound.session.SensiNactSession;
import org.eclipse.sensinact.northbound.session.SensiNactSessionManager;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.opentest4j.AssertionFailedError;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;
import org.osgi.test.common.annotation.InjectBundleContext;
import org.osgi.test.common.annotation.InjectService;
import org.osgi.test.common.annotation.Property;
import org.osgi.test.common.annotation.config.InjectConfiguration;
import org.osgi.test.common.annotation.config.WithConfiguration;
import org.osgi.test.common.service.ServiceAware;

@WithConfiguration(pid="sensinact.session.manager", properties={@Property(key="auth.policy", value={"ALLOW_ALL"})})
public class ResourceAccessTest {
    private static final UserInfo USER = UserInfo.ANONYMOUS;
    private static final String PROVIDER = "RestAccessProvider";
    private static final String PROVIDER_TOPIC = "RestAccessProvider/*";
    private static final String SERVICE = "service";
    private static final String RESOURCE = "resource";
    private static final Integer VALUE = 42;
    private static final Integer VALUE_2 = 84;
    @InjectService
    SensiNactSessionManager sessionManager;
    @InjectService
    DataUpdate push;
    BlockingQueue<ResourceDataNotification> queue;
    final TestUtils utils = new TestUtils();
    private static final String ADMIN = "admin";
    private static final String LOCATION = "location";

    @BeforeEach
    public void await(@InjectConfiguration(withConfig=@WithConfiguration(pid="sensinact.northbound.rest", location="?", properties={@Property(key="allow.anonymous", value={"true"}), @Property(key="foobar", value={"fizz"})})) Configuration cm, @InjectService(filter="(foobar=fizz)", cardinality=0) ServiceAware<Application> a) throws InterruptedException {
        a.waitForService(5000L);
        for (int i = 0; i < 10; ++i) {
            try {
                if (this.utils.queryStatus("/").statusCode() == 200) {
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Thread.sleep(200L);
        }
        throw new AssertionFailedError("REST API did not appear");
    }

    @AfterEach
    void stop() {
        if (this.queue != null) {
            SensiNactSession session = this.sessionManager.getDefaultSession(USER);
            session.activeListeners().keySet().forEach(arg_0 -> ((SensiNactSession)session).removeListener(arg_0));
            this.queue = null;
        }
    }

    @Test
    void resourceGet() throws Exception {
        GenericDto dto = this.utils.makeDto(PROVIDER, SERVICE, RESOURCE, VALUE, Integer.class);
        Instant updateTime = Instant.now().truncatedTo(ChronoUnit.MILLIS);
        this.push.pushUpdate((Object)dto).getValue();
        TypedResponse result = this.utils.queryJson(String.join((CharSequence)"/", "providers", PROVIDER, "services", SERVICE, "resources", RESOURCE, "GET"), TypedResponse.class);
        this.utils.assertResultSuccess((AbstractResultDTO)result, EResultType.GET_RESPONSE, PROVIDER, SERVICE, RESOURCE);
        ResponseGetDTO response = this.utils.convert(result, ResponseGetDTO.class);
        Assertions.assertEquals((Object)RESOURCE, (Object)response.name);
        Assertions.assertEquals((Object)VALUE, (Object)response.value);
        Assertions.assertEquals((Object)dto.type.getName(), (Object)response.type);
        Assertions.assertFalse((boolean)Instant.ofEpochMilli(response.timestamp).isBefore(updateTime), (String)"Timestamp wasn't updated");
    }

    @Test
    void resourceUpdate() throws Exception {
        GenericDto dto = this.utils.makeDto(PROVIDER, SERVICE, RESOURCE, VALUE, Integer.class);
        Instant firstTime = Instant.now().truncatedTo(ChronoUnit.MILLIS);
        this.push.pushUpdate((Object)dto).getValue();
        TypedResponse result = this.utils.queryJson(String.join((CharSequence)"/", "providers", PROVIDER, "services", SERVICE, "resources", RESOURCE, "GET"), TypedResponse.class);
        ResponseGetDTO response = this.utils.convert(result, ResponseGetDTO.class);
        Assertions.assertEquals((Object)VALUE, (Object)response.value);
        Assertions.assertFalse((boolean)Instant.ofEpochMilli(response.timestamp).isBefore(firstTime), (String)"Timestamp wasn't updated");
        dto.value = VALUE_2;
        Instant secondTime = Instant.now().truncatedTo(ChronoUnit.MILLIS);
        this.push.pushUpdate((Object)dto).getValue();
        result = this.utils.queryJson(String.join((CharSequence)"/", "providers", PROVIDER, "services", SERVICE, "resources", RESOURCE, "GET"), TypedResponse.class);
        response = this.utils.convert(result, ResponseGetDTO.class);
        Assertions.assertEquals((Object)VALUE_2, (Object)response.value);
        Assertions.assertFalse((boolean)Instant.ofEpochMilli(response.timestamp).isBefore(secondTime), (String)"Timestamp wasn't updated");
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void resourceSet(boolean wrapParams) throws Exception {
        GenericDto dto = this.utils.makeDto(PROVIDER, SERVICE, RESOURCE, VALUE, Integer.class);
        Instant firstUpdateTime = Instant.now().truncatedTo(ChronoUnit.MILLIS);
        this.push.pushUpdate((Object)dto).getValue();
        TypedResponse result = this.utils.queryJson(String.join((CharSequence)"/", "providers", PROVIDER, "services", SERVICE, "resources", RESOURCE, "GET"), TypedResponse.class);
        ResponseGetDTO response = this.utils.convert(result, ResponseGetDTO.class);
        Assertions.assertEquals((Object)VALUE, (Object)response.value);
        Instant firstTimestamp = Instant.ofEpochMilli(response.timestamp);
        Assertions.assertFalse((boolean)firstTimestamp.isBefore(firstUpdateTime), (String)"Timestamp wasn't updated");
        this.queue = new ArrayBlockingQueue<ResourceDataNotification>(32);
        SensiNactSession session = this.sessionManager.getDefaultSession(USER);
        session.addListener(List.of(PROVIDER_TOPIC), (t, e) -> this.queue.offer(e), null, null, null);
        Assertions.assertNull((Object)this.queue.poll(500L, TimeUnit.MILLISECONDS));
        AccessMethodCallParameterDTO param = new AccessMethodCallParameterDTO();
        param.name = "value";
        param.type = Integer.class.getName();
        param.value = VALUE_2;
        result = this.utils.queryJson(String.join((CharSequence)"/", "providers", PROVIDER, "services", SERVICE, "resources", RESOURCE, "SET"), this.wrapParams(wrapParams, List.of(param)), TypedResponse.class);
        this.utils.assertResultSuccess((AbstractResultDTO)result, EResultType.SET_RESPONSE, PROVIDER, SERVICE, RESOURCE);
        response = this.utils.convert(result, ResponseGetDTO.class);
        Assertions.assertEquals((Object)RESOURCE, (Object)response.name);
        Assertions.assertEquals((Object)param.type, (Object)response.type);
        Assertions.assertEquals((Object)VALUE_2, (Object)response.value);
        dto.value = VALUE_2;
        this.utils.assertNotification(dto, this.queue.poll(1L, TimeUnit.SECONDS));
        result = this.utils.queryJson(String.join((CharSequence)"/", "providers", PROVIDER, "services", SERVICE, "resources", RESOURCE, "GET"), TypedResponse.class);
        response = this.utils.convert(result, ResponseGetDTO.class);
        Assertions.assertEquals((Object)VALUE_2, (Object)response.value);
        Assertions.assertTrue((boolean)firstTimestamp.isBefore(Instant.ofEpochMilli(response.timestamp)), (String)"Timestamp wasn't updated");
    }

    private Object wrapParams(boolean wrap, List<AccessMethodCallParameterDTO> params) {
        if (wrap) {
            WrappedAccessMethodCallParametersDTO dto = new WrappedAccessMethodCallParametersDTO();
            dto.parameters = params;
            return dto;
        }
        return params;
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void locationSet(boolean wrapParams) throws Exception {
        String provider = "RestAccessProvider_" + Boolean.toString(wrapParams);
        GenericDto dto = this.utils.makeDto(provider, SERVICE, RESOURCE, VALUE, Integer.class);
        this.push.pushUpdate((Object)dto).getValue();
        TypedResponse result = this.utils.queryJson(String.join((CharSequence)"/", "providers", provider, "services", ADMIN, "resources", LOCATION, "GET"), TypedResponse.class);
        Assertions.assertEquals((int)204, (int)result.statusCode);
        ResponseGetDTO response = this.utils.convert(result, ResponseGetDTO.class);
        Thread.sleep(500L);
        this.queue = new ArrayBlockingQueue<ResourceDataNotification>(32);
        SensiNactSession session = this.sessionManager.getDefaultSession(USER);
        session.addListener(List.of(provider + "/*"), (t, e) -> this.queue.offer(e), null, null, null);
        ResourceDataNotification notification = this.queue.poll(500L, TimeUnit.MILLISECONDS);
        Assertions.assertNull((Object)notification, () -> String.format("notification was for %s/%s/%s with old: %s and new: %s", notification.provider, notification.service, notification.resource, notification.oldValue, notification.newValue));
        Point p = new Point();
        p.coordinates = new Coordinates();
        p.coordinates.latitude = 48.5;
        p.coordinates.longitude = 4.5;
        AccessMethodCallParameterDTO param = new AccessMethodCallParameterDTO();
        param.name = "value";
        param.type = response.type;
        param.value = p;
        result = this.utils.queryJson(String.join((CharSequence)"/", "providers", provider, "services", ADMIN, "resources", LOCATION, "SET"), this.wrapParams(wrapParams, List.of(param)), TypedResponse.class);
        this.utils.assertResultSuccess((AbstractResultDTO)result, EResultType.SET_RESPONSE, provider, ADMIN, LOCATION);
        response = this.utils.convert(result, ResponseGetDTO.class);
        Assertions.assertEquals((Object)LOCATION, (Object)response.name);
        Assertions.assertEquals((Object)param.type, (Object)response.type);
        dto.service = ADMIN;
        dto.resource = LOCATION;
        dto.type = Point.class;
        dto.value = this.utils.convert(p, Map.class);
        this.utils.assertNotification(dto, this.queue.poll(1L, TimeUnit.SECONDS));
        result = this.utils.queryJson(String.join((CharSequence)"/", "providers", provider, "services", ADMIN, "resources", LOCATION, "GET"), TypedResponse.class);
        response = this.utils.convert(result, ResponseGetDTO.class);
        Assertions.assertEquals((Object)this.utils.convert(p, JsonNode.class).toString(), (Object)this.utils.convert(response.value, JsonNode.class).toString());
        Assertions.assertNotEquals((long)0L, (long)response.timestamp, (String)"Timestamp wasn't updated");
    }

    @Test
    void adminDefaultValues() throws Exception {
        GenericDto dto = this.utils.makeDto(PROVIDER, SERVICE, RESOURCE, VALUE, Integer.class);
        this.push.pushUpdate((Object)dto).getValue();
        TypedResponse result = this.utils.queryJson(String.join((CharSequence)"/", "providers", PROVIDER, "services", ADMIN, "resources", "friendlyName", "GET"), TypedResponse.class);
        this.utils.assertResultSuccess((AbstractResultDTO)result, EResultType.GET_RESPONSE, PROVIDER, ADMIN, "friendlyName");
        ResponseGetDTO response = this.utils.convert(result, ResponseGetDTO.class);
        Assertions.assertEquals((Object)String.class.getName(), (Object)response.type);
        Assertions.assertEquals((Object)PROVIDER, (Object)response.value);
        result = this.utils.queryJson(String.join((CharSequence)"/", "providers", PROVIDER, "services", ADMIN, "resources", LOCATION, "GET"), TypedResponse.class);
        this.utils.assertResultNoContent((AbstractResultDTO)result, EResultType.GET_RESPONSE, PROVIDER, ADMIN, LOCATION);
        response = this.utils.convert(result, ResponseGetDTO.class);
        Assertions.assertEquals((Object)GeoJsonObject.class.getName(), (Object)response.type);
        Assertions.assertNull((Object)response.value);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void resourceAct(boolean wrapParams, @InjectBundleContext BundleContext context) throws Exception {
        context.registerService(TestAction.class, (Object)new TestAction(), new Hashtable<String, Boolean>(Map.of("sensiNact.whiteboard.resource", true)));
        GenericDto dto = this.utils.makeDto(PROVIDER, SERVICE, RESOURCE, VALUE, Integer.class);
        this.push.pushUpdate((Object)dto).getValue();
        AccessMethodCallParameterDTO param = new AccessMethodCallParameterDTO();
        param.name = "input";
        param.type = Long.class.getName();
        param.value = 123L;
        ResultActDTO response = this.utils.queryJson(String.join((CharSequence)"/", "providers", PROVIDER, "services", SERVICE, "resources", "action", "ACT"), this.wrapParams(wrapParams, List.of(param)), ResultActDTO.class);
        Assertions.assertNotNull((Object)response);
        Assertions.assertEquals((int)200, (int)response.statusCode);
        Assertions.assertNotNull((Object)response.response);
        Assertions.assertEquals((Object)246.0, (Object)response.response);
    }

    public static class TestAction {
        @ACT(model="RestAccessProvider", service="service", resource="action")
        public Double toDoubleDouble(@ActParam(value="input") Long longValue) {
            return longValue.doubleValue() * 2.0;
        }
    }
}

