/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.northbound.rest.integration;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Map;
import org.eclipse.sensinact.core.notification.ResourceDataNotification;
import org.eclipse.sensinact.core.push.dto.GenericDto;
import org.eclipse.sensinact.northbound.query.api.AbstractResultDTO;
import org.eclipse.sensinact.northbound.query.api.EResultType;
import org.eclipse.sensinact.northbound.query.dto.result.TypedResponse;
import org.junit.jupiter.api.Assertions;

public class TestUtils {
    private final ObjectMapper mapper = new ObjectMapper();
    static final HttpClient client = HttpClient.newHttpClient();

    public GenericDto makeDto(String provider, String service, String resource, Object value, Class<?> type) {
        return this.makeDto(provider, provider, service, resource, value, type);
    }

    public GenericDto makeDto(String model, String provider, String service, String resource, Object value, Class<?> type) {
        GenericDto dto = new GenericDto();
        dto.model = model;
        dto.provider = provider;
        dto.service = service;
        dto.resource = resource;
        dto.value = value;
        dto.type = type;
        return dto;
    }

    public HttpResponse<?> queryStatus(String path) throws IOException, InterruptedException {
        URI targetUri = path.startsWith("/") ? URI.create("http://localhost:8185/sensinact" + path) : URI.create("http://localhost:8185/sensinact/" + path);
        HttpRequest req = HttpRequest.newBuilder(targetUri).build();
        return client.send(req, x -> HttpResponse.BodySubscribers.discarding());
    }

    public <T> T queryJson(String path, Class<T> resultType) throws IOException, InterruptedException {
        return this.queryJson(path, resultType, Map.of());
    }

    public <T> T queryJson(String path, Class<T> resultType, Map<String, String> headers) throws IOException, InterruptedException {
        URI targetUri = path.startsWith("/") ? URI.create("http://localhost:8185/sensinact" + path) : URI.create("http://localhost:8185/sensinact/" + path);
        HttpRequest.Builder builder = HttpRequest.newBuilder(targetUri);
        headers.forEach((a, b) -> builder.header((String)a, (String)b));
        HttpRequest req = builder.build();
        HttpResponse response = client.send(req, x -> HttpResponse.BodySubscribers.ofInputStream());
        return (T)this.mapper.createParser((InputStream)response.body()).readValueAs(resultType);
    }

    public <T> T queryJson(String path, Object body, Class<T> resultType) throws IOException, InterruptedException {
        URI targetUri = path.startsWith("/") ? URI.create("http://localhost:8185/sensinact" + path) : URI.create("http://localhost:8185/sensinact/" + path);
        HttpRequest req = HttpRequest.newBuilder(targetUri).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(this.mapper.writeValueAsString(body))).build();
        HttpResponse response = client.send(req, x -> HttpResponse.BodySubscribers.ofInputStream());
        return (T)this.mapper.createParser((InputStream)response.body()).readValueAs(resultType);
    }

    public <T> T convert(TypedResponse<?> dto, Class<T> type) {
        return this.convert(dto.response, type);
    }

    public <T> T convert(Object o, Class<T> type) {
        return (T)this.mapper.convertValue(o, type);
    }

    public void assertNotification(GenericDto expected, ResourceDataNotification notification) {
        Assertions.assertNotNull((Object)notification);
        Assertions.assertEquals((Object)expected.provider, (Object)notification.provider);
        Assertions.assertEquals((Object)expected.service, (Object)notification.service);
        Assertions.assertEquals((Object)expected.resource, (Object)notification.resource);
        Assertions.assertEquals((Object)expected.value, (Object)notification.newValue);
    }

    public void assertResultSuccess(AbstractResultDTO result, EResultType expectedType, String ... uriParts) {
        Assertions.assertEquals((int)200, (int)result.statusCode, (String)"Invalid status code");
        Assertions.assertNull((Object)result.error, (String)"Got an error");
        Assertions.assertEquals((Object)expectedType, (Object)result.type, (String)"Invalid result type");
        Assertions.assertEquals((Object)("/" + String.join((CharSequence)"/", uriParts)), (Object)result.uri, (String)"Invalid URI");
    }

    public void assertResultNoContent(AbstractResultDTO result, EResultType expectedType, String ... uriParts) {
        Assertions.assertEquals((int)204, (int)result.statusCode, (String)"Invalid status code");
        Assertions.assertEquals((Object)"No value set", (Object)result.error);
        Assertions.assertEquals((Object)expectedType, (Object)result.type, (String)"Invalid result type");
        Assertions.assertEquals((Object)("/" + String.join((CharSequence)"/", uriParts)), (Object)result.uri, (String)"Invalid URI");
    }
}

