/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.northbound.security.oidc;

import com.fasterxml.jackson.databind.json.JsonMapper;
import io.jsonwebtoken.JwsHeader;
import java.io.File;
import java.nio.file.Paths;
import java.security.Key;
import org.eclipse.sensinact.gateway.northbound.security.oidc.Certificates;
import org.eclipse.sensinact.gateway.northbound.security.oidc.KeyResolver;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class KeyResolverTest {
    @Mock
    JwsHeader<?> header;

    @ParameterizedTest
    @ValueSource(strings={"example-key.json", "example-key2.json"})
    void testKeyDecode(String file) throws Exception {
        File json = Paths.get("src/test/resources/public-key-examples", file).toFile();
        Certificates certificates = (Certificates)((JsonMapper)JsonMapper.builder().build()).readValue(json, Certificates.class);
        KeyResolver keyResolver = new KeyResolver(certificates.getKeys());
        for (Certificates.KeyInfo keyInfo : certificates.getKeys()) {
            if (!"sig".equals(keyInfo.use)) continue;
            Mockito.when((Object)this.header.getKeyId()).thenReturn((Object)keyInfo.keyId);
            Mockito.when((Object)this.header.getAlgorithm()).thenReturn((Object)keyInfo.algorithm);
            Key key = keyResolver.resolveSigningKey(this.header, "");
            Assertions.assertNotNull((Object)key);
            Assertions.assertEquals((Object)keyInfo.type, (Object)key.getAlgorithm());
        }
    }
}

