/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.northbound.security.oidc.integration;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.sun.net.httpserver.HttpServer;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.io.Serializer;
import io.jsonwebtoken.jackson.io.JacksonSerializer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.time.Duration;
import java.time.Instant;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.sensinact.gateway.northbound.security.oidc.Certificates;
import org.eclipse.sensinact.northbound.security.api.Authenticator;
import org.eclipse.sensinact.northbound.security.api.UserInfo;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.annotations.RequireConfigurationAdmin;
import org.osgi.test.common.annotation.InjectService;

@RequireConfigurationAdmin
public class ValidatorTest {
    private static final Map<String, String> EC_CURVE_NAME_MAPPING = Map.of("ES256", "secp256r1", "ES384", "secp384r1", "ES512", "secp521r1");
    private final Map<SignatureAlgorithm, KeyPair> asymmetricKeys = new HashMap<SignatureAlgorithm, KeyPair>();
    private final Map<SignatureAlgorithm, Key> keys = new HashMap<SignatureAlgorithm, Key>();
    private final ObjectMapper mapper = JsonMapper.builder().build();
    private HttpServer httpServer;
    private String DISCOVERY;
    private Configuration config;

    @BeforeEach
    public void startCertificateEndpoint(@InjectService ConfigurationAdmin cm) throws Exception {
        for (SignatureAlgorithm sa : SignatureAlgorithm.values()) {
            if (sa == SignatureAlgorithm.NONE) continue;
            if (sa.isHmac()) {
                byte[] key = new byte[sa.getMinKeyLength()];
                new SecureRandom().nextBytes(key);
                this.keys.put(sa, new SecretKeySpec(key, sa.getJcaName()));
                continue;
            }
            if (sa.isRsa()) {
                KeyPairGenerator rsaKpg = KeyPairGenerator.getInstance("RSA");
                rsaKpg.initialize(sa.getMinKeyLength());
                this.asymmetricKeys.put(sa, rsaKpg.genKeyPair());
                continue;
            }
            if (sa.isEllipticCurve()) {
                KeyPairGenerator ecKpg = KeyPairGenerator.getInstance("EC");
                ecKpg.initialize(new ECGenParameterSpec(EC_CURVE_NAME_MAPPING.get(sa.getValue())));
                this.asymmetricKeys.put(sa, ecKpg.genKeyPair());
                continue;
            }
            throw new IllegalArgumentException("Unknown key type " + sa.getDescription());
        }
        Certificates certificates = new Certificates();
        certificates.setKeys(Stream.concat(this.asymmetricKeys.entrySet().stream().map(e -> {
            try {
                SignatureAlgorithm sa = (SignatureAlgorithm)e.getKey();
                Certificates.KeyInfo info = new Certificates.KeyInfo();
                info.setAlgorithm(sa.getValue());
                info.setKeyId(sa.getDescription());
                Base64.Encoder encoder = Base64.getUrlEncoder();
                if (sa.isRsa()) {
                    KeyFactory kf = KeyFactory.getInstance("RSA");
                    info.setType("RSA");
                    RSAPublicKeySpec spec = kf.getKeySpec(((KeyPair)e.getValue()).getPublic(), RSAPublicKeySpec.class);
                    info.setRsaModulus(encoder.encodeToString(spec.getModulus().toByteArray()));
                    info.setRsaExponent(encoder.encodeToString(spec.getPublicExponent().toByteArray()));
                } else if (sa.isEllipticCurve()) {
                    KeyFactory kf = KeyFactory.getInstance("EC");
                    info.setType("EC");
                    ECPublicKeySpec spec = kf.getKeySpec(((KeyPair)e.getValue()).getPublic(), ECPublicKeySpec.class);
                    info.setEcCurve(sa.getValue());
                    info.setEcXCoordinate(encoder.encodeToString(spec.getW().getAffineX().toByteArray()));
                    info.setEcYCoordinate(encoder.encodeToString(spec.getW().getAffineY().toByteArray()));
                } else {
                    throw new IllegalArgumentException("Unknown key type " + sa.getDescription());
                }
                return info;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }), this.keys.entrySet().stream().map(e -> {
            try {
                SignatureAlgorithm sa = (SignatureAlgorithm)e.getKey();
                Certificates.KeyInfo info = new Certificates.KeyInfo();
                info.setAlgorithm(sa.getValue());
                info.setKeyId(sa.getDescription());
                Base64.Encoder encoder = Base64.getUrlEncoder();
                if (!sa.isHmac()) {
                    throw new IllegalArgumentException("Unknown key type " + sa.getDescription());
                }
                info.setType("HMAC");
                info.setSymmetricKey(encoder.encodeToString(((Key)e.getValue()).getEncoded()));
                return info;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        })).collect(Collectors.toList()));
        this.httpServer = HttpServer.create();
        this.httpServer.bind(new InetSocketAddress(InetAddress.getLoopbackAddress(), 0), 0);
        this.httpServer.start();
        InetSocketAddress address = this.httpServer.getAddress();
        String base = String.format("http://%s:%d/", address.getAddress().getHostAddress(), address.getPort());
        this.DISCOVERY = base + "discovery";
        this.httpServer.createContext("/discovery", ex -> {
            ex.sendResponseHeaders(200, 0L);
            this.mapper.writeValue(ex.getResponseBody(), Map.of("jwks_uri", base + "certificates"));
        });
        this.httpServer.createContext("/certificates", ex -> {
            ex.sendResponseHeaders(200, 0L);
            this.mapper.writeValue(ex.getResponseBody(), (Object)certificates);
        });
        this.config = cm.getFactoryConfiguration("sensinact.northbound.auth.oidc", "test", "?");
        this.config.update(new Hashtable<String, String>(Map.of("realm", "test", "discoveryURL", this.DISCOVERY)));
    }

    @AfterEach
    public void clear() throws IOException {
        this.config.delete();
        this.httpServer.stop(0);
        this.httpServer = null;
        this.asymmetricKeys.clear();
        this.keys.clear();
    }

    @EnumSource(value=SignatureAlgorithm.class, mode=EnumSource.Mode.EXCLUDE, names={"NONE"})
    @ParameterizedTest
    void testValidSignatures(SignatureAlgorithm alg, @InjectService(timeout=5000L) Authenticator service) throws Exception {
        Date start = new Date(Instant.now().minus(Duration.ofHours(1L)).toEpochMilli());
        Date end = new Date(Instant.now().plus(Duration.ofHours(1L)).toEpochMilli());
        Key key = this.asymmetricKeys.containsKey(alg) ? this.asymmetricKeys.get(alg).getPrivate() : this.keys.get(alg);
        String token = Jwts.builder().setSubject("test").setIssuedAt(start).setExpiration(end).setHeaderParam("kid", (Object)alg.getDescription()).serializeToJsonWith((Serializer)new JacksonSerializer(this.mapper)).signWith(key, alg).compact();
        UserInfo info = service.authenticate(null, token);
        Assertions.assertEquals((Object)"test", (Object)info.getUserId());
        Assertions.assertTrue((boolean)info.isAuthenticated());
    }
}

