/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.southbound.http.factory.integration;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.sensinact.core.notification.ResourceDataNotification;
import org.eclipse.sensinact.gateway.geojson.Point;
import org.eclipse.sensinact.gateway.southbound.device.factory.dto.DeviceMappingConfigurationDTO;
import org.eclipse.sensinact.gateway.southbound.http.factory.HttpDeviceFactory;
import org.eclipse.sensinact.gateway.southbound.http.factory.integration.RequestHandler;
import org.eclipse.sensinact.northbound.security.api.UserInfo;
import org.eclipse.sensinact.northbound.session.ResourceDescription;
import org.eclipse.sensinact.northbound.session.SensiNactSession;
import org.eclipse.sensinact.northbound.session.SensiNactSessionManager;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.test.common.annotation.InjectService;
import org.osgi.test.common.annotation.Property;
import org.osgi.test.common.annotation.config.WithConfiguration;
import org.slf4j.LoggerFactory;

@WithConfiguration(pid="sensinact.session.manager", properties={@Property(key="auth.policy", value={"ALLOW_ALL"})})
public class HttpDeviceFactoryTest {
    static QueuedThreadPool threadPool;
    static Server server;
    static RequestHandler handler;
    static int httpPort;
    final ObjectMapper mapper = new ObjectMapper();
    @InjectService
    SensiNactSessionManager sessionManager;
    SensiNactSession session;
    BlockingQueue<ResourceDataNotification> queue;
    BlockingQueue<ResourceDataNotification> queue2;
    @InjectService
    ConfigurationAdmin configAdmin;

    @BeforeAll
    static void setup() throws Exception {
        threadPool = new QueuedThreadPool();
        threadPool.setName("server");
        handler = new RequestHandler();
        server = new Server((ThreadPool)threadPool);
        ServerConnector conn = new ServerConnector(server);
        conn.setPort(0);
        server.addConnector((Connector)conn);
        server.setHandler((Handler)handler);
        server.start();
        httpPort = conn.getLocalPort();
    }

    @AfterAll
    static void teardown() throws Exception {
        server.stop();
        server = null;
        threadPool.stop();
        threadPool = null;
    }

    @BeforeEach
    void start() throws InterruptedException {
        this.session = this.sessionManager.getDefaultSession(UserInfo.ANONYMOUS);
        this.queue = new ArrayBlockingQueue<ResourceDataNotification>(32);
        this.queue2 = new ArrayBlockingQueue<ResourceDataNotification>(32);
    }

    @AfterEach
    void stop() {
        this.session.activeListeners().keySet().forEach(arg_0 -> ((SensiNactSession)this.session).removeListener(arg_0));
        this.session = null;
        handler.clear();
    }

    void setupProvidersHandling(String provider1, String provider2) {
        Assertions.assertNull((Object)this.session.describeProvider(provider1));
        this.session.addListener(List.of(provider1 + "/*"), (t, e) -> this.queue.offer(e), null, null, null);
        if (provider2 != null) {
            Assertions.assertNull((Object)this.session.describeProvider(provider2));
            this.session.addListener(List.of(provider2 + "/*"), (t, e) -> this.queue2.offer(e), null, null, null);
        }
    }

    byte[] readFile(String filename) throws IOException {
        try (InputStream inStream = this.getClass().getClassLoader().getResourceAsStream("/" + filename);){
            byte[] byArray = inStream.readAllBytes();
            return byArray;
        }
    }

    void assertNotifications(Object providerValue1, Object providerValue2, int timeoutSeconds) throws Exception {
        Instant timeout = Instant.now().plus((long)timeoutSeconds, ChronoUnit.SECONDS);
        boolean got1 = false;
        boolean got2 = false;
        while (!(!Instant.now().isBefore(timeout) || got1 && got2)) {
            ResourceDataNotification notif;
            if (!got1 && (notif = this.queue.poll(1L, TimeUnit.SECONDS)) != null) {
                got1 = Objects.equals(providerValue1, notif.newValue);
            }
            if (got2 || (notif = this.queue2.poll(1L, TimeUnit.SECONDS)) == null) continue;
            got2 = Objects.equals(providerValue2, notif.newValue);
        }
        Assertions.assertTrue((got1 && got2 ? 1 : 0) != 0, (String)"Timeout expired before update");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testSimpleTask() throws Exception {
        String provider1 = "typed-provider1";
        String provider2 = "typed-provider2";
        this.setupProvidersHandling("typed-provider1", "typed-provider2");
        String inputFileName = "csv-header-typed";
        String mappingConfig = new String(this.readFile("csv-header-typed-mapping.json"));
        handler.setData("/data", this.readFile("csv-header-typed.csv"));
        Configuration config = this.configAdmin.createFactoryConfiguration("sensinact.http.device.factory", "?");
        try {
            config.update(new Hashtable<String, CallSite>(Map.of("tasks.oneshot", "[{\"url\": \"http://localhost:" + httpPort + "/data\", \"mapping\": " + mappingConfig + "}]")));
            Assertions.assertNotNull((Object)this.queue.poll(1L, TimeUnit.SECONDS));
            Assertions.assertNotNull((Object)this.queue2.poll(1L, TimeUnit.SECONDS));
            Assertions.assertEquals((int)42, (Integer)((Integer)this.session.getResourceValue("typed-provider1", "data", "value", Integer.class)));
            Assertions.assertEquals((int)84, (Integer)((Integer)this.session.getResourceValue("typed-provider2", "data", "value", Integer.class)));
            Instant timestamp1 = Instant.from(LocalDateTime.of(2021, 10, 20, 18, 14, 0).atOffset(ZoneOffset.UTC));
            Assertions.assertEquals((Object)timestamp1, (Object)this.session.describeResource((String)"typed-provider1", (String)"data", (String)"value").timestamp);
            Instant timestamp2 = Instant.from(LocalDateTime.of(2021, 10, 20, 18, 17, 0).atOffset(ZoneOffset.UTC));
            Assertions.assertEquals((Object)timestamp2, (Object)this.session.describeResource((String)"typed-provider2", (String)"data", (String)"value").timestamp);
            ResourceDescription location1 = this.session.describeResource("typed-provider1", "admin", "location");
            Assertions.assertEquals((Object)timestamp1, (Object)location1.timestamp);
            Assertions.assertNotNull((Object)location1.value);
            Point geoPoint = (Point)location1.value;
            Assertions.assertEquals((double)1.2, (double)geoPoint.coordinates.latitude, (double)0.001);
            Assertions.assertEquals((double)3.4, (double)geoPoint.coordinates.longitude, (double)0.001);
            Assertions.assertTrue((boolean)Double.isNaN(geoPoint.coordinates.elevation));
            ResourceDescription location2 = this.session.describeResource("typed-provider2", "admin", "location");
            Assertions.assertNotNull((Object)location2.value);
            Assertions.assertEquals((Object)timestamp2, (Object)location2.timestamp);
            geoPoint = (Point)location2.value;
            Assertions.assertEquals((double)5.6, (double)geoPoint.coordinates.latitude, (double)0.001);
            Assertions.assertEquals((double)7.8, (double)geoPoint.coordinates.longitude, (double)0.001);
            Assertions.assertTrue((boolean)Double.isNaN(geoPoint.coordinates.elevation));
            Assertions.assertEquals((int)1, (int)handler.nbVisitedPaths());
            Assertions.assertEquals((int)1, (int)handler.nbVisits("/data"));
        }
        finally {
            config.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testPeriodicTask() throws Exception {
        String provider1 = "dynamic-provider1";
        String provider2 = "dynamic-provider2";
        this.setupProvidersHandling("dynamic-provider1", "dynamic-provider2");
        String inputFileName = "csv-header-dynamic";
        String template = new String(this.readFile("csv-header-dynamic.csv"));
        String mappingConfig = new String(this.readFile("csv-header-dynamic-mapping.json"));
        String content = template.replace("$val1$", "1").replace("$val2$", "2");
        handler.setData("/data", content);
        Configuration config = this.configAdmin.createFactoryConfiguration("sensinact.http.device.factory", "?");
        try {
            Instant start = Instant.now();
            config.update(new Hashtable<String, CallSite>(Map.of("tasks.periodic", "[{\"period\": 2, \"url\": \"http://localhost:" + httpPort + "/data\", \"mapping\": " + mappingConfig + "}]")));
            Assertions.assertNotNull((Object)this.queue.poll(1L, TimeUnit.SECONDS));
            Assertions.assertEquals((int)1, (int)handler.nbVisitedPaths());
            Assertions.assertEquals((int)1, (int)handler.nbVisits("/data"));
            Instant firstTimestamp = this.session.describeResource((String)"dynamic-provider1", (String)"data", (String)"value").timestamp;
            Assertions.assertFalse((boolean)firstTimestamp.isBefore(start));
            Assertions.assertEquals((int)1, (Integer)((Integer)this.session.getResourceValue("dynamic-provider1", "data", "value", Integer.class)));
            Assertions.assertEquals((int)2, (Integer)((Integer)this.session.getResourceValue("dynamic-provider2", "data", "value", Integer.class)));
            this.queue.clear();
            this.queue2.clear();
            content = template.replace("$val1$", "10").replace("$val2$", "20");
            handler.setData("/data", content);
            Assertions.assertNotNull((Object)this.queue.poll(5L, TimeUnit.SECONDS));
            Assertions.assertNotNull((Object)this.queue2.poll(1L, TimeUnit.SECONDS));
            this.assertNotifications(10, 20, 10);
            ResourceDescription resource = this.session.describeResource("dynamic-provider1", "data", "value");
            Instant secondTimestamp = resource.timestamp;
            Instant compare = firstTimestamp.plus(1L, ChronoUnit.SECONDS);
            Assertions.assertTrue((boolean)secondTimestamp.isAfter(compare), (String)("Expected " + secondTimestamp + " to be after " + compare + " after " + handler.nbVisits("/data") + " visits to /data"));
            Assertions.assertEquals((int)10, (Integer)((Integer)this.session.getResourceValue("dynamic-provider1", "data", "value", Integer.class)));
            Assertions.assertEquals((int)20, (Integer)((Integer)this.session.getResourceValue("dynamic-provider2", "data", "value", Integer.class)));
            Assertions.assertEquals((int)1, (int)handler.nbVisitedPaths());
            Assertions.assertEquals((int)2, (int)handler.nbVisits("/data"));
        }
        finally {
            config.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testCombined() throws Exception {
        String provider1 = "station1";
        String provider2 = "station2";
        this.setupProvidersHandling("station1", "station2");
        String staticInputFileName = "csv-station-static";
        handler.setData("/static", this.readFile("csv-station-static.csv"));
        String staticMappingConfig = new String(this.readFile("csv-station-static-mapping.json"));
        String dynamicInputFileName = "csv-station-dynamic";
        String template = new String(this.readFile("csv-station-dynamic.csv"));
        String dynamicMappingConfig = new String(this.readFile("csv-station-dynamic-mapping.json"));
        handler.setData("/dynamic", template.replace("$val1$", "21").replace("$val2$", "42"));
        Configuration config = this.configAdmin.createFactoryConfiguration("sensinact.http.device.factory", "?");
        try {
            Instant start = Instant.now();
            config.update(new Hashtable<String, CallSite>(Map.of("tasks.oneshot", "[{\"url\": \"http://localhost:" + httpPort + "/static\", \"mapping\": " + staticMappingConfig + "}]", "tasks.periodic", "[{\"period\": 2, \"url\": \"http://localhost:" + httpPort + "/dynamic\", \"mapping\": " + dynamicMappingConfig + "}]")));
            boolean gotLocation = false;
            boolean gotValue = false;
            block11: while (!gotLocation || !gotValue) {
                ResourceDataNotification notif = this.queue.poll(1L, TimeUnit.SECONDS);
                Assertions.assertNotNull((Object)notif);
                switch (notif.resource) {
                    case "value": {
                        gotValue = true;
                        continue block11;
                    }
                    case "location": {
                        gotLocation = true;
                        continue block11;
                    }
                }
                if (Duration.between(start, Instant.now()).toMillis() <= 1500L) continue;
                Assertions.fail((String)"Timeout waiting for updates");
            }
            Assertions.assertNotNull((Object)this.queue2.poll(1L, TimeUnit.SECONDS));
            Assertions.assertEquals((int)2, (int)handler.nbVisitedPaths());
            Assertions.assertEquals((int)1, (int)handler.nbVisits("/static"));
            Assertions.assertEquals((int)1, (int)handler.nbVisits("/dynamic"));
            Instant firstValueTimestamp = this.session.describeResource((String)"station1", (String)"data", (String)"value").timestamp;
            Assertions.assertFalse((boolean)firstValueTimestamp.isBefore(start));
            Assertions.assertEquals((int)21, (Integer)((Integer)this.session.getResourceValue("station1", "data", "value", Integer.class)));
            Assertions.assertEquals((int)42, (Integer)((Integer)this.session.getResourceValue("station2", "data", "value", Integer.class)));
            ResourceDescription location1 = this.session.describeResource("station1", "admin", "location");
            Instant firstLocationTimestamp = location1.timestamp;
            Assertions.assertNotNull((Object)location1.value);
            Point geoPoint = (Point)location1.value;
            Assertions.assertEquals((double)45.185, (double)geoPoint.coordinates.latitude, (double)0.001);
            Assertions.assertEquals((double)5.735, (double)geoPoint.coordinates.longitude, (double)0.001);
            Assertions.assertTrue((boolean)Double.isNaN(geoPoint.coordinates.elevation));
            this.queue.clear();
            this.queue2.clear();
            handler.setData("/dynamic", template.replace("$val1$", "38").replace("$val2$", "15"));
            this.assertNotifications(38, 15, 10);
            Instant secondTimestamp = this.session.describeResource((String)"station1", (String)"data", (String)"value").timestamp;
            Assertions.assertTrue((boolean)secondTimestamp.isAfter(firstValueTimestamp.plus(1L, ChronoUnit.SECONDS)));
            Assertions.assertEquals((int)38, (Integer)((Integer)this.session.getResourceValue("station1", "data", "value", Integer.class)));
            Assertions.assertEquals((int)15, (Integer)((Integer)this.session.getResourceValue("station2", "data", "value", Integer.class)));
            Assertions.assertNotEquals((Object)firstLocationTimestamp, (Object)secondTimestamp);
            Assertions.assertEquals((Object)firstLocationTimestamp, (Object)this.session.describeResource((String)"station1", (String)"admin", (String)"location").timestamp);
            Assertions.assertEquals((int)2, (int)handler.nbVisitedPaths());
            Assertions.assertEquals((int)1, (int)handler.nbVisits("/static"));
            Assertions.assertEquals((int)2, (int)handler.nbVisits("/dynamic"));
        }
        finally {
            config.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testError() throws Exception {
        Logger logger = (Logger)LoggerFactory.getLogger(HttpDeviceFactory.class);
        final ArrayBlockingQueue queue = new ArrayBlockingQueue(128);
        AppenderBase<ILoggingEvent> logSpy = new AppenderBase<ILoggingEvent>(){

            protected void append(ILoggingEvent eventObject) {
                try {
                    queue.put(eventObject.getFormattedMessage());
                }
                catch (Exception e) {
                    Assertions.fail((Throwable)e);
                }
            }
        };
        logSpy.start();
        logger.addAppender((Appender)logSpy);
        Configuration config = this.configAdmin.createFactoryConfiguration("sensinact.http.device.factory", "?");
        try {
            DeviceMappingConfigurationDTO mappingConf = new DeviceMappingConfigurationDTO();
            mappingConf.mapping = Map.of("@provider", "provider");
            Map<String, DeviceMappingConfigurationDTO> httpMapping = Map.of("url", "http://localhost:" + httpPort + "/non-existent", "mapping", mappingConf);
            config.update(new Hashtable<String, String>(Map.of("tasks.oneshot", this.mapper.writeValueAsString(List.of(httpMapping)))));
            String errorMessage = (String)queue.poll(1L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)errorMessage);
            Assertions.assertTrue((boolean)errorMessage.contains("404"));
            httpMapping = Map.of("url", "https://localhost:" + httpPort + "/static", "mapping", mappingConf);
            config.update(new Hashtable<String, String>(Map.of("tasks.oneshot", this.mapper.writeValueAsString(List.of(httpMapping)))));
            errorMessage = (String)queue.poll(1L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)errorMessage);
            Assertions.assertTrue((boolean)errorMessage.contains("SSLHandshakeException"));
        }
        finally {
            logger.detachAppender((Appender)logSpy);
            logSpy.stop();
            config.delete();
        }
    }
}

