/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.southbound.http.factory.integration;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class RequestHandler
extends AbstractHandler {
    private final Map<String, byte[]> serverData = new HashMap<String, byte[]>();
    private final Map<String, Integer> queryPause = new HashMap<String, Integer>();
    private final Map<String, AtomicInteger> serverVisits = Collections.synchronizedMap(new HashMap());
    private final Map<String, Instant> lastVisitTimes = Collections.synchronizedMap(new HashMap());

    public void setData(String path, byte[] data) {
        this.serverData.put(path, data);
    }

    public void setData(String path, String data) {
        this.serverData.put(path, data.getBytes());
    }

    public void setPause(String path, int pause) {
        if (pause <= 0) {
            this.queryPause.remove(path);
        } else {
            this.queryPause.put(path, pause);
        }
    }

    public void clear() {
        this.serverData.clear();
        this.serverVisits.clear();
        this.queryPause.clear();
        this.lastVisitTimes.clear();
    }

    public int nbVisitedPaths() {
        return this.serverVisits.size();
    }

    public int nbVisits(String path) {
        return this.serverVisits.getOrDefault(path, new AtomicInteger()).get();
    }

    public Instant lastVisitTime(String path) {
        return this.lastVisitTimes.get(path);
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        byte[] content;
        baseRequest.setHandled(true);
        try {
            baseRequest.authenticate(response);
        }
        catch (ServletException e) {
            response.sendError(401);
            return;
        }
        this.lastVisitTimes.put(target, Instant.now());
        Integer pause = this.queryPause.get(target);
        if (pause != null) {
            try {
                Thread.sleep(pause.intValue());
            }
            catch (InterruptedException e) {
                response.sendError(500);
                return;
            }
        }
        if ((content = this.serverData.get(target)) != null) {
            this.serverVisits.computeIfAbsent(target, k -> new AtomicInteger()).incrementAndGet();
            response.setStatus(200);
            response.setContentLength(content.length);
            response.getOutputStream().write(content);
            response.flushBuffer();
        } else {
            response.sendError(404);
        }
    }
}

