/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.southbound.http.factory;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.BasicAuthentication;
import org.eclipse.jetty.client.util.BufferingResponseListener;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.sensinact.gateway.southbound.device.factory.DeviceFactoryException;
import org.eclipse.sensinact.gateway.southbound.device.factory.IDeviceMappingHandler;
import org.eclipse.sensinact.gateway.southbound.http.factory.ParsedHttpPeriodicTask;
import org.eclipse.sensinact.gateway.southbound.http.factory.ParsedHttpTask;
import org.eclipse.sensinact.gateway.southbound.http.factory.SharedHttpClientResources;
import org.eclipse.sensinact.gateway.southbound.http.factory.config.HttpDeviceFactoryConfiguration;
import org.eclipse.sensinact.gateway.southbound.http.factory.config.HttpDeviceFactoryConfigurationPeriodicDTO;
import org.eclipse.sensinact.gateway.southbound.http.factory.config.HttpDeviceFactoryConfigurationTaskDTO;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={}, configurationPid={"sensinact.http.device.factory"}, configurationPolicy=ConfigurationPolicy.REQUIRE)
public class HttpDeviceFactory {
    private static final Logger logger = LoggerFactory.getLogger(HttpDeviceFactory.class);
    @Reference
    private IDeviceMappingHandler mappingHandler;
    @Reference
    private SharedHttpClientResources rcSharer;
    private ScheduledThreadPoolExecutor scheduledExecutor;

    @Activate
    void activate(HttpDeviceFactoryConfiguration configuration) throws Exception {
        HttpDeviceFactoryConfigurationPeriodicDTO[] periodicTasks;
        this.scheduledExecutor = new ScheduledThreadPoolExecutor(1);
        ObjectMapper mapper = new ObjectMapper();
        HttpDeviceFactoryConfigurationTaskDTO[] oneShotTasks = this.loadTasks(mapper, HttpDeviceFactoryConfigurationTaskDTO.class, configuration.tasks_oneshot());
        if (oneShotTasks != null) {
            for (HttpDeviceFactoryConfigurationTaskDTO task : oneShotTasks) {
                this.runTask(new ParsedHttpTask(task));
            }
        }
        if ((periodicTasks = this.loadTasks(mapper, HttpDeviceFactoryConfigurationPeriodicDTO.class, configuration.tasks_periodic())) != null) {
            for (HttpDeviceFactoryConfigurationPeriodicDTO task : periodicTasks) {
                this.runScheduledTask(new ParsedHttpPeriodicTask(task));
            }
        }
    }

    @Deactivate
    void deactivate() throws Exception {
        this.scheduledExecutor.shutdownNow();
        this.scheduledExecutor = null;
    }

    private <T> T[] loadTasks(ObjectMapper mapper, Class<T> type, String[] strTasks) throws Exception {
        if (strTasks != null) {
            if (strTasks.length == 1 && strTasks[0].startsWith("[")) {
                return (Object[])mapper.readValue(strTasks[0], Array.newInstance(type, 0).getClass());
            }
            Object[] result = (Object[])Array.newInstance(type, strTasks.length);
            int i = 0;
            for (String rawPeriodicTask : strTasks) {
                result[i++] = mapper.readValue(rawPeriodicTask, type);
            }
            return result;
        }
        return null;
    }

    private void runTask(final ParsedHttpTask task) {
        try {
            final HttpClient client = this.rcSharer.newClient(task);
            client.start();
            Request request = client.newRequest(task.url);
            request.method(task.method);
            request.headers(headers -> {
                for (ParsedHttpTask.KeyValue<String, String> header : task.getHeaders()) {
                    headers.add(header.key(), header.value());
                }
            });
            if (task.authUser != null) {
                BasicAuthentication.BasicResult authn = new BasicAuthentication.BasicResult(null, task.authUser, task.authPassword);
                authn.apply(request);
            }
            request.send((Response.CompleteListener)new BufferingResponseListener(task.getBufferSize()){
                private final AtomicReference<Map<String, String>> headers;
                {
                    super(arg0);
                    this.headers = new AtomicReference(Map.of());
                }

                public void onHeaders(Response response) {
                    super.onHeaders(response);
                    this.headers.set(response.getHeaders().getFieldNamesCollection().stream().collect(Collectors.toMap(Function.identity(), h -> response.getHeaders().get(h))));
                }

                public void onFailure(Response response, Throwable failure) {
                    logger.error("Error accessing {}: {} ({})", new Object[]{task.url, failure.getMessage(), failure.getClass().getName(), failure});
                }

                public void onSuccess(Response response) {
                    int status = response.getStatus();
                    if (status >= 200 && status < 300) {
                        try {
                            HttpDeviceFactory.this.mappingHandler.handle(task.mapping, this.headers.get(), this.getContent());
                        }
                        catch (DeviceFactoryException e) {
                            logger.error("Error parsing input from {}: {}", new Object[]{task.url, e.getMessage(), e});
                        }
                    } else {
                        logger.error("HTTP error {} accessing {}", (Object)status, (Object)task.url);
                    }
                }

                public void onComplete(Result result) {
                    HttpDeviceFactory.this.scheduledExecutor.submit(() -> LifeCycle.stop((Object)client));
                }
            });
        }
        catch (Exception ex) {
            logger.error("Error querying {}", (Object)task.url, (Object)ex);
        }
    }

    private void runScheduledTask(ParsedHttpPeriodicTask periodicTask) {
        this.runTask(periodicTask);
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.schedule(() -> this.runScheduledTask(periodicTask), periodicTask.period, TimeUnit.SECONDS);
        }
    }
}

