/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.southbound.http.factory;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.sensinact.gateway.southbound.device.factory.dto.DeviceMappingConfigurationDTO;
import org.eclipse.sensinact.gateway.southbound.http.factory.config.HttpDeviceFactoryConfigurationTaskDTO;

public class ParsedHttpTask {
    private static final int MIN_BUFFER_SIZE = 512;
    public final int timeout;
    private final int bufferSize;
    public final String method;
    public final String url;
    public final boolean ignoreSslErrors;
    public final String keystorePath;
    public final String keystorePassword;
    public final String trustStorePath;
    public final String trustStorePassword;
    public final String authUser;
    public final String authPassword;
    public final boolean followHttpRedirect;
    private final List<KeyValue<String, String>> headers = new ArrayList<KeyValue<String, String>>();
    public final DeviceMappingConfigurationDTO mapping;

    public ParsedHttpTask(HttpDeviceFactoryConfigurationTaskDTO task) throws JsonMappingException, JsonProcessingException {
        this.method = task.method != null && !task.method.isBlank() ? task.method : "GET";
        this.url = task.url;
        if (this.url == null || this.url.isBlank()) {
            throw new IllegalArgumentException("No URL given");
        }
        this.followHttpRedirect = task.httpFollowRedirect;
        this.ignoreSslErrors = task.sslIgnoreErrors;
        this.keystorePath = task.sslKeyStore;
        this.keystorePassword = task.sslKeyStorePassword;
        this.trustStorePath = task.sslTrustStore;
        this.trustStorePassword = task.sslTrustStorePassword;
        this.authUser = task.authUser;
        this.authPassword = task.authPassword;
        this.timeout = task.timeout;
        this.bufferSize = task.bufferSize < 512 ? 512 : task.bufferSize;
        JsonNode jsonHeaders = task.headers;
        if (jsonHeaders != null) {
            this.parseHeaders(jsonHeaders);
        }
        this.mapping = task.mapping;
        if (this.mapping == null) {
            throw new IllegalArgumentException("No mapping given");
        }
    }

    private void parseHeaders(JsonNode headersRoot) throws JsonMappingException, JsonProcessingException {
        if (headersRoot.isArray()) {
            for (int i = 0; i < headersRoot.size(); ++i) {
                JsonNode header = headersRoot.get(i);
                if (!header.isObject()) {
                    throw new IllegalArgumentException("Headers should be an array of objects");
                }
                this.headers.add(new KeyValue<String, String>(header.get("header").asText(), header.get("value").asText()));
            }
        } else {
            Iterator iterator = headersRoot.fields();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                String header = (String)entry.getKey();
                if (header == null || header.isBlank()) continue;
                this.headers.add(new KeyValue<String, String>(header, ((JsonNode)entry.getValue()).asText()));
            }
        }
    }

    public List<KeyValue<String, String>> getHeaders() {
        return List.copyOf(this.headers);
    }

    public int getBufferSize() {
        return this.bufferSize * 1024;
    }

    public static class KeyValue<K, V> {
        private final K key;
        private final V value;

        public KeyValue(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K key() {
            return this.key;
        }

        public V value() {
            return this.value;
        }
    }
}

