/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.launcher;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.eclipse.sensinact.gateway.launcher.ConfigurationManager;
import org.eclipse.sensinact.gateway.launcher.FeatureLauncher;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.service.feature.FeatureService;

@ExtendWith(value={MockitoExtension.class})
class FeatureLaunchingMultipleFoldersTest {
    private static final String GROUP_ID = "org.eclipse.sensinact.gateway.launcher.test";
    @Mock
    BundleContext context;
    @Mock
    FeatureLauncher.Config config;
    @Mock
    ConfigurationManager manager;
    FeatureLauncher fl = new FeatureLauncher();
    private FeatureService fs;
    private Map<String, Bundle> installed = new HashMap<String, Bundle>();
    private Map<String, String> contents = new HashMap<String, String>();

    FeatureLaunchingMultipleFoldersTest() {
    }

    @BeforeEach
    void start() throws Exception {
        ServiceLoader<FeatureService> loader = ServiceLoader.load(FeatureService.class);
        this.fs = loader.findFirst().get();
        BundleRevision revMock = (BundleRevision)Mockito.mock(BundleRevision.class);
        Mockito.lenient().when((Object)revMock.getTypes()).thenReturn((Object)0);
        Mockito.lenient().when((Object)this.config.featureDir()).thenReturn((Object)new String[]{"src/test/resources/features2", "src/test/resources/features"});
        Mockito.lenient().when((Object)this.config.repository()).thenReturn((Object)new String[]{"src/test/resources/repository2", "src/test/resources/repository"});
        Mockito.lenient().when((Object)this.context.installBundle(Mockito.anyString(), (InputStream)Mockito.any())).thenAnswer(i -> {
            String fromIs;
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)i.getArgument(1, InputStream.class)));){
                fromIs = br.readLine();
            }
            String name = (String)i.getArgument(0, String.class);
            this.contents.put(name, fromIs);
            Bundle bundleMock = (Bundle)Mockito.mock(Bundle.class, (String)fromIs);
            Mockito.lenient().when((Object)((BundleRevision)bundleMock.adapt((Class)ArgumentMatchers.eq(BundleRevision.class)))).thenReturn((Object)revMock);
            this.installed.put(name, bundleMock);
            return bundleMock;
        });
        this.fl.featureService = this.fs;
        this.fl.configManager = this.manager;
    }

    String getIdString(String groupId, String artifactId, String version, String type, String classifier) {
        if (classifier == null || classifier.isBlank()) {
            if (type == null || type.isBlank()) {
                return this.fs.getID(groupId, artifactId, version).toString();
            }
            return this.fs.getID(groupId, artifactId, version, type).toString();
        }
        return this.fs.getID(groupId, artifactId, version, type, classifier).toString();
    }

    @Test
    void testFeatureOverride() throws Exception {
        Mockito.when((Object)this.config.features()).thenReturn((Object)new String[]{"foo"});
        this.fl.start(this.context, this.config);
        String bundleId = this.getIdString(GROUP_ID, "buzz", "1.0.0", null, null);
        String bundleIdContent = this.getIdString(GROUP_ID, "buzz-repo2", "1.0.0", null, null);
        String bundleId2 = this.getIdString(GROUP_ID, "buzz", "1.0.1", null, null);
        String bundleId3 = this.getIdString(GROUP_ID, "buzz", "1.0.2-SNAPSHOT", null, null);
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.context, this.installed.get(bundleId), this.installed.get(bundleId2), this.installed.get(bundleId3)});
        ((BundleContext)order.verify((Object)this.context)).installBundle((String)ArgumentMatchers.eq((Object)bundleId), (InputStream)ArgumentMatchers.any());
        ((BundleContext)order.verify((Object)this.context)).installBundle((String)ArgumentMatchers.eq((Object)bundleId2), (InputStream)ArgumentMatchers.any());
        ((BundleContext)order.verify((Object)this.context)).installBundle((String)ArgumentMatchers.eq((Object)bundleId3), (InputStream)ArgumentMatchers.any());
        ((Bundle)order.verify((Object)this.installed.get(bundleId))).start();
        ((Bundle)order.verify((Object)this.installed.get(bundleId2))).start();
        ((Bundle)order.verify((Object)this.installed.get(bundleId3))).start();
        Assertions.assertEquals((Object)bundleIdContent, (Object)this.contents.get(bundleId));
        Assertions.assertEquals((Object)bundleId2, (Object)this.contents.get(bundleId2));
        Assertions.assertEquals((Object)bundleId3, (Object)this.contents.get(bundleId3));
    }

    @Test
    void testFeatureNoOverride() throws Exception {
        Mockito.when((Object)this.config.features()).thenReturn((Object)new String[]{"bar"});
        this.fl.start(this.context, this.config);
        String bundleId = this.getIdString(GROUP_ID, "buzz", "1.0.2-SNAPSHOT", null, null);
        String bundleId2 = this.getIdString(GROUP_ID, "buzz", "1.0.0", null, null);
        String bundleId2Content = this.getIdString(GROUP_ID, "buzz-repo2", "1.0.0", null, null);
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.context, this.installed.get(bundleId), this.installed.get(bundleId2)});
        ((BundleContext)order.verify((Object)this.context)).installBundle((String)ArgumentMatchers.eq((Object)bundleId), (InputStream)ArgumentMatchers.any());
        ((BundleContext)order.verify((Object)this.context)).installBundle((String)ArgumentMatchers.eq((Object)bundleId2), (InputStream)ArgumentMatchers.any());
        ((Bundle)order.verify((Object)this.installed.get(bundleId))).start();
        ((Bundle)order.verify((Object)this.installed.get(bundleId2))).start();
        Assertions.assertEquals((Object)bundleId, (Object)this.contents.get(bundleId));
        Assertions.assertEquals((Object)bundleId2Content, (Object)this.contents.get(bundleId2));
    }
}

