/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.launcher.integration;

import java.net.ConnectException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpConnectTimeoutException;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.time.Duration;
import org.eclipse.sensinact.gateway.feature.utilities.test.ServerProcessHandler;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

class FeatureLaunchingIntegrationTest {
    private static ServerProcessHandler server = new ServerProcessHandler();

    FeatureLaunchingIntegrationTest() {
    }

    @BeforeAll
    static void startServer() throws Exception {
        Files.copy(Paths.get("target/export.jar", new String[0]), Paths.get("target/it/launcher.jar", new String[0]), StandardCopyOption.REPLACE_EXISTING);
        server.startSensinact();
    }

    @AfterAll
    static void stopServer() throws Exception {
        server.stopSensinact();
    }

    @Test
    void testHttp() throws Exception {
        HttpClient client = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(5L)).build();
        HttpRequest request = HttpRequest.newBuilder(URI.create("http://localhost:8081")).GET().build();
        for (int i = 0; i < 10; ++i) {
            if (!server.isAlive()) {
                Assertions.fail((String)"Server process lost");
            }
            try {
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                Assertions.assertEquals((int)404, (int)response.statusCode());
                return;
            }
            catch (ConnectException | HttpConnectTimeoutException timeout) {
                Thread.sleep(1000L);
                continue;
            }
        }
        Assertions.fail((String)"Did not contact the server");
    }
}

